/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.plugin;

import com.google.common.collect.Ordering;
import de.is24.deadcode4j.AnalysisStage;
import de.is24.deadcode4j.DeadCode;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.logging.Log;

class DeadCodeLogger {
    private final Log log;

    public DeadCodeLogger(Log log) {
        this.log = log;
    }

    public void log(@Nonnull DeadCode deadCode) {
        this.logExceptions(deadCode.getStagesWithExceptions());
        this.logAnalyzedClasses(deadCode.getAnalyzedClasses());
        this.logDeadClasses(deadCode.getDeadClasses());
    }

    private void logExceptions(EnumSet<AnalysisStage> stagesWithExceptions) {
        block6: for (AnalysisStage stageWithException : stagesWithExceptions) {
            switch (stageWithException) {
                case GENERAL_SETUP: {
                    this.log.error((CharSequence)"Failed to set up deadcode4j. Analysis was certainly inaccurate.");
                    continue block6;
                }
                case MODULE_SETUP: {
                    this.log.warn((CharSequence)"Failed to set up at least one module. Analysis is likely to be inaccurate.");
                    continue block6;
                }
                case FILE_ANALYSIS: {
                    this.log.warn((CharSequence)"At least one file could not be parsed; analysis may be inaccurate!");
                    continue block6;
                }
                case DEADCODE_ANALYSIS: {
                    this.log.warn((CharSequence)"Failed to determine dead code. Analysis was certainly inaccurate.");
                    continue block6;
                }
            }
            this.log.warn((CharSequence)"An unexpected error occurred.");
        }
    }

    private void logAnalyzedClasses(@Nonnull Collection<String> analyzedClasses) {
        this.log.info((CharSequence)("Analyzed " + analyzedClasses.size() + " class(es)."));
    }

    private void logDeadClasses(@Nonnull Collection<String> deadClasses) {
        int numberOfDeadClasses = deadClasses.size();
        if (numberOfDeadClasses == 0) {
            this.log.info((CharSequence)"No unused classes found. Rejoice!");
            return;
        }
        this.log.warn((CharSequence)("Found " + numberOfDeadClasses + " unused class(es):"));
        for (String unusedClass : Ordering.natural().sortedCopy(deadClasses)) {
            this.log.warn((CharSequence)("  " + unusedClass));
        }
    }
}

