/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.plugin;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.Analyzer;
import de.is24.deadcode4j.DeadCode;
import de.is24.deadcode4j.DeadCodeComputer;
import de.is24.deadcode4j.DeadCodeFinder;
import de.is24.deadcode4j.Module;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.analyzer.AopXmlAnalyzer;
import de.is24.deadcode4j.analyzer.ApacheTilesAnalyzer;
import de.is24.deadcode4j.analyzer.CastorClassesAnalyzer;
import de.is24.deadcode4j.analyzer.ClassDependencyAnalyzer;
import de.is24.deadcode4j.analyzer.CustomAnnotationsAnalyzer;
import de.is24.deadcode4j.analyzer.CustomInterfacesAnalyzer;
import de.is24.deadcode4j.analyzer.CustomSuperClassAnalyzer;
import de.is24.deadcode4j.analyzer.CustomXmlAnalyzer;
import de.is24.deadcode4j.analyzer.FacesConfigXmlAnalyzer;
import de.is24.deadcode4j.analyzer.HibernateAnnotationsAnalyzer;
import de.is24.deadcode4j.analyzer.IgnoreClassesAnalyzer;
import de.is24.deadcode4j.analyzer.JeeAnnotationsAnalyzer;
import de.is24.deadcode4j.analyzer.JerseyWebXmlAnalyzer;
import de.is24.deadcode4j.analyzer.JettyXmlAnalyzer;
import de.is24.deadcode4j.analyzer.MainClassAnalyzer;
import de.is24.deadcode4j.analyzer.ReferenceToConstantsAnalyzer;
import de.is24.deadcode4j.analyzer.ServletContainerInitializerAnalyzer;
import de.is24.deadcode4j.analyzer.SpringAnnotationsAnalyzer;
import de.is24.deadcode4j.analyzer.SpringDataCustomRepositoriesAnalyzer;
import de.is24.deadcode4j.analyzer.SpringNamespaceHandlerAnalyzer;
import de.is24.deadcode4j.analyzer.SpringWebApplicationInitializerAnalyzer;
import de.is24.deadcode4j.analyzer.SpringWebFlowAnalyzer;
import de.is24.deadcode4j.analyzer.SpringWebXmlAnalyzer;
import de.is24.deadcode4j.analyzer.SpringXmlAnalyzer;
import de.is24.deadcode4j.analyzer.TldAnalyzer;
import de.is24.deadcode4j.analyzer.TypeErasureAnalyzer;
import de.is24.deadcode4j.analyzer.WebXmlAnalyzer;
import de.is24.deadcode4j.analyzer.WsddAnalyzer;
import de.is24.deadcode4j.plugin.CustomXml;
import de.is24.deadcode4j.plugin.DeadCodeLogger;
import de.is24.deadcode4j.plugin.ModuleGenerator;
import de.is24.deadcode4j.plugin.UsageStatisticsManager;
import de.is24.maven.UpdateChecker;
import de.is24.maven.slf4j.AbstractSlf4jMojo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="find-only", aggregator=true, requiresProject=true, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class FindDeadCodeOnlyMojo
extends AbstractSlf4jMojo {
    @Parameter
    private Set<String> annotationsMarkingLiveCode = Collections.emptySet();
    @Parameter
    private Set<String> classesToIgnore = Collections.emptySet();
    @Parameter
    private List<CustomXml> customXmls = Collections.emptyList();
    @Parameter
    private boolean ignoreMainClasses = false;
    @Parameter
    private Set<String> interfacesMarkingLiveCode = Collections.emptySet();
    @Component
    private MavenProject project;
    @Parameter
    private List<String> modulesToSkip = Collections.emptyList();
    @Component
    private MojoExecution mojoExecution;
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(property="deadcode4j.skipSendingStatistics")
    private Boolean skipSendingUsageStatistics;
    @Parameter(property="deadcode4j.skipUpdate")
    private boolean skipUpdateCheck = false;
    @Parameter
    private Set<String> superClassesMarkingLiveCode = Collections.emptySet();
    @Component
    private UpdateChecker updateChecker;
    @Parameter(property="deadcode4j.statisticsComment")
    private String usageStatisticsComment;
    @Component
    private UsageStatisticsManager usageStatisticsManager;

    @Override
    public void doExecute() throws MojoExecutionException {
        try {
            this.checkForUpdate();
            this.logWelcome();
            DeadCode deadCode = this.analyzeCode();
            this.log(deadCode);
            this.logGoodbye();
            this.sendStatistics(deadCode);
        }
        catch (RuntimeException rE) {
            this.getLog().error((CharSequence)"An unexpected exception occurred. Please consider reporting an issue at https://github.com/ImmobilienScout24/deadcode4j/issues", (Throwable)rE);
            throw rE;
        }
    }

    private void sendStatistics(DeadCode deadCode) {
        UsageStatisticsManager.DeadCodeStatistics deadCodeStatistics = new UsageStatisticsManager.DeadCodeStatistics(this.skipSendingUsageStatistics, this.usageStatisticsComment);
        deadCodeStatistics.config_ignoreMainClasses = this.ignoreMainClasses;
        deadCodeStatistics.config_numberOfClassesToIgnore = this.classesToIgnore.size();
        deadCodeStatistics.config_numberOfCustomAnnotations = this.annotationsMarkingLiveCode.size();
        deadCodeStatistics.config_numberOfCustomInterfaces = this.interfacesMarkingLiveCode.size();
        deadCodeStatistics.config_numberOfCustomSuperclasses = this.superClassesMarkingLiveCode.size();
        deadCodeStatistics.config_numberOfCustomXmlDefinitions = this.customXmls.size();
        deadCodeStatistics.config_numberOfModulesToSkip = this.modulesToSkip.size();
        deadCodeStatistics.config_skipUpdateCheck = this.skipUpdateCheck;
        deadCodeStatistics.numberOfAnalyzedClasses = deadCode.getAnalyzedClasses().size();
        deadCodeStatistics.numberOfAnalyzedModules = this.reactorProjects.size();
        deadCodeStatistics.numberOfDeadClassesFound = deadCode.getDeadClasses().size();
        this.usageStatisticsManager.sendUsageStatistics(deadCodeStatistics);
    }

    private void checkForUpdate() {
        if (this.skipUpdateCheck) {
            return;
        }
        Optional<ArtifactVersion> mostRecentVersion = this.updateChecker.checkForUpdate(this.mojoExecution);
        if (mostRecentVersion.isPresent()) {
            this.getLog().warn((CharSequence)("The new version [" + mostRecentVersion.get() + "] is available; consider updating for better analysis results!"));
        }
    }

    private void logWelcome() {
        if (this.mojoExecution != null && MojoExecution.Source.CLI.equals((Object)this.mojoExecution.getSource())) {
            this.getLog().info((CharSequence)"Thanks for calling me! Let's see what I can do for you...");
        }
    }

    private DeadCode analyzeCode() throws MojoExecutionException {
        HashSet analyzers = Sets.newHashSet((Object[])new Analyzer[]{new AopXmlAnalyzer(), new ApacheTilesAnalyzer(), new CastorClassesAnalyzer(), new ClassDependencyAnalyzer(), new FacesConfigXmlAnalyzer(), new HibernateAnnotationsAnalyzer(), new JeeAnnotationsAnalyzer(), new JerseyWebXmlAnalyzer(), new JettyXmlAnalyzer(), new ReferenceToConstantsAnalyzer(), new ServletContainerInitializerAnalyzer(), new SpringAnnotationsAnalyzer(), new SpringDataCustomRepositoriesAnalyzer(), new SpringNamespaceHandlerAnalyzer(), new SpringWebApplicationInitializerAnalyzer(), new SpringWebFlowAnalyzer(), new SpringWebXmlAnalyzer(), new SpringXmlAnalyzer(), new TldAnalyzer(), new TypeErasureAnalyzer(), new WebXmlAnalyzer(), new WsddAnalyzer()});
        DeadCodeComputer deadCodeComputer = new DeadCodeComputer();
        this.addCustomAnnotationsAnalyzerIfConfigured(analyzers);
        this.addCustomInterfacesAnalyzerIfConfigured(analyzers);
        this.addCustomSuperClassesAnalyzerIfConfigured(analyzers);
        this.addCustomXmlAnalyzerIfConfigured(analyzers);
        this.addIgnoreClassesAnalyzerIfConfigured(deadCodeComputer, analyzers);
        this.addMainClassAnalyzerIfConfigured(analyzers);
        DeadCodeFinder deadCodeFinder = new DeadCodeFinder(deadCodeComputer, analyzers);
        return deadCodeFinder.findDeadCode(this.gatherModules());
    }

    private void addCustomAnnotationsAnalyzerIfConfigured(Set<Analyzer> analyzers) {
        if (this.annotationsMarkingLiveCode.isEmpty()) {
            return;
        }
        analyzers.add(new CustomAnnotationsAnalyzer(this.annotationsMarkingLiveCode));
        this.getLog().info((CharSequence)("Treating classes annotated with any of " + this.annotationsMarkingLiveCode + " as live code."));
    }

    private void addCustomInterfacesAnalyzerIfConfigured(Set<Analyzer> analyzers) {
        if (this.interfacesMarkingLiveCode.isEmpty()) {
            return;
        }
        analyzers.add(new CustomInterfacesAnalyzer(this.interfacesMarkingLiveCode));
        this.getLog().info((CharSequence)("Treating classes implementing any of " + this.interfacesMarkingLiveCode + " as live code."));
    }

    private void addCustomSuperClassesAnalyzerIfConfigured(Set<Analyzer> analyzers) {
        if (this.superClassesMarkingLiveCode.isEmpty()) {
            return;
        }
        analyzers.add(new CustomSuperClassAnalyzer(this.superClassesMarkingLiveCode));
        this.getLog().info((CharSequence)("Treating classes being subclasses of any of " + this.superClassesMarkingLiveCode + " as live code."));
    }

    private void addCustomXmlAnalyzerIfConfigured(Set<Analyzer> analyzers) {
        if (this.customXmls.isEmpty()) {
            return;
        }
        for (CustomXml customXml : this.customXmls) {
            CustomXmlAnalyzer customXmlAnalyzer = new CustomXmlAnalyzer(customXml.getEndOfFileName(), customXml.getRootElement());
            Preconditions.checkArgument((!customXml.getXPaths().isEmpty() ? 1 : 0) != 0, (Object)"At least one entry for [xPaths] must be set!");
            for (String xPath : customXml.getXPaths()) {
                customXmlAnalyzer.registerXPath(xPath);
                String rootPath = customXml.getRootElement() == null ? "" : "/" + customXml.getRootElement();
                this.getLog().info((CharSequence)("Treating classes found at [" + rootPath + "//" + xPath + "] in [" + customXml.getEndOfFileName() + "] files as live code."));
            }
            analyzers.add(customXmlAnalyzer);
        }
    }

    private void addIgnoreClassesAnalyzerIfConfigured(DeadCodeComputer deadCodeComputer, Set<Analyzer> analyzers) {
        if (this.classesToIgnore.isEmpty()) {
            return;
        }
        analyzers.add(new IgnoreClassesAnalyzer(deadCodeComputer, this.classesToIgnore));
    }

    private void addMainClassAnalyzerIfConfigured(Set<Analyzer> analyzers) {
        if (!this.ignoreMainClasses) {
            return;
        }
        analyzers.add(new MainClassAnalyzer());
        this.getLog().info((CharSequence)"Treating classes with a main method as live code.");
    }

    private Iterable<Module> gatherModules() throws MojoExecutionException {
        ModuleGenerator moduleGenerator = new ModuleGenerator(this.repositorySystem);
        return moduleGenerator.getModulesFor(this.getProjectsToAnalyze());
    }

    private Collection<MavenProject> getProjectsToAnalyze() {
        if (this.modulesToSkip.isEmpty()) {
            return this.reactorProjects;
        }
        ArrayList unknownModules = Lists.newArrayList(this.modulesToSkip);
        int baseDirPathIndex = this.project.getBasedir().getAbsolutePath().length() + 1;
        ArrayList mavenProjects = Lists.newArrayList(this.reactorProjects);
        for (MavenProject mavenProject : this.reactorProjects) {
            String projectPath;
            String modulePath;
            if (this.project.equals((Object)mavenProject) || !this.modulesToSkip.contains(modulePath = (projectPath = mavenProject.getBasedir().getAbsolutePath()).substring(baseDirPathIndex))) continue;
            unknownModules.remove(modulePath);
            this.getLog().info((CharSequence)("Project [" + Utils.getKeyFor(mavenProject) + "] will be skipped."));
            mavenProjects.remove(mavenProject);
            List collectedProjects = mavenProject.getCollectedProjects();
            if (collectedProjects.isEmpty()) continue;
            this.getLog().info((CharSequence)("  Aggregated Projects " + Lists.transform((List)collectedProjects, Utils.toKey()) + " will be skipped."));
            mavenProjects.removeAll(collectedProjects);
        }
        for (String unknownModule : unknownModules) {
            this.getLog().warn((CharSequence)("Module [" + unknownModule + "] should be skipped, but does not exist. You should remove the configuration entry."));
        }
        return mavenProjects;
    }

    private void log(DeadCode deadCode) {
        new DeadCodeLogger(this.getLog()).log(deadCode);
    }

    private void logGoodbye() {
        if (this.mojoExecution != null && MojoExecution.Source.CLI.equals((Object)this.mojoExecution.getSource())) {
            this.getLog().info((CharSequence)"Expected something different? Don't like the results? Hop on over to https://github.com/ImmobilienScout24/deadcode4j to learn more!");
        }
    }
}

