/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.plugin;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.is24.deadcode4j.Module;
import de.is24.deadcode4j.Repository;
import de.is24.deadcode4j.Resource;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.plugin.packaginghandler.DefaultPackagingHandler;
import de.is24.deadcode4j.plugin.packaginghandler.PackagingHandler;
import de.is24.deadcode4j.plugin.packaginghandler.PomPackagingHandler;
import de.is24.deadcode4j.plugin.packaginghandler.WarPackagingHandler;
import de.is24.guava.NonNullFunction;
import de.is24.guava.NonNullFunctions;
import de.is24.guava.SequentialLoadingCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModuleGenerator {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final PackagingHandler defaultPackagingHandler = new DefaultPackagingHandler();
    @Nonnull
    private final Map<String, PackagingHandler> packagingHandlers = Maps.newHashMap();
    @Nonnull
    private final LoadingCache<Artifact, Optional<File>> artifactResolverCache;

    public ModuleGenerator(final @Nonnull RepositorySystem repositorySystem) {
        this.packagingHandlers.put("pom", new PomPackagingHandler());
        this.packagingHandlers.put("war", new WarPackagingHandler());
        this.artifactResolverCache = new SequentialLoadingCache<Artifact, File>(NonNullFunctions.toFunction(new NonNullFunction<Artifact, Optional<File>>(){

            @Override
            @Nonnull
            public Optional<File> apply(@Nonnull Artifact input) {
                File classPathElement;
                if (!input.isResolved()) {
                    ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                    request.setResolveRoot(true);
                    request.setResolveTransitively(false);
                    request.setArtifact(input);
                    ArtifactResolutionResult artifactResolutionResult = repositorySystem.resolve(request);
                    if (!artifactResolutionResult.isSuccess()) {
                        ModuleGenerator.this.logger.warn("  Failed to resolve [{}]; some analyzers may not work properly.", (Object)Utils.getVersionedKeyFor(input));
                        return Optional.absent();
                    }
                }
                if ((classPathElement = input.getFile()) == null) {
                    ModuleGenerator.this.logger.warn("  No valid path to [{}] found; some analyzers may not work properly.", (Object)Utils.getVersionedKeyFor(input));
                    return Optional.absent();
                }
                return Optional.of((Object)classPathElement);
            }
        }));
    }

    @Nonnull
    public Iterable<Module> getModulesFor(@Nonnull Iterable<MavenProject> projects) throws MojoExecutionException {
        HashMap knownModules = Maps.newHashMap();
        for (MavenProject project : projects) {
            Module module = this.getModuleFor(project, knownModules);
            knownModules.put(module.getModuleId(), module);
            this.logger.debug("Added [{}] for [{}].", (Object)module, (Object)project);
        }
        return knownModules.values();
    }

    @Nonnull
    private Module getModuleFor(@Nonnull MavenProject project, @Nonnull Map<String, Module> knownModules) throws MojoExecutionException {
        String projectId = Utils.getKeyFor(project);
        String encoding = Strings.emptyToNull((String)project.getProperties().getProperty("project.build.sourceEncoding"));
        if (encoding == null) {
            this.logger.warn("No encoding set for [{}]! Parsing source files may cause issues.", (Object)projectId);
        }
        PackagingHandler packagingHandler = Utils.getValueOrDefault(this.packagingHandlers, project.getPackaging(), this.defaultPackagingHandler);
        Repository outputRepository = packagingHandler.getOutputRepositoryFor(project);
        Iterable<Repository> additionalRepositories = packagingHandler.getAdditionalRepositoriesFor(project);
        Collection<Resource> dependencies = this.computeDependencies(project, knownModules);
        return new Module(projectId, encoding, dependencies, outputRepository, additionalRepositories);
    }

    @Nonnull
    protected Collection<Resource> computeDependencies(@Nonnull MavenProject project, @Nonnull Map<String, Module> knownModules) {
        this.logger.debug("Gathering dependencies for project [{}]...", (Object)Utils.getKeyFor(project));
        ArrayList dependencies = Lists.newArrayList();
        for (Artifact dependency : Iterables.filter((Iterable)project.getArtifacts(), this.artifactsWithCompileScope())) {
            Optional artifactPath;
            if (this.addKnownArtifact(dependencies, dependency, knownModules) || !(artifactPath = (Optional)this.artifactResolverCache.getUnchecked((Object)dependency)).isPresent()) continue;
            File classPathElement = (File)artifactPath.get();
            dependencies.add(Resource.of(classPathElement));
            this.logger.debug("  Added artifact: [{}]", (Object)classPathElement);
        }
        this.logger.debug("[{}] dependencies found for [{}].", (Object)dependencies.size(), (Object)Utils.getKeyFor(project));
        return dependencies;
    }

    private Predicate<Artifact> artifactsWithCompileScope() {
        return new Predicate<Artifact>(){
            private ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("compile");

            public boolean apply(@Nullable Artifact input) {
                return input != null && this.artifactFilter.include(input);
            }
        };
    }

    private boolean addKnownArtifact(@Nonnull List<Resource> resources, @Nonnull Artifact artifact, @Nonnull Map<String, Module> knownModules) {
        String dependencyKey = Utils.getKeyFor(artifact);
        Module knownModule = knownModules.get(dependencyKey);
        if (knownModule == null) {
            return false;
        }
        resources.add(Resource.of(knownModule));
        this.logger.debug("  Added project: [{}]", (Object)knownModule);
        return true;
    }
}

