/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.plugin.packaginghandler;

import de.is24.deadcode4j.Repository;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.plugin.packaginghandler.PackagingHandler;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class DefaultPackagingHandler
extends PackagingHandler {
    @Override
    @Nullable
    public Repository getOutputRepositoryFor(@Nonnull MavenProject project) throws MojoExecutionException {
        this.logger.debug("Project {} has {} packaging, looking for output directory...", (Object)Utils.getKeyFor(project), (Object)project.getPackaging());
        File outputDirectory = new File(project.getBuild().getOutputDirectory());
        if (!outputDirectory.exists()) {
            this.logger.warn("The output directory of " + Utils.getKeyFor(project) + " does not exist - assuming the project simply has nothing to provide!");
            return null;
        }
        this.logger.debug("  Found output directory [{}].", (Object)outputDirectory);
        return new Repository(outputDirectory);
    }

    @Override
    @Nonnull
    public Iterable<Repository> getAdditionalRepositoriesFor(@Nonnull MavenProject project) throws MojoExecutionException {
        return this.getJavaFilesOfCompileSourceRootsAsRepositories(project);
    }
}

