/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.plugin.packaginghandler;

import com.google.common.collect.Lists;
import de.is24.deadcode4j.Repository;
import de.is24.deadcode4j.Utils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PackagingHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Nullable
    public abstract Repository getOutputRepositoryFor(@Nonnull MavenProject var1) throws MojoExecutionException;

    @Nonnull
    public Iterable<Repository> getAdditionalRepositoriesFor(@Nonnull MavenProject project) throws MojoExecutionException {
        return Collections.emptyList();
    }

    @Nonnull
    protected Collection<Repository> getJavaFilesOfCompileSourceRootsAsRepositories(@Nonnull MavenProject project) {
        ArrayList codeRepositories = Lists.newArrayList();
        for (String compileSourceRoot : Utils.emptyIfNull(project.getCompileSourceRoots())) {
            File compileSourceDirectory = new File(compileSourceRoot);
            if (!compileSourceDirectory.exists()) {
                this.logger.debug("  Compile Source Directory [{}] does not exist?", (Object)compileSourceDirectory);
                continue;
            }
            codeRepositories.add(new Repository(compileSourceDirectory, (FileFilter)new OrFileFilter(DirectoryFileFilter.DIRECTORY, (IOFileFilter)new RegexFileFilter(".*\\.java$", IOCase.INSENSITIVE))));
            this.logger.debug("  Found source directory [{}].", (Object)compileSourceRoot);
        }
        return codeRepositories;
    }
}

