/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.plugin.packaginghandler;

import com.google.common.collect.Lists;
import de.is24.deadcode4j.Repository;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.plugin.SubDirectoryFilter;
import de.is24.deadcode4j.plugin.packaginghandler.PackagingHandler;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class WarPackagingHandler
extends PackagingHandler {
    @Override
    @Nullable
    public Repository getOutputRepositoryFor(@Nonnull MavenProject project) throws MojoExecutionException {
        File webAppDirectory = this.calculateWebAppDirectory(project, true);
        return new Repository(new File(webAppDirectory, "WEB-INF/classes"));
    }

    @Override
    @Nonnull
    public Iterable<Repository> getAdditionalRepositoriesFor(@Nonnull MavenProject project) throws MojoExecutionException {
        ArrayList repositories = Lists.newArrayList(this.getJavaFilesOfCompileSourceRootsAsRepositories(project));
        repositories.add(this.getWebInfDirectory(project));
        return repositories;
    }

    private File calculateWebAppDirectory(MavenProject project, boolean log) throws MojoExecutionException {
        File webappDirectory;
        Plugin plugin;
        Xpp3Dom configuration;
        Xpp3Dom webappDirectoryConfig;
        if (log) {
            this.logger.debug("Project {} has war packaging, looking for webapp directory...", (Object)Utils.getKeyFor(project));
        }
        Xpp3Dom xpp3Dom = webappDirectoryConfig = (configuration = (Xpp3Dom)(plugin = project.getPlugin("org.apache.maven.plugins:maven-war-plugin")).getConfiguration()) == null ? null : configuration.getChild("webappDirectory");
        if (webappDirectoryConfig != null) {
            webappDirectory = new File(webappDirectoryConfig.getValue());
            if (log) {
                this.logger.debug("  Found custom webapp directory [{}].", (Object)webappDirectory);
            }
        } else {
            webappDirectory = new File(project.getBuild().getDirectory() + "/" + project.getBuild().getFinalName());
            if (log) {
                this.logger.debug("  Using default webapp directory [{}].", (Object)webappDirectory);
            }
        }
        if (!webappDirectory.exists()) {
            throw new MojoExecutionException("The webapp directory of " + Utils.getKeyFor(project) + " does not exist - please make sure the project is packaged!");
        }
        return webappDirectory;
    }

    private Repository getWebInfDirectory(@Nonnull MavenProject project) throws MojoExecutionException {
        File webAppDirectory = this.calculateWebAppDirectory(project, false);
        File directory = new File(webAppDirectory, "WEB-INF");
        IOFileFilter fileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.asFileFilter((FileFilter)new SubDirectoryFilter(directory, "lib")), FileFilterUtils.asFileFilter((FileFilter)new SubDirectoryFilter(directory, "classes"))}));
        return new Repository(directory, (FileFilter)fileFilter);
    }
}

