/*
 * Decompiled with CFR 0.152.
 */
package de.is24.guava;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import de.is24.deadcode4j.Utils;
import de.is24.guava.NonNullFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class NonNullFunctions {
    private NonNullFunctions() {
    }

    @Nonnull
    public static <F, T> NonNullFunction<F, Optional<T>> or(final NonNullFunction<F, Optional<T>> ... functions) {
        return new NonNullFunction<F, Optional<T>>(){

            @Override
            @Nonnull
            public Optional<T> apply(@Nonnull F input) {
                Optional result;
                int i = 0;
                while (!(result = (Optional)functions[i++].apply(input)).isPresent() && i != functions.length) {
                }
                return result;
            }
        };
    }

    @Nonnull
    public static <F, T> Function<F, T> toFunction(final @Nonnull NonNullFunction<F, T> nonNullFunction) {
        return new Function<F, T>(){

            @Nullable
            public T apply(@Nullable F input) {
                return nonNullFunction.apply(Utils.checkNotNull(input));
            }
        };
    }
}

