/*
 * Decompiled with CFR 0.152.
 */
package de.is24.guava;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SequentialLoadingCache<K, V>
extends AbstractLoadingCache<K, Optional<V>> {
    @Nonnull
    private final Map<K, Optional<V>> cache;
    @Nonnull
    private final Function<K, Optional<V>> cacheLoader;

    protected SequentialLoadingCache(@Nonnull Map<K, Optional<V>> cache, @Nonnull Function<K, Optional<V>> cacheLoader) {
        this.cache = cache;
        this.cacheLoader = cacheLoader;
    }

    public SequentialLoadingCache(@Nonnull Function<K, Optional<V>> cacheLoader) {
        this(Maps.newHashMap(), cacheLoader);
    }

    public static <K, V> SequentialLoadingCache<K, V> createSingleValueCache(@Nonnull Function<K, Optional<V>> cacheLoader) {
        return new SequentialLoadingCache<K, V>(new HashMap<K, Optional<V>>(){

            @Override
            public Optional<V> put(K key, Optional<V> value) {
                super.clear();
                return super.put(key, value);
            }
        }, cacheLoader);
    }

    @Nonnull
    public Optional<V> get(@Nullable K key) throws ExecutionException {
        Optional value = this.cache.get(key);
        if (value == null) {
            value = (Optional)this.cacheLoader.apply(key);
            if (value == null) {
                value = Optional.absent();
            }
            this.cache.put(key, value);
        }
        return value;
    }

    @Nonnull
    public Optional<V> getIfPresent(@Nonnull Object key) {
        Optional<V> value = this.cache.get(key);
        return value == null ? Optional.absent() : value;
    }
}

