/*
 * Decompiled with CFR 0.152.
 */
package de.is24.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.stmt.TypeDeclarationStmt;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.GenericVisitorAdapter;
import com.google.common.collect.Lists;
import de.is24.deadcode4j.Utils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;

public final class Nodes {
    private Nodes() {
    }

    @Nonnull
    public static CompilationUnit getCompilationUnit(@Nonnull Node node) {
        Node loopNode = node;
        do {
            if (!CompilationUnit.class.isInstance(loopNode)) continue;
            return (CompilationUnit)CompilationUnit.class.cast(loopNode);
        } while ((loopNode = loopNode.getParentNode()) != null);
        throw new RuntimeException("Couldn't locate CompilationUnit for [" + node + "]!");
    }

    @Nonnull
    public static String getTypeName(@Nonnull Node node) {
        ArrayList anonymousClasses = Lists.newArrayList();
        StringBuilder buffy = new StringBuilder();
        Node loopNode = node;
        do {
            CompilationUnit compilationUnit;
            if (ObjectCreationExpr.class.isInstance(loopNode)) {
                if (Utils.isEmpty(((ObjectCreationExpr)ObjectCreationExpr.class.cast(loopNode)).getAnonymousClassBody())) continue;
                anonymousClasses.add(loopNode);
                continue;
            }
            if (TypeDeclarationStmt.class.isInstance(loopNode)) {
                anonymousClasses.add(loopNode);
                continue;
            }
            if (TypeDeclaration.class.isInstance(loopNode) && !TypeDeclarationStmt.class.isInstance(loopNode.getParentNode())) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)TypeDeclaration.class.cast(loopNode);
                Nodes.prependSeparatorIfNecessary('$', buffy).insert(0, typeDeclaration.getName());
                Nodes.appendAnonymousClasses(anonymousClasses, typeDeclaration, buffy);
                continue;
            }
            if (!CompilationUnit.class.isInstance(loopNode)) continue;
            if (buffy.length() == 0) {
                buffy.append("package-info");
            }
            if ((compilationUnit = (CompilationUnit)CompilationUnit.class.cast(loopNode)).getPackage() == null) continue;
            Nodes.prepend(compilationUnit.getPackage().getName(), buffy);
        } while ((loopNode = loopNode.getParentNode()) != null);
        return buffy.toString();
    }

    private static void appendAnonymousClasses(final @Nonnull List<Node> anonymousClasses, @Nonnull TypeDeclaration typeDeclaration, final @Nonnull StringBuilder buffy) {
        if (anonymousClasses.isEmpty()) {
            return;
        }
        Boolean typeResolved = (Boolean)typeDeclaration.accept((GenericVisitor)new GenericVisitorAdapter<Boolean, Void>(){
            private Deque<Integer> indexOfAnonymousClasses = Lists.newLinkedList();
            private Deque<Integer> indexOfNamedAnonymousClasses = Lists.newLinkedList();
            private int indexOfNodeToFind = anonymousClasses.size() - 1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean visit(ObjectCreationExpr node, Void arg) {
                if (Utils.isEmpty(node.getAnonymousClassBody())) {
                    return (Boolean)super.visit(node, (Object)arg);
                }
                int currentIndex = this.indexOfAnonymousClasses.removeLast() + 1;
                this.indexOfAnonymousClasses.addLast(currentIndex);
                if (anonymousClasses.get(this.indexOfNodeToFind) == node) {
                    buffy.append('$').append(this.indexOfAnonymousClasses.getLast());
                    if (this.indexOfNodeToFind-- == 0) {
                        return Boolean.TRUE;
                    }
                }
                this.indexOfAnonymousClasses.addLast(0);
                this.indexOfNamedAnonymousClasses.addLast(0);
                try {
                    Boolean bl = (Boolean)super.visit(node, null);
                    return bl;
                }
                finally {
                    this.indexOfAnonymousClasses.removeLast();
                    this.indexOfNamedAnonymousClasses.removeLast();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean visit(TypeDeclarationStmt node, Void arg) {
                int currentIndex = this.indexOfNamedAnonymousClasses.removeLast() + 1;
                this.indexOfNamedAnonymousClasses.addLast(currentIndex);
                if (anonymousClasses.get(this.indexOfNodeToFind) == node) {
                    buffy.append('$').append(this.indexOfNamedAnonymousClasses.getLast()).append(node.getTypeDeclaration().getName());
                    if (this.indexOfNodeToFind-- == 0) {
                        return Boolean.TRUE;
                    }
                }
                this.indexOfAnonymousClasses.addLast(0);
                this.indexOfNamedAnonymousClasses.addLast(0);
                try {
                    Boolean bl = (Boolean)super.visit(node, null);
                    return bl;
                }
                finally {
                    this.indexOfAnonymousClasses.removeLast();
                    this.indexOfNamedAnonymousClasses.removeLast();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean visit(ClassOrInterfaceDeclaration n, Void arg) {
                this.indexOfAnonymousClasses.addLast(0);
                this.indexOfNamedAnonymousClasses.addLast(0);
                try {
                    Boolean bl = (Boolean)super.visit(n, null);
                    return bl;
                }
                finally {
                    this.indexOfAnonymousClasses.removeLast();
                    this.indexOfNamedAnonymousClasses.removeLast();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean visit(EnumDeclaration n, Void arg) {
                this.indexOfAnonymousClasses.addLast(0);
                this.indexOfNamedAnonymousClasses.addLast(0);
                try {
                    Boolean bl = (Boolean)super.visit(n, null);
                    return bl;
                }
                finally {
                    this.indexOfAnonymousClasses.removeLast();
                    this.indexOfNamedAnonymousClasses.removeLast();
                }
            }
        }, null);
        assert (typeResolved.booleanValue()) : "Failed to locate anonymous class definition!";
        anonymousClasses.clear();
    }

    @Nonnull
    public static StringBuilder prepend(@Nonnull NameExpr nameExpr, @Nonnull StringBuilder buffy) {
        while (true) {
            Nodes.prependSeparatorIfNecessary('.', buffy).insert(0, nameExpr.getName());
            if (!QualifiedNameExpr.class.isInstance(nameExpr)) {
                return buffy;
            }
            nameExpr = ((QualifiedNameExpr)QualifiedNameExpr.class.cast(nameExpr)).getQualifier();
        }
    }

    @Nonnull
    public static StringBuilder prependSeparatorIfNecessary(char character, @Nonnull StringBuilder buffy) {
        if (buffy.length() > 0) {
            buffy.insert(0, character);
        }
        return buffy;
    }
}

