/*
 * Decompiled with CFR 0.152.
 */
package de.is24.javassist;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CtClasses {
    private CtClasses() {
    }

    @Nullable
    public static CtClass getCtClass(@Nonnull ClassPool classPool, @Nonnull String className) {
        CtClass clazz = classPool.getOrNull(className);
        if (clazz == null) {
            CtClasses.handleMissingClass(className, null);
        }
        return clazz;
    }

    public static boolean isJavaLangObject(@Nullable CtClass loopClass) {
        return loopClass != null && "java.lang.Object".equals(loopClass.getName());
    }

    @Nonnull
    public static Set<String> getAllImplementedInterfaces(@Nonnull CtClass clazz) {
        HashSet interfaces = Sets.newHashSet();
        CtClass loopClass = clazz;
        do {
            for (CtClass anInterface : CtClasses.getInterfacesOf(loopClass)) {
                interfaces.add(anInterface.getName());
                interfaces.addAll(CtClasses.getAllImplementedInterfaces(anInterface));
            }
        } while ((loopClass = CtClasses.getSuperclassOf(loopClass)) != null && !CtClasses.isJavaLangObject(loopClass));
        return interfaces;
    }

    @Nonnull
    public static Iterable<CtClass> getInterfacesOf(@Nonnull CtClass clazz) {
        String[] interfaceNames = clazz.getClassFile2().getInterfaces();
        ArrayList interfaces = Lists.newArrayListWithCapacity((int)interfaceNames.length);
        for (String nameOfInterface : interfaceNames) {
            CtClass interfaze = CtClasses.getCtClass(clazz, nameOfInterface);
            if (interfaze == null) continue;
            interfaces.add(interfaze);
        }
        return interfaces;
    }

    @Nullable
    public static CtClass getSuperclassOf(@Nonnull CtClass clazz) {
        String nameOfSuperclass = clazz.getClassFile2().getSuperclass();
        return CtClasses.getCtClass(clazz, nameOfSuperclass);
    }

    @Nonnull
    public static Iterable<CtClass> getDeclaringClassesOf(@Nonnull CtClass clazz) {
        ArrayList declaringClasses = Lists.newArrayList();
        CtClass declarer = clazz;
        while (declarer != null) {
            declaringClasses.add(declarer);
            declarer = CtClasses.getDeclaringClassOf(declarer);
        }
        return declaringClasses;
    }

    @Nonnull
    public static Iterable<CtClass> getNestedClassesOf(@Nonnull CtClass clazz) {
        try {
            return Arrays.asList(clazz.getNestedClasses());
        }
        catch (NotFoundException e) {
            CtClasses.handleMissingClass(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CtClasses.class);
    }

    private static void handleMissingClass(@Nonnull String className, NotFoundException notFoundException) {
        if (CtClasses.getLogger().isDebugEnabled()) {
            CtClasses.getLogger().debug("Failed to load {}!", (Object)className, (Object)(notFoundException != null ? notFoundException : new RuntimeException("Providing stack trace!")));
        }
        CtClasses.getLogger().warn("The class path is not correctly set up; could not load {}!", (Object)className);
    }

    @Nullable
    private static CtClass getCtClass(@Nonnull CtClass classProvidingPool, @Nonnull String className) {
        return CtClasses.getCtClass(classProvidingPool.getClassPool(), className);
    }

    @Nullable
    private static CtClass getDeclaringClassOf(@Nonnull CtClass clazz) {
        try {
            return clazz.getDeclaringClass();
        }
        catch (NotFoundException e) {
            CtClasses.handleMissingClass(e.getMessage(), e);
            return null;
        }
    }
}

