/*
 * Decompiled with CFR 0.152.
 */
package de.is24.maven;

import com.google.common.base.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=UpdateChecker.class)
public class UpdateChecker {
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private RepositoryMetadataManager repositoryMetadataManager;

    @Nonnull
    public Optional<ArtifactVersion> checkForUpdate(@Nonnull MojoExecution mojoExecution) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            if (this.legacySupport.getSession().isOffline()) {
                logger.info("Running in offline mode; skipping update check.");
                return Optional.absent();
            }
            Artifact artifact = ArtifactUtils.copyArtifact((Artifact)mojoExecution.getMojoDescriptor().getPluginDescriptor().getPluginArtifact());
            ArtifactVersion versionInUse = artifact.getVersionRange().getRecommendedVersion();
            ArtifactRepositoryMetadata repositoryMetadata = new ArtifactRepositoryMetadata(artifact);
            this.repositoryMetadataManager.resolve((RepositoryMetadata)repositoryMetadata, this.legacySupport.getSession().getCurrentProject().getPluginArtifactRepositories(), this.legacySupport.getSession().getLocalRepository());
            ArtifactVersion newestVersion = versionInUse;
            for (String version : repositoryMetadata.getMetadata().getVersioning().getVersions()) {
                DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
                if ("SNAPSHOT".equals(artifactVersion.getQualifier()) || artifactVersion.compareTo((Object)newestVersion) <= 0) continue;
                newestVersion = artifactVersion;
            }
            if (versionInUse.compareTo((Object)newestVersion) < 0) {
                logger.debug("New plugin version [{}] is available.", (Object)newestVersion);
                return Optional.of((Object)newestVersion);
            }
            logger.debug("Running latest version.");
        }
        catch (Exception e) {
            logger.debug("Update check failed!", (Throwable)e);
            logger.warn("Update check failed: {}", (Object)e.getMessage());
        }
        return Optional.absent();
    }
}

