/*
 * Decompiled with CFR 0.152.
 */
package de.is24.maven.slf4j;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class LoggerForMavenLog
extends MarkerIgnoringBase {
    private final Log log;

    public LoggerForMavenLog(@Nonnull Log log, @Nullable String name) {
        this.log = log;
        this.name = name;
    }

    private void doDebug(String message, Throwable throwable) {
        String renderedMessage;
        String string = renderedMessage = this.name == null ? message : this.name + ": " + message;
        if (throwable == null) {
            this.log.debug((CharSequence)renderedMessage);
        } else {
            this.log.debug((CharSequence)renderedMessage, throwable);
        }
    }

    private void doDebug(String message) {
        this.doDebug(message, null);
    }

    private void doDebug(FormattingTuple tuple) {
        this.doDebug(tuple.getMessage(), tuple.getThrowable());
    }

    public boolean isTraceEnabled() {
        return this.log.isDebugEnabled();
    }

    public void trace(String msg) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(MessageFormatter.format((String)format, (Object)arg));
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(msg, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(MessageFormatter.format((String)format, (Object)arg));
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.log.isDebugEnabled()) {
            this.doDebug(msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)msg);
        }
    }

    private void doInfo(FormattingTuple tuple) {
        if (tuple.getThrowable() == null) {
            this.log.info((CharSequence)tuple.getMessage());
        } else {
            this.log.info((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void info(String format, Object arg) {
        if (this.log.isInfoEnabled()) {
            this.doInfo(MessageFormatter.format((String)format, (Object)arg));
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.log.isInfoEnabled()) {
            this.doInfo(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.log.isInfoEnabled()) {
            this.doInfo(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        }
    }

    public void info(String msg, Throwable t) {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)msg, t);
        }
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)msg);
        }
    }

    private void doWarn(FormattingTuple tuple) {
        if (tuple.getThrowable() == null) {
            this.log.warn((CharSequence)tuple.getMessage());
        } else {
            this.log.warn((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void warn(String format, Object arg) {
        if (this.log.isWarnEnabled()) {
            this.doWarn(MessageFormatter.format((String)format, (Object)arg));
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.log.isWarnEnabled()) {
            this.doWarn(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.log.isWarnEnabled()) {
            this.doWarn(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)msg, t);
        }
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(String msg) {
        this.log.error((CharSequence)msg);
    }

    private void doError(FormattingTuple tuple) {
        if (tuple.getThrowable() == null) {
            this.log.error((CharSequence)tuple.getMessage());
        } else {
            this.log.error((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void error(String format, Object arg) {
        this.doError(MessageFormatter.format((String)format, (Object)arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.doError(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void error(String format, Object ... arguments) {
        this.doError(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
    }

    public void error(String msg, Throwable t) {
        this.log.error((CharSequence)msg, t);
    }
}

