/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import de.is24.maven.slf4j.MavenPluginLoggerFactory;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.ILoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.helpers.Util;
import org.slf4j.spi.LoggerFactoryBinder;

public final class StaticLoggerBinder
implements LoggerFactoryBinder {
    private static final StaticLoggerBinder INSTANCE = new StaticLoggerBinder();
    private final ThreadLocal<ILoggerFactory> loggerFactoryForThread = new ThreadLocal();

    @Nonnull
    public static StaticLoggerBinder getSingleton() {
        return INSTANCE;
    }

    private StaticLoggerBinder() {
    }

    @Nonnull
    public ILoggerFactory getLoggerFactory() {
        ILoggerFactory loggerFactory = this.loggerFactoryForThread.get();
        if (loggerFactory == null) {
            Util.report((String)"No Maven Log set; using NOPLoggerFactory! Make sure to call StaticLoggerBinder.getSingleton().setLog(Log log)!");
            loggerFactory = new NOPLoggerFactory();
        }
        return loggerFactory;
    }

    public String getLoggerFactoryClassStr() {
        return MavenPluginLoggerFactory.class.getName();
    }

    public void setLog(@Nonnull Log log) {
        this.loggerFactoryForThread.set(new MavenPluginLoggerFactory(log));
    }

    public void revokeLog() {
        this.loggerFactoryForThread.remove();
    }
}

