/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=CV.class)
@ApiModel(description="Specification of controlled vocabularies. label: A string describing the labels of the controlled vocabularies/ontologies used in the mzTab file as a short-hand e.g. \"MS\" for PSI-MS. full_name: A string describing the full names of the controlled vocabularies/ontologies used in the mzTab file. version: A string describing the version of the controlled vocabularies/ontologies used in the mzTab file. uri: A string containing the URIs of the controlled vocabularies/ontologies used in the mzTab file. ")
@XmlRootElement(name="CV")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="CV")
public class CV {
    @JsonProperty(value="id")
    @JacksonXmlProperty(localName="id")
    @XmlElement(name="id")
    private Integer id = null;
    @JsonProperty(value="label")
    @JacksonXmlProperty(localName="label")
    @XmlElement(name="label")
    private String label = null;
    @JsonProperty(value="full_name")
    @JacksonXmlProperty(localName="full_name")
    @XmlElement(name="full_name")
    private String fullName = null;
    @JsonProperty(value="version")
    @JacksonXmlProperty(localName="version")
    @XmlElement(name="version")
    private String version = null;
    @JsonProperty(value="uri")
    @JacksonXmlProperty(localName="uri")
    @XmlElement(name="uri")
    private String uri = null;

    public CV id(Integer id) {
        this.id = id;
        return this;
    }

    @Min(value=1L)
    @ApiModelProperty(value="")
    public @Min(value=1L) Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public CV label(String label) {
        this.label = label;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The abbreviated CV label.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public CV fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The full name of this CV, for humans.")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public CV version(String version) {
        this.version = version;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The CV version used when the file was generated.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public CV uri(String uri) {
        this.uri = uri;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="A URI to the CV definition.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CV CV2 = (CV)o;
        return Objects.equals(this.id, CV2.id) && Objects.equals(this.label, CV2.label) && Objects.equals(this.fullName, CV2.fullName) && Objects.equals(this.version, CV2.version) && Objects.equals(this.uri, CV2.uri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.label, this.fullName, this.version, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CV {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        id("id"),
        label("label"),
        fullName("full_name"),
        version("version"),
        uri("uri");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

