/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=Instrument.class)
@ApiModel(description="The name, source, analyzer and detector of the instruments used in the experiment. Multiple instruments are numbered [1-n].")
@XmlRootElement(name="Instrument")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Instrument")
public class Instrument {
    @JsonProperty(value="id")
    @JacksonXmlProperty(localName="id")
    @XmlElement(name="id")
    private Integer id = null;
    @JsonProperty(value="name")
    @JacksonXmlProperty(localName="name")
    @XmlElement(name="name")
    private Parameter name = null;
    @JsonProperty(value="source")
    @JacksonXmlProperty(localName="source")
    @XmlElement(name="source")
    private Parameter source = null;
    @JsonProperty(value="analyzer")
    @XmlElement(name="analyzer")
    private List<Parameter> analyzer = null;
    @JsonProperty(value="detector")
    @JacksonXmlProperty(localName="detector")
    @XmlElement(name="detector")
    private Parameter detector = null;

    public Instrument id(Integer id) {
        this.id = id;
        return this;
    }

    @Min(value=1L)
    @ApiModelProperty(value="")
    public @Min(value=1L) Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Instrument name(Parameter name) {
        this.name = name;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public Parameter getName() {
        return this.name;
    }

    public void setName(Parameter name) {
        this.name = name;
    }

    public Instrument source(Parameter source) {
        this.source = source;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The instrument's source, as defined by the parameter.")
    public Parameter getSource() {
        return this.source;
    }

    public void setSource(Parameter source) {
        this.source = source;
    }

    public Instrument analyzer(List<Parameter> analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public Instrument addAnalyzerItem(Parameter analyzerItem) {
        if (this.analyzer == null) {
            this.analyzer = new ArrayList<Parameter>();
        }
        this.analyzer.add(analyzerItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="The instrument's mass analyzer, as defined by the parameter.")
    public List<Parameter> getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(List<Parameter> analyzer) {
        this.analyzer = analyzer;
    }

    public Instrument detector(Parameter detector) {
        this.detector = detector;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The instrument's detector, as defined by the parameter.")
    public Parameter getDetector() {
        return this.detector;
    }

    public void setDetector(Parameter detector) {
        this.detector = detector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instrument instrument = (Instrument)o;
        return Objects.equals(this.id, instrument.id) && Objects.equals(this.name, instrument.name) && Objects.equals(this.source, instrument.source) && Objects.equals(this.analyzer, instrument.analyzer) && Objects.equals(this.detector, instrument.detector);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.source, this.analyzer, this.detector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Instrument {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    analyzer: ").append(this.toIndentedString(this.analyzer)).append("\n");
        sb.append("    detector: ").append(this.toIndentedString(this.detector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        id("id"),
        name("name"),
        source("source"),
        analyzer("analyzer"),
        detector("detector");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

