/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.CV;
import de.isas.mztab2.model.ColumnParameterMapping;
import de.isas.mztab2.model.Contact;
import de.isas.mztab2.model.Database;
import de.isas.mztab2.model.Instrument;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.Publication;
import de.isas.mztab2.model.Sample;
import de.isas.mztab2.model.SampleProcessing;
import de.isas.mztab2.model.Software;
import de.isas.mztab2.model.StudyVariable;
import de.isas.mztab2.model.Uri;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="The metadata section provides additional information about the dataset(s) reported in the mzTab file. All fields in the metadata section are optional apart from those noted as mandatory. The fields in the metadata section MUST be reported in order of the various fields listed here. The field\u2019s name and value MUST be separated by a tab character.  ")
@XmlRootElement(name="Metadata")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Metadata")
public class Metadata {
    @JsonProperty(value="prefix")
    @JacksonXmlProperty(localName="prefix")
    @XmlElement(name="prefix")
    private PrefixEnum prefix = PrefixEnum.MTD;
    @JsonProperty(value="mzTab-version")
    @JacksonXmlProperty(localName="mzTab-version")
    @XmlElement(name="mzTab-version")
    private String mzTabVersion = null;
    @JsonProperty(value="mzTab-ID")
    @JacksonXmlProperty(localName="mzTab-ID")
    @XmlElement(name="mzTab-ID")
    private String mzTabID = null;
    @JsonProperty(value="title")
    @JacksonXmlProperty(localName="title")
    @XmlElement(name="title")
    private String title = null;
    @JsonProperty(value="description")
    @JacksonXmlProperty(localName="description")
    @XmlElement(name="description")
    private String description = null;
    @JsonProperty(value="contact")
    @XmlElement(name="contact")
    private List<Contact> contact = null;
    @JsonProperty(value="publication")
    @XmlElement(name="publication")
    private List<Publication> publication = null;
    @JsonProperty(value="uri")
    @XmlElement(name="uri")
    private List<Uri> uri = null;
    @JsonProperty(value="external_study_uri")
    @XmlElement(name="externalStudyUri")
    private List<Uri> externalStudyUri = null;
    @JsonProperty(value="instrument")
    @XmlElement(name="instrument")
    private List<Instrument> instrument = null;
    @JsonProperty(value="quantification_method")
    @JacksonXmlProperty(localName="quantification_method")
    @XmlElement(name="quantification_method")
    private Parameter quantificationMethod = null;
    @JsonProperty(value="sample")
    @XmlElement(name="sample")
    private List<Sample> sample = null;
    @JsonProperty(value="sample_processing")
    @XmlElement(name="sampleProcessing")
    private List<SampleProcessing> sampleProcessing = null;
    @JsonProperty(value="software")
    @XmlElement(name="software")
    private List<Software> software = new ArrayList<Software>();
    @JsonProperty(value="derivatization_agent")
    @XmlElement(name="derivatizationAgent")
    private List<Parameter> derivatizationAgent = null;
    @JsonProperty(value="ms_run")
    @XmlElement(name="msRun")
    private List<MsRun> msRun = new ArrayList<MsRun>();
    @JsonProperty(value="assay")
    @XmlElement(name="assay")
    private List<Assay> assay = new ArrayList<Assay>();
    @JsonProperty(value="study_variable")
    @XmlElement(name="studyVariable")
    private List<StudyVariable> studyVariable = new ArrayList<StudyVariable>();
    @JsonProperty(value="custom")
    @XmlElement(name="custom")
    private List<Parameter> custom = null;
    @JsonProperty(value="cv")
    @XmlElement(name="cv")
    private List<CV> cv = new ArrayList<CV>();
    @JsonProperty(value="small_molecule-quantification_unit")
    @JacksonXmlProperty(localName="small_molecule-quantification_unit")
    @XmlElement(name="small_molecule-quantification_unit")
    private Parameter smallMoleculeQuantificationUnit = null;
    @JsonProperty(value="small_molecule_feature-quantification_unit")
    @JacksonXmlProperty(localName="small_molecule_feature-quantification_unit")
    @XmlElement(name="small_molecule_feature-quantification_unit")
    private Parameter smallMoleculeFeatureQuantificationUnit = null;
    @JsonProperty(value="small_molecule-identification_reliability")
    @JacksonXmlProperty(localName="small_molecule-identification_reliability")
    @XmlElement(name="small_molecule-identification_reliability")
    private Parameter smallMoleculeIdentificationReliability = null;
    @JsonProperty(value="database")
    @XmlElement(name="database")
    private List<Database> database = new ArrayList<Database>();
    @JsonProperty(value="id_confidence_measure")
    @XmlElement(name="idConfidenceMeasure")
    private List<Parameter> idConfidenceMeasure = new ArrayList<Parameter>();
    @JsonProperty(value="colunit-small_molecule")
    @XmlElement(name="colunitSmallMolecule")
    private List<ColumnParameterMapping> colunitSmallMolecule = null;
    @JsonProperty(value="colunit-small_molecule_feature")
    @XmlElement(name="colunitSmallMoleculeFeature")
    private List<ColumnParameterMapping> colunitSmallMoleculeFeature = null;
    @JsonProperty(value="colunit-small_molecule_evidence")
    @XmlElement(name="colunitSmallMoleculeEvidence")
    private List<ColumnParameterMapping> colunitSmallMoleculeEvidence = null;

    public Metadata prefix(PrefixEnum prefix) {
        this.prefix = prefix;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="MTD", required=true, value="The metadata section prefix. MUST always be MTD. ")
    public PrefixEnum getPrefix() {
        return this.prefix;
    }

    public void setPrefix(PrefixEnum prefix) {
        this.prefix = prefix;
    }

    public Metadata mzTabVersion(String mzTabVersion) {
        this.mzTabVersion = mzTabVersion;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\d{1}\\.\\d{1}\\.\\d{1}-[A-Z]{1}$")
    @ApiModelProperty(required=true, value="The version of the mzTab file. The suffix MUST be \"-M\" for mzTab for metabolomics (mzTab-M). ")
    public @NotNull @Pattern(regexp="^\\d{1}\\.\\d{1}\\.\\d{1}-[A-Z]{1}$") String getMzTabVersion() {
        return this.mzTabVersion;
    }

    public void setMzTabVersion(String mzTabVersion) {
        this.mzTabVersion = mzTabVersion;
    }

    public Metadata mzTabID(String mzTabID) {
        this.mzTabID = mzTabID;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="MTD mzTab-ID MTBLS214", required=true, value="The ID of the mzTab file, this could be supplied by the repository from which it is downloaded or a local identifier from the lab producing the file. It is not intended to be a globally unique ID but carry some locally useful meaning. ")
    public String getMzTabID() {
        return this.mzTabID;
    }

    public void setMzTabID(String mzTabID) {
        this.mzTabID = mzTabID;
    }

    public Metadata title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="MTD title My first test experiment", value="The file\u2019s human readable title. ")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Metadata description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="MTD description An experiment investigating the effects of Il-6.", value="The file\u2019s human readable description. ")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Metadata contact(List<Contact> contact) {
        this.contact = contact;
        return this;
    }

    public Metadata addContactItem(Contact contactItem) {
        if (this.contact == null) {
            this.contact = new ArrayList<Contact>();
        }
        this.contact.add(contactItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="The contact\u2019s name, affiliation and e-mail. Several contacts can be given by indicating the number in the square brackets after \"contact\". A contact has to be supplied in the format [first name] [initials] [last name].")
    public List<Contact> getContact() {
        return this.contact;
    }

    public void setContact(List<Contact> contact) {
        this.contact = contact;
    }

    public Metadata publication(List<Publication> publication) {
        this.publication = publication;
        return this;
    }

    public Metadata addPublicationItem(Publication publicationItem) {
        if (this.publication == null) {
            this.publication = new ArrayList<Publication>();
        }
        this.publication.add(publicationItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="A publication associated with this file. Several publications can be given by indicating the number in the square brackets after \u201cpublication\u201d. PubMed ids must be prefixed by \u201cpubmed:\u201d, DOIs by \u201cdoi:\u201d. Multiple identifiers MUST be separated by \u201c|\u201d.")
    public List<Publication> getPublication() {
        return this.publication;
    }

    public void setPublication(List<Publication> publication) {
        this.publication = publication;
    }

    public Metadata uri(List<Uri> uri) {
        this.uri = uri;
        return this;
    }

    public Metadata addUriItem(Uri uriItem) {
        if (this.uri == null) {
            this.uri = new ArrayList<Uri>();
        }
        this.uri.add(uriItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="A URI pointing to the file\u2019s source data (e.g., a MetaboLights records).")
    public List<Uri> getUri() {
        return this.uri;
    }

    public void setUri(List<Uri> uri) {
        this.uri = uri;
    }

    public Metadata externalStudyUri(List<Uri> externalStudyUri) {
        this.externalStudyUri = externalStudyUri;
        return this;
    }

    public Metadata addExternalStudyUriItem(Uri externalStudyUriItem) {
        if (this.externalStudyUri == null) {
            this.externalStudyUri = new ArrayList<Uri>();
        }
        this.externalStudyUri.add(externalStudyUriItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="A URI pointing to an external file with more details about the study design (e.g., an ISA-TAB file).")
    public List<Uri> getExternalStudyUri() {
        return this.externalStudyUri;
    }

    public void setExternalStudyUri(List<Uri> externalStudyUri) {
        this.externalStudyUri = externalStudyUri;
    }

    public Metadata instrument(List<Instrument> instrument) {
        this.instrument = instrument;
        return this;
    }

    public Metadata addInstrumentItem(Instrument instrumentItem) {
        if (this.instrument == null) {
            this.instrument = new ArrayList<Instrument>();
        }
        this.instrument.add(instrumentItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="The name, source, analyzer and detector of the instruments used in the experiment. Multiple instruments are numbered [1-n].")
    public List<Instrument> getInstrument() {
        return this.instrument;
    }

    public void setInstrument(List<Instrument> instrument) {
        this.instrument = instrument;
    }

    public Metadata quantificationMethod(Parameter quantificationMethod) {
        this.quantificationMethod = quantificationMethod;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The quantification method used in the experiment reported in the file.")
    public Parameter getQuantificationMethod() {
        return this.quantificationMethod;
    }

    public void setQuantificationMethod(Parameter quantificationMethod) {
        this.quantificationMethod = quantificationMethod;
    }

    public Metadata sample(List<Sample> sample) {
        this.sample = sample;
        return this;
    }

    public Metadata addSampleItem(Sample sampleItem) {
        if (this.sample == null) {
            this.sample = new ArrayList<Sample>();
        }
        this.sample.add(sampleItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Specification of sample. (empty) name: A name for each sample to serve as a list of the samples that MUST be reported in the following tables. Samples MUST be reported if a statistical design is being captured (i.e. bio or tech replicates). If the type of replicates are not known, samples SHOULD NOT be reported.  species: The respective species of the samples analysed. For more complex cases, such as metagenomics, optional columns and userParams should be used.  tissue: The respective tissue(s) of the sample.  cell_type: The respective cell type(s) of the sample.  disease: The respective disease(s) of the sample.  description: A human readable description of the sample.  custom: Custom parameters describing the sample\u2019s additional properties. Dates MUST be provided in ISO-8601 format. ")
    public List<Sample> getSample() {
        return this.sample;
    }

    public void setSample(List<Sample> sample) {
        this.sample = sample;
    }

    public Metadata sampleProcessing(List<SampleProcessing> sampleProcessing) {
        this.sampleProcessing = sampleProcessing;
        return this;
    }

    public Metadata addSampleProcessingItem(SampleProcessing sampleProcessingItem) {
        if (this.sampleProcessing == null) {
            this.sampleProcessing = new ArrayList<SampleProcessing>();
        }
        this.sampleProcessing.add(sampleProcessingItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="A list of parameters describing a sample processing, preparation or handling step similar to a biological or analytical methods report. The order of the sample_processing items should reflect the order these processing steps were performed in. If multiple parameters are given for a step these MUST be separated by a \u201c|\u201d. If derivatization was performed, it MUST be reported here as a general step, e.g. 'silylation' and the actual derivatization agens MUST be specified in the Section 6.2.54 part. ")
    public List<SampleProcessing> getSampleProcessing() {
        return this.sampleProcessing;
    }

    public void setSampleProcessing(List<SampleProcessing> sampleProcessing) {
        this.sampleProcessing = sampleProcessing;
    }

    public Metadata software(List<Software> software) {
        this.software = software;
        return this;
    }

    public Metadata addSoftwareItem(Software softwareItem) {
        this.software.add(softwareItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Software used to analyze the data and obtain the reported results. The parameter\u2019s value SHOULD contain the software\u2019s version. The order (numbering) should reflect the order in which the tools were used. A software setting used. This field MAY occur multiple times for a single software. The value of this field is deliberately set as a String, since there currently do not exist CV terms for every possible setting.")
    public List<Software> getSoftware() {
        return this.software;
    }

    public void setSoftware(List<Software> software) {
        this.software = software;
    }

    public Metadata derivatizationAgent(List<Parameter> derivatizationAgent) {
        this.derivatizationAgent = derivatizationAgent;
        return this;
    }

    public Metadata addDerivatizationAgentItem(Parameter derivatizationAgentItem) {
        if (this.derivatizationAgent == null) {
            this.derivatizationAgent = new ArrayList<Parameter>();
        }
        this.derivatizationAgent.add(derivatizationAgentItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="A description of derivatization agents applied to small molecules, using userParams or CV terms where possible.")
    public List<Parameter> getDerivatizationAgent() {
        return this.derivatizationAgent;
    }

    public void setDerivatizationAgent(List<Parameter> derivatizationAgent) {
        this.derivatizationAgent = derivatizationAgent;
    }

    public Metadata msRun(List<MsRun> msRun) {
        this.msRun = msRun;
        return this;
    }

    public Metadata addMsRunItem(MsRun msRunItem) {
        this.msRun.add(msRunItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Specification of ms_run.  location: Location of the external data file e.g. raw files on which analysis has been performed. If the actual location of the MS run is unknown, a \u201cnull\u201d MUST be used as a place holder value, since the [1-n] cardinality is referenced elsewhere. If pre-fractionation has been performed, then [1-n] ms_runs SHOULD be created per assay.  instrument_ref: If different instruments are used in different runs, instrument_ref can be used to link a specific instrument to a specific run.  format: Parameter specifying the data format of the external MS data file. If ms_run[1-n]-format is present, ms_run[1-n]-id_format SHOULD also be present, following the parameters specified in Table 1.  id_format: Parameter specifying the id format used in the external data file. If ms_run[1-n]-id_format is present, ms_run[1-n]-format SHOULD also be present. fragmentation_method: The type(s) of fragmentation used in a given ms run. scan_polarity: The polarity mode of a given run. Usually only one value SHOULD be given here except for the case of mixed polarity runs. hash: Hash value of the corresponding external MS data file defined in ms_run[1-n]-location. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present. hash_method: A parameter specifying the hash methods used to generate the String in ms_run[1-n]-hash. Specifics of the hash method used MAY follow the definitions of the mzML format. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present. ")
    public List<MsRun> getMsRun() {
        return this.msRun;
    }

    public void setMsRun(List<MsRun> msRun) {
        this.msRun = msRun;
    }

    public Metadata assay(List<Assay> assay) {
        this.assay = assay;
        return this;
    }

    public Metadata addAssayItem(Assay assayItem) {
        this.assay.add(assayItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Specification of assay. (empty) name: A name for each assay, to serve as a list of the assays that MUST be reported in the following tables.  custom: Additional custom parameters or values for a given assay.  external_uri: An external reference uri to further information about the assay, for example via a reference to an object within an ISA-TAB file.  sample_ref: An association from a given assay to the sample analysed.  ms_run_ref: An association from a given assay to the source MS run. All assays MUST reference exactly one ms_run unless a workflow with pre-fractionation is being encoded, in which case each assay MUST reference n ms_runs where n fractions have been collected. Multiple assays SHOULD reference the same ms_run to capture multiplexed experimental designs. ")
    public List<Assay> getAssay() {
        return this.assay;
    }

    public void setAssay(List<Assay> assay) {
        this.assay = assay;
    }

    public Metadata studyVariable(List<StudyVariable> studyVariable) {
        this.studyVariable = studyVariable;
        return this;
    }

    public Metadata addStudyVariableItem(StudyVariable studyVariableItem) {
        this.studyVariable.add(studyVariableItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Specification of study_variable. (empty) name: A name for each study variable (experimental condition or factor), to serve as a list of the study variables that MUST be reported in the following tables. For software that does not capture study variables, a single study variable MUST be reported, linking to all assays. This single study variable MUST have the identifier \u201cundefined\u201c. assay_refs: Bar-separated references to the IDs of assays grouped in the study variable. average_function: The function used to calculate the study variable quantification value and the operation used is not arithmetic mean (default) e.g. \u201cgeometric mean\u201d, \u201cmedian\u201d. The 1-n refers to different study variables. variation_function: The function used to calculate the study variable quantification variation value if it is reported and the operation used is not coefficient of variation (default) e.g. \u201cstandard error\u201d. description: A textual description of the study variable. factors: Additional parameters or factors, separated by bars, that are known about study variables allowing the capture of more complex, such as nested designs. ")
    public List<StudyVariable> getStudyVariable() {
        return this.studyVariable;
    }

    public void setStudyVariable(List<StudyVariable> studyVariable) {
        this.studyVariable = studyVariable;
    }

    public Metadata custom(List<Parameter> custom) {
        this.custom = custom;
        return this;
    }

    public Metadata addCustomItem(Parameter customItem) {
        if (this.custom == null) {
            this.custom = new ArrayList<Parameter>();
        }
        this.custom.add(customItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Any additional parameters describing the analysis reported.")
    public List<Parameter> getCustom() {
        return this.custom;
    }

    public void setCustom(List<Parameter> custom) {
        this.custom = custom;
    }

    public Metadata cv(List<CV> cv) {
        this.cv = cv;
        return this;
    }

    public Metadata addCvItem(CV cvItem) {
        this.cv.add(cvItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Specification of controlled vocabularies. label: A string describing the labels of the controlled vocabularies/ontologies used in the mzTab file as a short-hand e.g. \"MS\" for PSI-MS. full_name: A string describing the full names of the controlled vocabularies/ontologies used in the mzTab file. version: A string describing the version of the controlled vocabularies/ontologies used in the mzTab file. uri: A string containing the URIs of the controlled vocabularies/ontologies used in the mzTab file. ")
    public List<CV> getCv() {
        return this.cv;
    }

    public void setCv(List<CV> cv) {
        this.cv = cv;
    }

    public Metadata smallMoleculeQuantificationUnit(Parameter smallMoleculeQuantificationUnit) {
        this.smallMoleculeQuantificationUnit = smallMoleculeQuantificationUnit;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Defines what type of units are reported in the small molecule summary quantification / abundance fields.")
    public Parameter getSmallMoleculeQuantificationUnit() {
        return this.smallMoleculeQuantificationUnit;
    }

    public void setSmallMoleculeQuantificationUnit(Parameter smallMoleculeQuantificationUnit) {
        this.smallMoleculeQuantificationUnit = smallMoleculeQuantificationUnit;
    }

    public Metadata smallMoleculeFeatureQuantificationUnit(Parameter smallMoleculeFeatureQuantificationUnit) {
        this.smallMoleculeFeatureQuantificationUnit = smallMoleculeFeatureQuantificationUnit;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Defines what type of units are reported in the small molecule feature quantification / abundance fields.")
    public Parameter getSmallMoleculeFeatureQuantificationUnit() {
        return this.smallMoleculeFeatureQuantificationUnit;
    }

    public void setSmallMoleculeFeatureQuantificationUnit(Parameter smallMoleculeFeatureQuantificationUnit) {
        this.smallMoleculeFeatureQuantificationUnit = smallMoleculeFeatureQuantificationUnit;
    }

    public Metadata smallMoleculeIdentificationReliability(Parameter smallMoleculeIdentificationReliability) {
        this.smallMoleculeIdentificationReliability = smallMoleculeIdentificationReliability;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The system used for giving reliability / confidence codes to small molecule identifications MUST be specified if not using the default codes.")
    public Parameter getSmallMoleculeIdentificationReliability() {
        return this.smallMoleculeIdentificationReliability;
    }

    public void setSmallMoleculeIdentificationReliability(Parameter smallMoleculeIdentificationReliability) {
        this.smallMoleculeIdentificationReliability = smallMoleculeIdentificationReliability;
    }

    public Metadata database(List<Database> database) {
        this.database = database;
        return this;
    }

    public Metadata addDatabaseItem(Database databaseItem) {
        this.database.add(databaseItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Specification of databases. (empty): The description of databases used. For cases, where a known database has not been used for identification, a userParam SHOULD be inserted to describe any identification performed e.g. de novo. If no identification has been performed at all then \"no database\" should be inserted followed by null. prefix: The prefix used in the \u201cidentifier\u201d column of data tables. For the \u201cno database\u201d case \"null\" must be used. version: The database version is mandatory where identification has been performed. This may be a formal version number e.g. \u201c1.4.1\u201d, a date of access \u201c2016-10-27\u201d (ISO-8601 format) or \u201cUnknown\u201d if there is no suitable version that can be annotated. uri: The URI to the database. For the \u201cno database\u201d case, \"null\" must be reported. ")
    public List<Database> getDatabase() {
        return this.database;
    }

    public void setDatabase(List<Database> database) {
        this.database = database;
    }

    public Metadata idConfidenceMeasure(List<Parameter> idConfidenceMeasure) {
        this.idConfidenceMeasure = idConfidenceMeasure;
        return this;
    }

    public Metadata addIdConfidenceMeasureItem(Parameter idConfidenceMeasureItem) {
        this.idConfidenceMeasure.add(idConfidenceMeasureItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The type of small molecule confidence measures or scores MUST be reported as a CV parameter [1-n]. The CV parameter definition should formally state whether the ordering is high to low or vice versa. The order of the scores SHOULD reflect their importance for the identification and be used to determine the identification\u2019s rank.")
    public List<Parameter> getIdConfidenceMeasure() {
        return this.idConfidenceMeasure;
    }

    public void setIdConfidenceMeasure(List<Parameter> idConfidenceMeasure) {
        this.idConfidenceMeasure = idConfidenceMeasure;
    }

    public Metadata colunitSmallMolecule(List<ColumnParameterMapping> colunitSmallMolecule) {
        this.colunitSmallMolecule = colunitSmallMolecule;
        return this;
    }

    public Metadata addColunitSmallMoleculeItem(ColumnParameterMapping colunitSmallMoleculeItem) {
        if (this.colunitSmallMolecule == null) {
            this.colunitSmallMolecule = new ArrayList<ColumnParameterMapping>();
        }
        this.colunitSmallMolecule.add(colunitSmallMoleculeItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Defines the used unit for a column in the small molecule section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule-quantification_unit.")
    public List<ColumnParameterMapping> getColunitSmallMolecule() {
        return this.colunitSmallMolecule;
    }

    public void setColunitSmallMolecule(List<ColumnParameterMapping> colunitSmallMolecule) {
        this.colunitSmallMolecule = colunitSmallMolecule;
    }

    public Metadata colunitSmallMoleculeFeature(List<ColumnParameterMapping> colunitSmallMoleculeFeature) {
        this.colunitSmallMoleculeFeature = colunitSmallMoleculeFeature;
        return this;
    }

    public Metadata addColunitSmallMoleculeFeatureItem(ColumnParameterMapping colunitSmallMoleculeFeatureItem) {
        if (this.colunitSmallMoleculeFeature == null) {
            this.colunitSmallMoleculeFeature = new ArrayList<ColumnParameterMapping>();
        }
        this.colunitSmallMoleculeFeature.add(colunitSmallMoleculeFeatureItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Defines the used unit for a column in the small molecule feature section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule_feature-quantification_unit.")
    public List<ColumnParameterMapping> getColunitSmallMoleculeFeature() {
        return this.colunitSmallMoleculeFeature;
    }

    public void setColunitSmallMoleculeFeature(List<ColumnParameterMapping> colunitSmallMoleculeFeature) {
        this.colunitSmallMoleculeFeature = colunitSmallMoleculeFeature;
    }

    public Metadata colunitSmallMoleculeEvidence(List<ColumnParameterMapping> colunitSmallMoleculeEvidence) {
        this.colunitSmallMoleculeEvidence = colunitSmallMoleculeEvidence;
        return this;
    }

    public Metadata addColunitSmallMoleculeEvidenceItem(ColumnParameterMapping colunitSmallMoleculeEvidenceItem) {
        if (this.colunitSmallMoleculeEvidence == null) {
            this.colunitSmallMoleculeEvidence = new ArrayList<ColumnParameterMapping>();
        }
        this.colunitSmallMoleculeEvidence.add(colunitSmallMoleculeEvidenceItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Defines the used unit for a column in the small molecule evidence section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}.")
    public List<ColumnParameterMapping> getColunitSmallMoleculeEvidence() {
        return this.colunitSmallMoleculeEvidence;
    }

    public void setColunitSmallMoleculeEvidence(List<ColumnParameterMapping> colunitSmallMoleculeEvidence) {
        this.colunitSmallMoleculeEvidence = colunitSmallMoleculeEvidence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals((Object)this.prefix, (Object)metadata.prefix) && Objects.equals(this.mzTabVersion, metadata.mzTabVersion) && Objects.equals(this.mzTabID, metadata.mzTabID) && Objects.equals(this.title, metadata.title) && Objects.equals(this.description, metadata.description) && Objects.equals(this.contact, metadata.contact) && Objects.equals(this.publication, metadata.publication) && Objects.equals(this.uri, metadata.uri) && Objects.equals(this.externalStudyUri, metadata.externalStudyUri) && Objects.equals(this.instrument, metadata.instrument) && Objects.equals(this.quantificationMethod, metadata.quantificationMethod) && Objects.equals(this.sample, metadata.sample) && Objects.equals(this.sampleProcessing, metadata.sampleProcessing) && Objects.equals(this.software, metadata.software) && Objects.equals(this.derivatizationAgent, metadata.derivatizationAgent) && Objects.equals(this.msRun, metadata.msRun) && Objects.equals(this.assay, metadata.assay) && Objects.equals(this.studyVariable, metadata.studyVariable) && Objects.equals(this.custom, metadata.custom) && Objects.equals(this.cv, metadata.cv) && Objects.equals(this.smallMoleculeQuantificationUnit, metadata.smallMoleculeQuantificationUnit) && Objects.equals(this.smallMoleculeFeatureQuantificationUnit, metadata.smallMoleculeFeatureQuantificationUnit) && Objects.equals(this.smallMoleculeIdentificationReliability, metadata.smallMoleculeIdentificationReliability) && Objects.equals(this.database, metadata.database) && Objects.equals(this.idConfidenceMeasure, metadata.idConfidenceMeasure) && Objects.equals(this.colunitSmallMolecule, metadata.colunitSmallMolecule) && Objects.equals(this.colunitSmallMoleculeFeature, metadata.colunitSmallMoleculeFeature) && Objects.equals(this.colunitSmallMoleculeEvidence, metadata.colunitSmallMoleculeEvidence);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.mzTabVersion, this.mzTabID, this.title, this.description, this.contact, this.publication, this.uri, this.externalStudyUri, this.instrument, this.quantificationMethod, this.sample, this.sampleProcessing, this.software, this.derivatizationAgent, this.msRun, this.assay, this.studyVariable, this.custom, this.cv, this.smallMoleculeQuantificationUnit, this.smallMoleculeFeatureQuantificationUnit, this.smallMoleculeIdentificationReliability, this.database, this.idConfidenceMeasure, this.colunitSmallMolecule, this.colunitSmallMoleculeFeature, this.colunitSmallMoleculeEvidence});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Metadata {\n");
        sb.append("    prefix: ").append(this.toIndentedString((Object)this.prefix)).append("\n");
        sb.append("    mzTabVersion: ").append(this.toIndentedString(this.mzTabVersion)).append("\n");
        sb.append("    mzTabID: ").append(this.toIndentedString(this.mzTabID)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    publication: ").append(this.toIndentedString(this.publication)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    externalStudyUri: ").append(this.toIndentedString(this.externalStudyUri)).append("\n");
        sb.append("    instrument: ").append(this.toIndentedString(this.instrument)).append("\n");
        sb.append("    quantificationMethod: ").append(this.toIndentedString(this.quantificationMethod)).append("\n");
        sb.append("    sample: ").append(this.toIndentedString(this.sample)).append("\n");
        sb.append("    sampleProcessing: ").append(this.toIndentedString(this.sampleProcessing)).append("\n");
        sb.append("    software: ").append(this.toIndentedString(this.software)).append("\n");
        sb.append("    derivatizationAgent: ").append(this.toIndentedString(this.derivatizationAgent)).append("\n");
        sb.append("    msRun: ").append(this.toIndentedString(this.msRun)).append("\n");
        sb.append("    assay: ").append(this.toIndentedString(this.assay)).append("\n");
        sb.append("    studyVariable: ").append(this.toIndentedString(this.studyVariable)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    cv: ").append(this.toIndentedString(this.cv)).append("\n");
        sb.append("    smallMoleculeQuantificationUnit: ").append(this.toIndentedString(this.smallMoleculeQuantificationUnit)).append("\n");
        sb.append("    smallMoleculeFeatureQuantificationUnit: ").append(this.toIndentedString(this.smallMoleculeFeatureQuantificationUnit)).append("\n");
        sb.append("    smallMoleculeIdentificationReliability: ").append(this.toIndentedString(this.smallMoleculeIdentificationReliability)).append("\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    idConfidenceMeasure: ").append(this.toIndentedString(this.idConfidenceMeasure)).append("\n");
        sb.append("    colunitSmallMolecule: ").append(this.toIndentedString(this.colunitSmallMolecule)).append("\n");
        sb.append("    colunitSmallMoleculeFeature: ").append(this.toIndentedString(this.colunitSmallMoleculeFeature)).append("\n");
        sb.append("    colunitSmallMoleculeEvidence: ").append(this.toIndentedString(this.colunitSmallMoleculeEvidence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PrefixEnum {
        MTD("MTD");

        private String value;

        private PrefixEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrefixEnum fromValue(String text) {
            for (PrefixEnum b : PrefixEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum Properties {
        prefix("prefix"),
        mzTabVersion("mzTab-version"),
        mzTabID("mzTab-ID"),
        title("title"),
        description("description"),
        contact("contact"),
        publication("publication"),
        uri("uri"),
        externalStudyUri("external_study_uri"),
        instrument("instrument"),
        quantificationMethod("quantification_method"),
        sample("sample"),
        sampleProcessing("sample_processing"),
        software("software"),
        derivatizationAgent("derivatization_agent"),
        msRun("ms_run"),
        assay("assay"),
        studyVariable("study_variable"),
        custom("custom"),
        cv("cv"),
        smallMoleculeQuantificationUnit("small_molecule-quantification_unit"),
        smallMoleculeFeatureQuantificationUnit("small_molecule_feature-quantification_unit"),
        smallMoleculeIdentificationReliability("small_molecule-identification_reliability"),
        database("database"),
        idConfidenceMeasure("id_confidence_measure"),
        colunitSmallMolecule("colunit-small_molecule"),
        colunitSmallMoleculeFeature("colunit-small_molecule_feature"),
        colunitSmallMoleculeEvidence("colunit-small_molecule_evidence");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

