/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Instrument;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=MsRun.class)
@ApiModel(description="Specification of ms_run.  location: Location of the external data file e.g. raw files on which analysis has been performed. If the actual location of the MS run is unknown, a \u201cnull\u201d MUST be used as a place holder value, since the [1-n] cardinality is referenced elsewhere. If pre-fractionation has been performed, then [1-n] ms_runs SHOULD be created per assay.  instrument_ref: If different instruments are used in different runs, instrument_ref can be used to link a specific instrument to a specific run.  format: Parameter specifying the data format of the external MS data file. If ms_run[1-n]-format is present, ms_run[1-n]-id_format SHOULD also be present, following the parameters specified in Table 1.  id_format: Parameter specifying the id format used in the external data file. If ms_run[1-n]-id_format is present, ms_run[1-n]-format SHOULD also be present. fragmentation_method: The type(s) of fragmentation used in a given ms run. scan_polarity: The polarity mode of a given run. Usually only one value SHOULD be given here except for the case of mixed polarity runs. hash: Hash value of the corresponding external MS data file defined in ms_run[1-n]-location. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present. hash_method: A parameter specifying the hash methods used to generate the String in ms_run[1-n]-hash. Specifics of the hash method used MAY follow the definitions of the mzML format. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present. ")
@XmlRootElement(name="MsRun")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="MsRun")
public class MsRun {
    @JsonProperty(value="id")
    @JacksonXmlProperty(localName="id")
    @XmlElement(name="id")
    private Integer id = null;
    @JsonProperty(value="name")
    @JacksonXmlProperty(localName="name")
    @XmlElement(name="name")
    private String name = null;
    @JsonProperty(value="location")
    @JacksonXmlProperty(localName="location")
    @XmlElement(name="location")
    private String location = null;
    @JsonProperty(value="instrument_ref")
    @JacksonXmlProperty(localName="instrument_ref")
    @XmlElement(name="instrument_ref")
    private Instrument instrumentRef = null;
    @JsonProperty(value="format")
    @JacksonXmlProperty(localName="format")
    @XmlElement(name="format")
    private Parameter format = null;
    @JsonProperty(value="id_format")
    @JacksonXmlProperty(localName="id_format")
    @XmlElement(name="id_format")
    private Parameter idFormat = null;
    @JsonProperty(value="fragmentation_method")
    @XmlElement(name="fragmentationMethod")
    private List<Parameter> fragmentationMethod = null;
    @JsonProperty(value="scan_polarity")
    @XmlElement(name="scanPolarity")
    private List<Parameter> scanPolarity = null;
    @JsonProperty(value="hash")
    @JacksonXmlProperty(localName="hash")
    @XmlElement(name="hash")
    private String hash = null;
    @JsonProperty(value="hash_method")
    @JacksonXmlProperty(localName="hash_method")
    @XmlElement(name="hash_method")
    private Parameter hashMethod = null;

    public MsRun id(Integer id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @ApiModelProperty(required=true, value="")
    public @NotNull @Min(value=1L) Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public MsRun name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The msRun's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MsRun location(String location) {
        this.location = location;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The msRun's location URI.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public MsRun instrumentRef(Instrument instrumentRef) {
        this.instrumentRef = instrumentRef;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The instrument on which this msRun was measured.")
    public Instrument getInstrumentRef() {
        return this.instrumentRef;
    }

    public void setInstrumentRef(Instrument instrumentRef) {
        this.instrumentRef = instrumentRef;
    }

    public MsRun format(Parameter format) {
        this.format = format;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The msRun's file format.")
    public Parameter getFormat() {
        return this.format;
    }

    public void setFormat(Parameter format) {
        this.format = format;
    }

    public MsRun idFormat(Parameter idFormat) {
        this.idFormat = idFormat;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The msRun's mass spectra id format.")
    public Parameter getIdFormat() {
        return this.idFormat;
    }

    public void setIdFormat(Parameter idFormat) {
        this.idFormat = idFormat;
    }

    public MsRun fragmentationMethod(List<Parameter> fragmentationMethod) {
        this.fragmentationMethod = fragmentationMethod;
        return this;
    }

    public MsRun addFragmentationMethodItem(Parameter fragmentationMethodItem) {
        if (this.fragmentationMethod == null) {
            this.fragmentationMethod = new ArrayList<Parameter>();
        }
        this.fragmentationMethod.add(fragmentationMethodItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="The fragmentation methods applied during this msRun.")
    public List<Parameter> getFragmentationMethod() {
        return this.fragmentationMethod;
    }

    public void setFragmentationMethod(List<Parameter> fragmentationMethod) {
        this.fragmentationMethod = fragmentationMethod;
    }

    public MsRun scanPolarity(List<Parameter> scanPolarity) {
        this.scanPolarity = scanPolarity;
        return this;
    }

    public MsRun addScanPolarityItem(Parameter scanPolarityItem) {
        if (this.scanPolarity == null) {
            this.scanPolarity = new ArrayList<Parameter>();
        }
        this.scanPolarity.add(scanPolarityItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="The scan polarity/polarities used during this msRun.")
    public List<Parameter> getScanPolarity() {
        return this.scanPolarity;
    }

    public void setScanPolarity(List<Parameter> scanPolarity) {
        this.scanPolarity = scanPolarity;
    }

    public MsRun hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(value="The file hash value of this msRun's data file.")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public MsRun hashMethod(Parameter hashMethod) {
        this.hashMethod = hashMethod;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The hash method used to calculate the file hash.")
    public Parameter getHashMethod() {
        return this.hashMethod;
    }

    public void setHashMethod(Parameter hashMethod) {
        this.hashMethod = hashMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MsRun msRun = (MsRun)o;
        return Objects.equals(this.id, msRun.id) && Objects.equals(this.name, msRun.name) && Objects.equals(this.location, msRun.location) && Objects.equals(this.instrumentRef, msRun.instrumentRef) && Objects.equals(this.format, msRun.format) && Objects.equals(this.idFormat, msRun.idFormat) && Objects.equals(this.fragmentationMethod, msRun.fragmentationMethod) && Objects.equals(this.scanPolarity, msRun.scanPolarity) && Objects.equals(this.hash, msRun.hash) && Objects.equals(this.hashMethod, msRun.hashMethod);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.location, this.instrumentRef, this.format, this.idFormat, this.fragmentationMethod, this.scanPolarity, this.hash, this.hashMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsRun {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    instrumentRef: ").append(this.toIndentedString(this.instrumentRef)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    idFormat: ").append(this.toIndentedString(this.idFormat)).append("\n");
        sb.append("    fragmentationMethod: ").append(this.toIndentedString(this.fragmentationMethod)).append("\n");
        sb.append("    scanPolarity: ").append(this.toIndentedString(this.scanPolarity)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    hashMethod: ").append(this.toIndentedString(this.hashMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        id("id"),
        name("name"),
        location("location"),
        instrumentRef("instrument_ref"),
        format("format"),
        idFormat("id_format"),
        fragmentationMethod("fragmentation_method"),
        scanPolarity("scan_polarity"),
        hash("hash"),
        hashMethod("hash_method");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

