/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.Database;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.MzTab;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.SmallMoleculeEvidence;
import de.isas.mztab2.model.SmallMoleculeFeature;
import de.isas.mztab2.model.SmallMoleculeSummary;
import de.isas.mztab2.model.StudyVariable;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MzTabAccess {
    private final MzTab mzTab;

    public MzTabAccess(MzTab mzTab) {
        this.mzTab = mzTab;
    }

    public List<SmallMoleculeFeature> getFeatures(SmallMoleculeSummary sms) {
        List<Integer> smfIds = sms.getSmfIdRefs();
        return this.mzTab.getSmallMoleculeFeature().stream().filter(t -> smfIds.contains(t.getSmfId())).collect(Collectors.toList());
    }

    public List<SmallMoleculeEvidence> getEvidences(SmallMoleculeFeature smf) {
        List<Integer> smeIds = smf.getSmeIdRefs();
        return this.mzTab.getSmallMoleculeEvidence().stream().filter(t -> smeIds.contains(t.getSmeId())).collect(Collectors.toList());
    }

    public List<SmallMoleculeEvidence> getEvidencesByEvidenceInputId(String evidenceInputId) {
        return this.mzTab.getSmallMoleculeEvidence().stream().filter(t -> t.getEvidenceInputId().equals(evidenceInputId)).collect(Collectors.toList());
    }

    public Double getAbundanceFor(Assay assay, SmallMoleculeFeature smf) {
        return smf.getAbundanceAssay().get(assay.getId() - 1);
    }

    public Double getAbundanceFor(StudyVariable studyVariable, SmallMoleculeSummary sms) {
        return sms.getAbundanceStudyVariable().get(studyVariable.getId() - 1);
    }

    public Double getAbundanceVariationFor(StudyVariable studyVariable, SmallMoleculeSummary sms) {
        return sms.getAbundanceVariationStudyVariable().get(studyVariable.getId() - 1);
    }

    public Double getAbundanceFor(Assay assay, SmallMoleculeSummary sms) {
        return sms.getAbundanceAssay().get(assay.getId() - 1);
    }

    public Optional<Assay> getAssayFor(Integer id, Metadata metadata) {
        return metadata.getAssay().stream().filter(t -> t.getId().equals(id)).findFirst();
    }

    public Optional<StudyVariable> getStudyVariableFor(Integer id, Metadata metadata) {
        return metadata.getStudyVariable().stream().filter(t -> t.getId().equals(id)).findFirst();
    }

    public Optional<MsRun> getMsRunFor(Integer id, Metadata metadata) {
        return metadata.getMsRun().stream().filter(t -> t.getId().equals(id)).findFirst();
    }

    public Optional<Database> getDatabaseFor(Integer id, Metadata metadata) {
        return metadata.getDatabase().stream().filter(t -> t.getId().equals(id)).findFirst();
    }

    public Optional<Assay> getAssayFor(OptColumnMapping columnMapping, Metadata metadata) {
        Pattern p;
        Matcher m;
        String identifier = columnMapping.getIdentifier();
        if (identifier != null && (m = (p = Pattern.compile("assay\\[(\\d+)\\]")).matcher(identifier)).find()) {
            Integer assayId = Integer.parseInt(m.group(1));
            return this.getAssayFor(assayId, metadata);
        }
        return Optional.empty();
    }
}

