/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="Additional columns can be added to the end of the small molecule table. These column headers MUST start with the prefix \u201copt_\u201d followed by the {identifier} of the object they reference: assay, study variable, MS run or \u201cglobal\u201d (if the value relates to all replicates). Column names MUST only contain the following characters: \u2018A\u2019-\u2018Z\u2019, \u2018a\u2019-\u2018z\u2019, \u20180\u2019-\u20189\u2019, \u2018\u2019, \u2018-\u2019, \u2018[\u2019, \u2018]\u2019, and \u2018:\u2019. CV parameter accessions MAY be used for optional columns following the format: opt{identifier}_cv_{accession}_\\{parameter name}. Spaces within the parameter\u2019s name MUST be replaced by \u2018_\u2019. ")
@XmlRootElement(name="OptColumnMapping")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="OptColumnMapping")
public class OptColumnMapping {
    @JsonProperty(value="identifier")
    @JacksonXmlProperty(localName="identifier")
    @XmlElement(name="identifier")
    private String identifier = null;
    @JsonProperty(value="param")
    @JacksonXmlProperty(localName="param")
    @XmlElement(name="param")
    private Parameter param = null;
    @JsonProperty(value="value")
    @JacksonXmlProperty(localName="value")
    @XmlElement(name="value")
    private String value = null;

    public OptColumnMapping identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The fully qualified column name.")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public OptColumnMapping param(Parameter param) {
        this.param = param;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The (optional) parameter for this column.")
    public Parameter getParam() {
        return this.param;
    }

    public void setParam(Parameter param) {
        this.param = param;
    }

    public OptColumnMapping value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The value for this column in a particular row.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptColumnMapping optColumnMapping = (OptColumnMapping)o;
        return Objects.equals(this.identifier, optColumnMapping.identifier) && Objects.equals(this.param, optColumnMapping.param) && Objects.equals(this.value, optColumnMapping.value);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.param, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptColumnMapping {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    param: ").append(this.toIndentedString(this.param)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        identifier("identifier"),
        param("param"),
        value("value");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

