/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Comment;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="The small molecule feature section is table-based, representing individual MS regions (generally considered to be the elution profile for all isotopomers formed from a single charge state of a molecule), that have been measured/quantified. However, for approaches that quantify individual isotopomers e.g. stable isotope labelling/flux studies, then each SMF row SHOULD represent a single isotopomer.  Different adducts or derivatives and different charge states of individual molecules should be reported as separate SMF rows.  The small molecule feature section MUST always come after the Small Molecule Table. All table columns MUST be Tab separated. There MUST NOT be any empty cells. Missing values MUST be reported using \u201cnull\u201d.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for \u201copt_\u201d columns. ")
@XmlRootElement(name="SmallMoleculeFeature")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="SmallMoleculeFeature")
public class SmallMoleculeFeature {
    @JsonProperty(value="prefix")
    @JacksonXmlProperty(localName="prefix")
    @XmlElement(name="prefix")
    private PrefixEnum prefix = PrefixEnum.SMF;
    @JsonProperty(value="header_prefix")
    @JacksonXmlProperty(localName="header_prefix")
    @XmlElement(name="header_prefix")
    private HeaderPrefixEnum headerPrefix = HeaderPrefixEnum.SFH;
    @JsonProperty(value="smf_id")
    @JacksonXmlProperty(localName="smf_id")
    @XmlElement(name="smf_id")
    private Integer smfId = null;
    @JsonProperty(value="sme_id_refs")
    @XmlElement(name="smeIdRefs")
    private List<Integer> smeIdRefs = null;
    @JsonProperty(value="sme_id_ref_ambiguity_code")
    @JacksonXmlProperty(localName="sme_id_ref_ambiguity_code")
    @XmlElement(name="sme_id_ref_ambiguity_code")
    private Integer smeIdRefAmbiguityCode = null;
    @JsonProperty(value="adduct_ion")
    @JacksonXmlProperty(localName="adduct_ion")
    @XmlElement(name="adduct_ion")
    private String adductIon = null;
    @JsonProperty(value="isotopomer")
    @JacksonXmlProperty(localName="isotopomer")
    @XmlElement(name="isotopomer")
    private Parameter isotopomer = null;
    @JsonProperty(value="exp_mass_to_charge")
    @JacksonXmlProperty(localName="exp_mass_to_charge")
    @XmlElement(name="exp_mass_to_charge")
    private Double expMassToCharge = null;
    @JsonProperty(value="charge")
    @JacksonXmlProperty(localName="charge")
    @XmlElement(name="charge")
    private Integer charge = null;
    @JsonProperty(value="retention_time_in_seconds")
    @JacksonXmlProperty(localName="retention_time_in_seconds")
    @XmlElement(name="retention_time_in_seconds")
    private Double retentionTimeInSeconds = null;
    @JsonProperty(value="retention_time_in_seconds_start")
    @JacksonXmlProperty(localName="retention_time_in_seconds_start")
    @XmlElement(name="retention_time_in_seconds_start")
    private Double retentionTimeInSecondsStart = null;
    @JsonProperty(value="retention_time_in_seconds_end")
    @JacksonXmlProperty(localName="retention_time_in_seconds_end")
    @XmlElement(name="retention_time_in_seconds_end")
    private Double retentionTimeInSecondsEnd = null;
    @JsonProperty(value="abundance_assay")
    @XmlElement(name="abundanceAssay")
    private List<Double> abundanceAssay = null;
    @JsonProperty(value="opt")
    @XmlElement(name="opt")
    private List<OptColumnMapping> opt = null;
    @JsonProperty(value="comment")
    @XmlElement(name="comment")
    private List<Comment> comment = null;

    @ApiModelProperty(value="The small molecule feature table row prefix. SMF MUST be used for rows of the small molecule feature table.")
    public PrefixEnum getPrefix() {
        return this.prefix;
    }

    @ApiModelProperty(value="The small molecule feature table header prefix. SFH MUST be used for the small molecule feature table header line (the column labels).")
    public HeaderPrefixEnum getHeaderPrefix() {
        return this.headerPrefix;
    }

    public SmallMoleculeFeature smfId(Integer smfId) {
        this.smfId = smfId;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="A within file unique identifier for the small molecule feature.")
    public Integer getSmfId() {
        return this.smfId;
    }

    public void setSmfId(Integer smfId) {
        this.smfId = smfId;
    }

    public SmallMoleculeFeature smeIdRefs(List<Integer> smeIdRefs) {
        this.smeIdRefs = smeIdRefs;
        return this;
    }

    public SmallMoleculeFeature addSmeIdRefsItem(Integer smeIdRefsItem) {
        if (this.smeIdRefs == null) {
            this.smeIdRefs = new ArrayList<Integer>();
        }
        this.smeIdRefs.add(smeIdRefsItem);
        return this;
    }

    @ApiModelProperty(value="References to the identification evidence (SME elements) via referencing SME_ID values. Multiple values MAY be provided as a \u201c|\u201d separated list to indicate ambiguity in the identification or to indicate that different types of data supported the identifiction (see SME_ID_REF_ambiguity_code). For the case of a consensus approach where multiple adduct forms are used to infer the SML ID, different features should just reference the same SME_ID value(s).")
    public List<Integer> getSmeIdRefs() {
        return this.smeIdRefs;
    }

    public void setSmeIdRefs(List<Integer> smeIdRefs) {
        this.smeIdRefs = smeIdRefs;
    }

    public SmallMoleculeFeature smeIdRefAmbiguityCode(Integer smeIdRefAmbiguityCode) {
        this.smeIdRefAmbiguityCode = smeIdRefAmbiguityCode;
        return this;
    }

    @ApiModelProperty(value="If multiple values are given under SME_ID_REFS, one of the following codes MUST be provided. 1=Ambiguous identification; 2=Only different evidence streams for the same molecule with no ambiguity; 3=Both ambiguous identification and multiple evidence streams. If there are no or one value under SME_ID_REFs, this MUST be reported as null.")
    public Integer getSmeIdRefAmbiguityCode() {
        return this.smeIdRefAmbiguityCode;
    }

    public void setSmeIdRefAmbiguityCode(Integer smeIdRefAmbiguityCode) {
        this.smeIdRefAmbiguityCode = smeIdRefAmbiguityCode;
    }

    public SmallMoleculeFeature adductIon(String adductIon) {
        this.adductIon = adductIon;
        return this;
    }

    @Pattern(regexp="^\\[\\d*M([+-][\\w]*)\\]\\d*[+-]$")
    @ApiModelProperty(value="The assumed classification of this molecule\u2019s adduct ion after detection, following the general style in the 2013 IUPAC recommendations on terms relating to MS e.g. [M+H]1+, [M+Na]1+, [M+NH4]1+, [M-H]1-, [M+Cl]1-, [M+H]1+.")
    public @Pattern(regexp="^\\[\\d*M([+-][\\w]*)\\]\\d*[+-]$") String getAdductIon() {
        return this.adductIon;
    }

    public void setAdductIon(String adductIon) {
        this.adductIon = adductIon;
    }

    public SmallMoleculeFeature isotopomer(Parameter isotopomer) {
        this.isotopomer = isotopomer;
        return this;
    }

    @Valid
    @ApiModelProperty(value="If de-isotoping has not been performed, then the isotopomer quantified MUST be reported here e.g. \u201c+1\u201d, \u201c+2\u201d, \u201c13C peak\u201d using CV terms, otherwise (i.e. for approaches where SMF rows are de-isotoped features) this MUST be null.")
    public Parameter getIsotopomer() {
        return this.isotopomer;
    }

    public void setIsotopomer(Parameter isotopomer) {
        this.isotopomer = isotopomer;
    }

    public SmallMoleculeFeature expMassToCharge(Double expMassToCharge) {
        this.expMassToCharge = expMassToCharge;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The experimental mass/charge value for the feature, by default assumed to be the mean across assays or a representative value. For approaches that report isotopomers as SMF rows, then the m/z of the isotopomer MUST be reported here.")
    public Double getExpMassToCharge() {
        return this.expMassToCharge;
    }

    public void setExpMassToCharge(Double expMassToCharge) {
        this.expMassToCharge = expMassToCharge;
    }

    public SmallMoleculeFeature charge(Integer charge) {
        this.charge = charge;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The feature\u2019s charge value using positive integers both for positive and negative polarity modes.")
    public Integer getCharge() {
        return this.charge;
    }

    public void setCharge(Integer charge) {
        this.charge = charge;
    }

    public SmallMoleculeFeature retentionTimeInSeconds(Double retentionTimeInSeconds) {
        this.retentionTimeInSeconds = retentionTimeInSeconds;
        return this;
    }

    @ApiModelProperty(value="The apex of the feature on the retention time axis, in a Master or aggregate MS run. Retention time MUST be reported in seconds. Retention time values for individual MS runs (i.e. before alignment) MAY be reported as optional columns. Retention time SHOULD only be null in the case of direct infusion MS or other techniques where a retention time value is absent or unknown. Relative retention time or retention time index values MAY be reported as optional columns, and could be considered for inclusion in future versions of mzTab as appropriate.")
    public Double getRetentionTimeInSeconds() {
        return this.retentionTimeInSeconds;
    }

    public void setRetentionTimeInSeconds(Double retentionTimeInSeconds) {
        this.retentionTimeInSeconds = retentionTimeInSeconds;
    }

    public SmallMoleculeFeature retentionTimeInSecondsStart(Double retentionTimeInSecondsStart) {
        this.retentionTimeInSecondsStart = retentionTimeInSecondsStart;
        return this;
    }

    @ApiModelProperty(value="The start time of the feature on the retention time axis, in a Master or aggregate MS run. Retention time MUST be reported in seconds. Retention time start and end SHOULD only be null in the case of direct infusion MS or other techniques where a retention time value is absent or unknown and MAY be reported in optional columns.")
    public Double getRetentionTimeInSecondsStart() {
        return this.retentionTimeInSecondsStart;
    }

    public void setRetentionTimeInSecondsStart(Double retentionTimeInSecondsStart) {
        this.retentionTimeInSecondsStart = retentionTimeInSecondsStart;
    }

    public SmallMoleculeFeature retentionTimeInSecondsEnd(Double retentionTimeInSecondsEnd) {
        this.retentionTimeInSecondsEnd = retentionTimeInSecondsEnd;
        return this;
    }

    @ApiModelProperty(value="The end time of the feature on the retention time axis, in a Master or aggregate MS run. Retention time MUST be reported in seconds. Retention time start and end SHOULD only be null in the case of direct infusion MS or other techniques where a retention time value is absent or unknown and MAY be reported in optional columns..")
    public Double getRetentionTimeInSecondsEnd() {
        return this.retentionTimeInSecondsEnd;
    }

    public void setRetentionTimeInSecondsEnd(Double retentionTimeInSecondsEnd) {
        this.retentionTimeInSecondsEnd = retentionTimeInSecondsEnd;
    }

    public SmallMoleculeFeature abundanceAssay(List<Double> abundanceAssay) {
        this.abundanceAssay = abundanceAssay;
        return this;
    }

    public SmallMoleculeFeature addAbundanceAssayItem(Double abundanceAssayItem) {
        if (this.abundanceAssay == null) {
            this.abundanceAssay = new ArrayList<Double>();
        }
        this.abundanceAssay.add(abundanceAssayItem);
        return this;
    }

    @ApiModelProperty(value="The feature\u2019s abundance in every assay described in the metadata section MUST be reported. Null or zero values may be reported as appropriate.")
    public List<Double> getAbundanceAssay() {
        return this.abundanceAssay;
    }

    public void setAbundanceAssay(List<Double> abundanceAssay) {
        this.abundanceAssay = abundanceAssay;
    }

    public SmallMoleculeFeature opt(List<OptColumnMapping> opt) {
        this.opt = opt;
        return this;
    }

    public SmallMoleculeFeature addOptItem(OptColumnMapping optItem) {
        if (this.opt == null) {
            this.opt = new ArrayList<OptColumnMapping>();
        }
        this.opt.add(optItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Additional columns can be added to the end of the small molecule feature table. These column headers MUST start with the prefix \u201copt_\u201d followed by the {identifier} of the object they reference: assay, study variable, MS run or \u201cglobal\u201d (if the value relates to all replicates). Column names MUST only contain the following characters: \u2018A\u2019-\u2018Z\u2019, \u2018a\u2019-\u2018z\u2019, \u20180\u2019-\u20189\u2019, \u2018\u2019, \u2018-\u2019, \u2018[\u2019, \u2018]\u2019, and \u2018:\u2019. CV parameter accessions MAY be used for optional columns following the format: opt{identifier}_cv_{accession}_\\{parameter name}. Spaces within the parameter\u2019s name MUST be replaced by \u2018_\u2019. ")
    public List<OptColumnMapping> getOpt() {
        return this.opt;
    }

    public void setOpt(List<OptColumnMapping> opt) {
        this.opt = opt;
    }

    public SmallMoleculeFeature comment(List<Comment> comment) {
        this.comment = comment;
        return this;
    }

    public SmallMoleculeFeature addCommentItem(Comment commentItem) {
        if (this.comment == null) {
            this.comment = new ArrayList<Comment>();
        }
        this.comment.add(commentItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<Comment> getComment() {
        return this.comment;
    }

    public void setComment(List<Comment> comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmallMoleculeFeature smallMoleculeFeature = (SmallMoleculeFeature)o;
        return Objects.equals((Object)this.prefix, (Object)smallMoleculeFeature.prefix) && Objects.equals((Object)this.headerPrefix, (Object)smallMoleculeFeature.headerPrefix) && Objects.equals(this.smfId, smallMoleculeFeature.smfId) && Objects.equals(this.smeIdRefs, smallMoleculeFeature.smeIdRefs) && Objects.equals(this.smeIdRefAmbiguityCode, smallMoleculeFeature.smeIdRefAmbiguityCode) && Objects.equals(this.adductIon, smallMoleculeFeature.adductIon) && Objects.equals(this.isotopomer, smallMoleculeFeature.isotopomer) && Objects.equals(this.expMassToCharge, smallMoleculeFeature.expMassToCharge) && Objects.equals(this.charge, smallMoleculeFeature.charge) && Objects.equals(this.retentionTimeInSeconds, smallMoleculeFeature.retentionTimeInSeconds) && Objects.equals(this.retentionTimeInSecondsStart, smallMoleculeFeature.retentionTimeInSecondsStart) && Objects.equals(this.retentionTimeInSecondsEnd, smallMoleculeFeature.retentionTimeInSecondsEnd) && Objects.equals(this.abundanceAssay, smallMoleculeFeature.abundanceAssay) && Objects.equals(this.opt, smallMoleculeFeature.opt) && Objects.equals(this.comment, smallMoleculeFeature.comment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.headerPrefix, this.smfId, this.smeIdRefs, this.smeIdRefAmbiguityCode, this.adductIon, this.isotopomer, this.expMassToCharge, this.charge, this.retentionTimeInSeconds, this.retentionTimeInSecondsStart, this.retentionTimeInSecondsEnd, this.abundanceAssay, this.opt, this.comment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmallMoleculeFeature {\n");
        sb.append("    prefix: ").append(this.toIndentedString((Object)this.prefix)).append("\n");
        sb.append("    headerPrefix: ").append(this.toIndentedString((Object)this.headerPrefix)).append("\n");
        sb.append("    smfId: ").append(this.toIndentedString(this.smfId)).append("\n");
        sb.append("    smeIdRefs: ").append(this.toIndentedString(this.smeIdRefs)).append("\n");
        sb.append("    smeIdRefAmbiguityCode: ").append(this.toIndentedString(this.smeIdRefAmbiguityCode)).append("\n");
        sb.append("    adductIon: ").append(this.toIndentedString(this.adductIon)).append("\n");
        sb.append("    isotopomer: ").append(this.toIndentedString(this.isotopomer)).append("\n");
        sb.append("    expMassToCharge: ").append(this.toIndentedString(this.expMassToCharge)).append("\n");
        sb.append("    charge: ").append(this.toIndentedString(this.charge)).append("\n");
        sb.append("    retentionTimeInSeconds: ").append(this.toIndentedString(this.retentionTimeInSeconds)).append("\n");
        sb.append("    retentionTimeInSecondsStart: ").append(this.toIndentedString(this.retentionTimeInSecondsStart)).append("\n");
        sb.append("    retentionTimeInSecondsEnd: ").append(this.toIndentedString(this.retentionTimeInSecondsEnd)).append("\n");
        sb.append("    abundanceAssay: ").append(this.toIndentedString(this.abundanceAssay)).append("\n");
        sb.append("    opt: ").append(this.toIndentedString(this.opt)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HeaderPrefixEnum {
        SFH("SFH");

        private String value;

        private HeaderPrefixEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HeaderPrefixEnum fromValue(String text) {
            for (HeaderPrefixEnum b : HeaderPrefixEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum PrefixEnum {
        SMF("SMF");

        private String value;

        private PrefixEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrefixEnum fromValue(String text) {
            for (PrefixEnum b : PrefixEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum Properties {
        prefix("prefix"),
        headerPrefix("header_prefix"),
        smfId("smf_id"),
        smeIdRefs("sme_id_refs"),
        smeIdRefAmbiguityCode("sme_id_ref_ambiguity_code"),
        adductIon("adduct_ion"),
        isotopomer("isotopomer"),
        expMassToCharge("exp_mass_to_charge"),
        charge("charge"),
        retentionTimeInSeconds("retention_time_in_seconds"),
        retentionTimeInSecondsStart("retention_time_in_seconds_start"),
        retentionTimeInSecondsEnd("retention_time_in_seconds_end"),
        abundanceAssay("abundance_assay"),
        opt("opt"),
        comment("comment");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

