/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.errors;

import de.isas.mztab2.model.ValidationMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorType;

public class MZTabError
implements Serializable {
    private int lineNumber;
    private MZTabErrorType type;
    private String message;

    public MZTabError(MZTabErrorType type, int lineNumber, String ... values) {
        if (type == null) {
            throw new NullPointerException("MZTabErrorType should not set null");
        }
        this.type = type;
        this.lineNumber = lineNumber;
        ArrayList<String> valueList = new ArrayList<String>();
        for (String value : values) {
            valueList.add(value == null ? "" : value);
        }
        this.message = this.fill(0, valueList, type.getOriginal());
    }

    private String fill(int count, List<String> values, String message) {
        String regexp = "\\{\\w\\}";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            if (count >= values.size()) {
                throw new ArrayIndexOutOfBoundsException("Tried to replace placeholder " + (count + 1) + " but only " + values.size() + " values are available for " + this.getClass().getSimpleName() + " " + this.type.toString());
            }
            String value = values.get(count);
            message = matcher.replaceFirst(Matcher.quoteReplacement(value));
            return this.fill(count + 1, values, message);
        }
        return message;
    }

    public MZTabErrorType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append((Object)this.type.getLevel()).append("-").append(this.type.getCode()).append("] ");
        sb.append("line ").append(this.lineNumber).append(": ");
        sb.append(this.message).append("\r\n");
        return sb.toString();
    }

    public ValidationMessage toValidationMessage() throws IllegalStateException {
        ValidationMessage.MessageTypeEnum level = ValidationMessage.MessageTypeEnum.INFO;
        switch (this.getType().getLevel()) {
            case Error: {
                level = ValidationMessage.MessageTypeEnum.ERROR;
                break;
            }
            case Info: {
                level = ValidationMessage.MessageTypeEnum.INFO;
                break;
            }
            case Warn: {
                level = ValidationMessage.MessageTypeEnum.WARN;
                break;
            }
            default: {
                throw new IllegalStateException("State " + this.getType().getLevel() + " is not handled in switch/case statement!");
            }
        }
        ValidationMessage.CategoryEnum category = ValidationMessage.CategoryEnum.FORMAT;
        switch (this.getType().getCategory()) {
            case Format: {
                category = ValidationMessage.CategoryEnum.FORMAT;
                break;
            }
            case Logical: {
                category = ValidationMessage.CategoryEnum.LOGICAL;
                break;
            }
            case CrossCheck: {
                category = ValidationMessage.CategoryEnum.CROSS_CHECK;
                break;
            }
            default: {
                throw new IllegalStateException("Category " + this.getType().getCategory() + " is not handled in switch/case statement!");
            }
        }
        ValidationMessage vr = new ValidationMessage().lineNumber(Long.valueOf(this.getLineNumber())).category(category).messageType(level).message(this.getMessage()).code(this.toString());
        return vr;
    }
}

