# Metadata

The metadata section provides additional information about the dataset(s) reported in the mzTab file. All fields in the metadata section are optional apart from those noted as mandatory. The fields in the metadata section MUST be reported in order of the various fields listed here. The field’s name and value MUST be separated by a tab character.  
## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**prefix** | **str** | The metadata section prefix. MUST always be MTD.  | [default to 'MTD']
**mz_tab_version** | **str** | The version of the mzTab file. The suffix MUST be \&quot;-M\&quot; for mzTab for metabolomics (mzTab-M).  | 
**mz_tab_id** | **str** | The ID of the mzTab file, this could be supplied by the repository from which it is downloaded or a local identifier from the lab producing the file. It is not intended to be a globally unique ID but carry some locally useful meaning.  | 
**title** | **str** | The file’s human readable title.  | [optional] 
**description** | **str** | The file’s human readable description.  | [optional] 
**contact** | [**list[Contact]**](Contact.md) | The contact’s name, affiliation and e-mail. Several contacts can be given by indicating the number in the square brackets after \&quot;contact\&quot;. A contact has to be supplied in the format [first name] [initials] [last name]. | [optional] 
**publication** | [**list[Publication]**](Publication.md) | A publication associated with this file. Several publications can be given by indicating the number in the square brackets after “publication”. PubMed ids must be prefixed by “pubmed:”, DOIs by “doi:”. Multiple identifiers MUST be separated by “|”. | [optional] 
**uri** | [**list[Uri]**](Uri.md) | A URI pointing to the file’s source data (e.g., a MetaboLights records). | [optional] 
**external_study_uri** | [**list[Uri]**](Uri.md) | A URI pointing to an external file with more details about the study design (e.g., an ISA-TAB file). | [optional] 
**instrument** | [**list[Instrument]**](Instrument.md) | The name, source, analyzer and detector of the instruments used in the experiment. Multiple instruments are numbered [1-n]. | [optional] 
**quantification_method** | [**Parameter**](Parameter.md) |  | 
**sample** | [**list[Sample]**](Sample.md) | Specification of sample. (empty) name: A name for each sample to serve as a list of the samples that MUST be reported in the following tables. Samples MUST be reported if a statistical design is being captured (i.e. bio or tech replicates). If the type of replicates are not known, samples SHOULD NOT be reported.  species: The respective species of the samples analysed. For more complex cases, such as metagenomics, optional columns and userParams should be used.  tissue: The respective tissue(s) of the sample.  cell_type: The respective cell type(s) of the sample.  disease: The respective disease(s) of the sample.  description: A human readable description of the sample.  custom: Custom parameters describing the sample’s additional properties. Dates MUST be provided in ISO-8601 format.  | [optional] 
**sample_processing** | [**list[SampleProcessing]**](SampleProcessing.md) | A list of parameters describing a sample processing, preparation or handling step similar to a biological or analytical methods report. The order of the sample_processing items should reflect the order these processing steps were performed in. If multiple parameters are given for a step these MUST be separated by a “|”. If derivatization was performed, it MUST be reported here as a general step, e.g. &#39;silylation&#39; and the actual derivatization agens MUST be specified in the Section 6.2.54 part.  | [optional] 
**software** | [**list[Software]**](Software.md) | Software used to analyze the data and obtain the reported results. The parameter’s value SHOULD contain the software’s version. The order (numbering) should reflect the order in which the tools were used. A software setting used. This field MAY occur multiple times for a single software. The value of this field is deliberately set as a String, since there currently do not exist CV terms for every possible setting. | 
**derivatization_agent** | [**list[Parameter]**](Parameter.md) | A description of derivatization agents applied to small molecules, using userParams or CV terms where possible. | [optional] 
**ms_run** | [**list[MsRun]**](MsRun.md) | Specification of ms_run.  location: Location of the external data file e.g. raw files on which analysis has been performed. If the actual location of the MS run is unknown, a “null” MUST be used as a place holder value, since the [1-n] cardinality is referenced elsewhere. If pre-fractionation has been performed, then [1-n] ms_runs SHOULD be created per assay.  instrument_ref: If different instruments are used in different runs, instrument_ref can be used to link a specific instrument to a specific run.  format: Parameter specifying the data format of the external MS data file. If ms_run[1-n]-format is present, ms_run[1-n]-id_format SHOULD also be present, following the parameters specified in Table 1.  id_format: Parameter specifying the id format used in the external data file. If ms_run[1-n]-id_format is present, ms_run[1-n]-format SHOULD also be present. fragmentation_method: The type(s) of fragmentation used in a given ms run. scan_polarity: The polarity mode of a given run. Usually only one value SHOULD be given here except for the case of mixed polarity runs. hash: Hash value of the corresponding external MS data file defined in ms_run[1-n]-location. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present. hash_method: A parameter specifying the hash methods used to generate the String in ms_run[1-n]-hash. Specifics of the hash method used MAY follow the definitions of the mzML format. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present.  | 
**assay** | [**list[Assay]**](Assay.md) | Specification of assay. (empty) name: A name for each assay, to serve as a list of the assays that MUST be reported in the following tables.  custom: Additional custom parameters or values for a given assay.  external_uri: An external reference uri to further information about the assay, for example via a reference to an object within an ISA-TAB file.  sample_ref: An association from a given assay to the sample analysed.  ms_run_ref: An association from a given assay to the source MS run. All assays MUST reference exactly one ms_run unless a workflow with pre-fractionation is being encoded, in which case each assay MUST reference n ms_runs where n fractions have been collected. Multiple assays SHOULD reference the same ms_run to capture multiplexed experimental designs.  | 
**study_variable** | [**list[StudyVariable]**](StudyVariable.md) | Specification of study_variable. (empty) name: A name for each study variable (experimental condition or factor), to serve as a list of the study variables that MUST be reported in the following tables. For software that does not capture study variables, a single study variable MUST be reported, linking to all assays. This single study variable MUST have the identifier “undefined“. assay_refs: Bar-separated references to the IDs of assays grouped in the study variable. average_function: The function used to calculate the study variable quantification value and the operation used is not arithmetic mean (default) e.g. “geometric mean”, “median”. The 1-n refers to different study variables. variation_function: The function used to calculate the study variable quantification variation value if it is reported and the operation used is not coefficient of variation (default) e.g. “standard error”. description: A textual description of the study variable. factors: Additional parameters or factors, separated by bars, that are known about study variables allowing the capture of more complex, such as nested designs.  | 
**custom** | [**list[Parameter]**](Parameter.md) | Any additional parameters describing the analysis reported. | [optional] 
**cv** | [**list[CV]**](CV.md) | Specification of controlled vocabularies. label: A string describing the labels of the controlled vocabularies/ontologies used in the mzTab file as a short-hand e.g. \&quot;MS\&quot; for PSI-MS. full_name: A string describing the full names of the controlled vocabularies/ontologies used in the mzTab file. version: A string describing the version of the controlled vocabularies/ontologies used in the mzTab file. uri: A string containing the URIs of the controlled vocabularies/ontologies used in the mzTab file.  | 
**small_molecule_quantification_unit** | [**Parameter**](Parameter.md) |  | 
**small_molecule_feature_quantification_unit** | [**Parameter**](Parameter.md) |  | 
**small_molecule_identification_reliability** | [**Parameter**](Parameter.md) |  | [optional] 
**database** | [**list[Database]**](Database.md) | Specification of databases. (empty): The description of databases used. For cases, where a known database has not been used for identification, a userParam SHOULD be inserted to describe any identification performed e.g. de novo. If no identification has been performed at all then \&quot;no database\&quot; should be inserted followed by null. prefix: The prefix used in the “identifier” column of data tables. For the “no database” case \&quot;null\&quot; must be used. version: The database version is mandatory where identification has been performed. This may be a formal version number e.g. “1.4.1”, a date of access “2016-10-27” (ISO-8601 format) or “Unknown” if there is no suitable version that can be annotated. uri: The URI to the database. For the “no database” case, \&quot;null\&quot; must be reported.  | 
**id_confidence_measure** | [**list[Parameter]**](Parameter.md) | The type of small molecule confidence measures or scores MUST be reported as a CV parameter [1-n]. The CV parameter definition should formally state whether the ordering is high to low or vice versa. The order of the scores SHOULD reflect their importance for the identification and be used to determine the identification’s rank. | 
**colunit_small_molecule** | [**list[ColumnParameterMapping]**](ColumnParameterMapping.md) | Defines the used unit for a column in the small molecule section. The format of the value has to be \\{column name}&#x3D;\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule-quantification_unit. | [optional] 
**colunit_small_molecule_feature** | [**list[ColumnParameterMapping]**](ColumnParameterMapping.md) | Defines the used unit for a column in the small molecule feature section. The format of the value has to be \\{column name}&#x3D;\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule_feature-quantification_unit. | [optional] 
**colunit_small_molecule_evidence** | [**list[ColumnParameterMapping]**](ColumnParameterMapping.md) | Defines the used unit for a column in the small molecule evidence section. The format of the value has to be \\{column name}&#x3D;\\{Parameter defining the unit}. | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


