# coding: utf-8

"""
    mzTab-M reference implementation and validation API.

    This is the mzTab-M reference implementation and validation API service.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: nils.hoffmann@isas.de
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openapi_client.configuration import Configuration


class Metadata(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'prefix': 'str',
        'mz_tab_version': 'str',
        'mz_tab_id': 'str',
        'title': 'str',
        'description': 'str',
        'contact': 'list[Contact]',
        'publication': 'list[Publication]',
        'uri': 'list[Uri]',
        'external_study_uri': 'list[Uri]',
        'instrument': 'list[Instrument]',
        'quantification_method': 'Parameter',
        'sample': 'list[Sample]',
        'sample_processing': 'list[SampleProcessing]',
        'software': 'list[Software]',
        'derivatization_agent': 'list[Parameter]',
        'ms_run': 'list[MsRun]',
        'assay': 'list[Assay]',
        'study_variable': 'list[StudyVariable]',
        'custom': 'list[Parameter]',
        'cv': 'list[CV]',
        'small_molecule_quantification_unit': 'Parameter',
        'small_molecule_feature_quantification_unit': 'Parameter',
        'small_molecule_identification_reliability': 'Parameter',
        'database': 'list[Database]',
        'id_confidence_measure': 'list[Parameter]',
        'colunit_small_molecule': 'list[ColumnParameterMapping]',
        'colunit_small_molecule_feature': 'list[ColumnParameterMapping]',
        'colunit_small_molecule_evidence': 'list[ColumnParameterMapping]'
    }

    attribute_map = {
        'prefix': 'prefix',
        'mz_tab_version': 'mzTab-version',
        'mz_tab_id': 'mzTab-ID',
        'title': 'title',
        'description': 'description',
        'contact': 'contact',
        'publication': 'publication',
        'uri': 'uri',
        'external_study_uri': 'external_study_uri',
        'instrument': 'instrument',
        'quantification_method': 'quantification_method',
        'sample': 'sample',
        'sample_processing': 'sample_processing',
        'software': 'software',
        'derivatization_agent': 'derivatization_agent',
        'ms_run': 'ms_run',
        'assay': 'assay',
        'study_variable': 'study_variable',
        'custom': 'custom',
        'cv': 'cv',
        'small_molecule_quantification_unit': 'small_molecule-quantification_unit',
        'small_molecule_feature_quantification_unit': 'small_molecule_feature-quantification_unit',
        'small_molecule_identification_reliability': 'small_molecule-identification_reliability',
        'database': 'database',
        'id_confidence_measure': 'id_confidence_measure',
        'colunit_small_molecule': 'colunit-small_molecule',
        'colunit_small_molecule_feature': 'colunit-small_molecule_feature',
        'colunit_small_molecule_evidence': 'colunit-small_molecule_evidence'
    }

    def __init__(self, prefix='MTD', mz_tab_version=None, mz_tab_id=None, title=None, description=None, contact=None, publication=None, uri=None, external_study_uri=None, instrument=None, quantification_method=None, sample=None, sample_processing=None, software=None, derivatization_agent=None, ms_run=None, assay=None, study_variable=None, custom=None, cv=None, small_molecule_quantification_unit=None, small_molecule_feature_quantification_unit=None, small_molecule_identification_reliability=None, database=None, id_confidence_measure=None, colunit_small_molecule=None, colunit_small_molecule_feature=None, colunit_small_molecule_evidence=None, local_vars_configuration=None):  # noqa: E501
        """Metadata - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._prefix = None
        self._mz_tab_version = None
        self._mz_tab_id = None
        self._title = None
        self._description = None
        self._contact = None
        self._publication = None
        self._uri = None
        self._external_study_uri = None
        self._instrument = None
        self._quantification_method = None
        self._sample = None
        self._sample_processing = None
        self._software = None
        self._derivatization_agent = None
        self._ms_run = None
        self._assay = None
        self._study_variable = None
        self._custom = None
        self._cv = None
        self._small_molecule_quantification_unit = None
        self._small_molecule_feature_quantification_unit = None
        self._small_molecule_identification_reliability = None
        self._database = None
        self._id_confidence_measure = None
        self._colunit_small_molecule = None
        self._colunit_small_molecule_feature = None
        self._colunit_small_molecule_evidence = None
        self.discriminator = None

        self.prefix = prefix
        self.mz_tab_version = mz_tab_version
        self.mz_tab_id = mz_tab_id
        if title is not None:
            self.title = title
        if description is not None:
            self.description = description
        if contact is not None:
            self.contact = contact
        if publication is not None:
            self.publication = publication
        if uri is not None:
            self.uri = uri
        if external_study_uri is not None:
            self.external_study_uri = external_study_uri
        if instrument is not None:
            self.instrument = instrument
        self.quantification_method = quantification_method
        if sample is not None:
            self.sample = sample
        if sample_processing is not None:
            self.sample_processing = sample_processing
        self.software = software
        if derivatization_agent is not None:
            self.derivatization_agent = derivatization_agent
        self.ms_run = ms_run
        self.assay = assay
        self.study_variable = study_variable
        if custom is not None:
            self.custom = custom
        self.cv = cv
        self.small_molecule_quantification_unit = small_molecule_quantification_unit
        self.small_molecule_feature_quantification_unit = small_molecule_feature_quantification_unit
        if small_molecule_identification_reliability is not None:
            self.small_molecule_identification_reliability = small_molecule_identification_reliability
        self.database = database
        self.id_confidence_measure = id_confidence_measure
        if colunit_small_molecule is not None:
            self.colunit_small_molecule = colunit_small_molecule
        if colunit_small_molecule_feature is not None:
            self.colunit_small_molecule_feature = colunit_small_molecule_feature
        if colunit_small_molecule_evidence is not None:
            self.colunit_small_molecule_evidence = colunit_small_molecule_evidence

    @property
    def prefix(self):
        """Gets the prefix of this Metadata.  # noqa: E501

        The metadata section prefix. MUST always be MTD.   # noqa: E501

        :return: The prefix of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this Metadata.

        The metadata section prefix. MUST always be MTD.   # noqa: E501

        :param prefix: The prefix of this Metadata.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and prefix is None:  # noqa: E501
            raise ValueError("Invalid value for `prefix`, must not be `None`")  # noqa: E501
        allowed_values = ["MTD"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and prefix not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `prefix` ({0}), must be one of {1}"  # noqa: E501
                .format(prefix, allowed_values)
            )

        self._prefix = prefix

    @property
    def mz_tab_version(self):
        """Gets the mz_tab_version of this Metadata.  # noqa: E501

        The version of the mzTab file. The suffix MUST be \"-M\" for mzTab for metabolomics (mzTab-M).   # noqa: E501

        :return: The mz_tab_version of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._mz_tab_version

    @mz_tab_version.setter
    def mz_tab_version(self, mz_tab_version):
        """Sets the mz_tab_version of this Metadata.

        The version of the mzTab file. The suffix MUST be \"-M\" for mzTab for metabolomics (mzTab-M).   # noqa: E501

        :param mz_tab_version: The mz_tab_version of this Metadata.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and mz_tab_version is None:  # noqa: E501
            raise ValueError("Invalid value for `mz_tab_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                mz_tab_version is not None and not re.search(r'^\d{1}\.\d{1}\.\d{1}-[A-Z]{1}$', mz_tab_version)):  # noqa: E501
            raise ValueError(r"Invalid value for `mz_tab_version`, must be a follow pattern or equal to `/^\d{1}\.\d{1}\.\d{1}-[A-Z]{1}$/`")  # noqa: E501

        self._mz_tab_version = mz_tab_version

    @property
    def mz_tab_id(self):
        """Gets the mz_tab_id of this Metadata.  # noqa: E501

        The ID of the mzTab file, this could be supplied by the repository from which it is downloaded or a local identifier from the lab producing the file. It is not intended to be a globally unique ID but carry some locally useful meaning.   # noqa: E501

        :return: The mz_tab_id of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._mz_tab_id

    @mz_tab_id.setter
    def mz_tab_id(self, mz_tab_id):
        """Sets the mz_tab_id of this Metadata.

        The ID of the mzTab file, this could be supplied by the repository from which it is downloaded or a local identifier from the lab producing the file. It is not intended to be a globally unique ID but carry some locally useful meaning.   # noqa: E501

        :param mz_tab_id: The mz_tab_id of this Metadata.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and mz_tab_id is None:  # noqa: E501
            raise ValueError("Invalid value for `mz_tab_id`, must not be `None`")  # noqa: E501

        self._mz_tab_id = mz_tab_id

    @property
    def title(self):
        """Gets the title of this Metadata.  # noqa: E501

        The file’s human readable title.   # noqa: E501

        :return: The title of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Metadata.

        The file’s human readable title.   # noqa: E501

        :param title: The title of this Metadata.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def description(self):
        """Gets the description of this Metadata.  # noqa: E501

        The file’s human readable description.   # noqa: E501

        :return: The description of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Metadata.

        The file’s human readable description.   # noqa: E501

        :param description: The description of this Metadata.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def contact(self):
        """Gets the contact of this Metadata.  # noqa: E501

        The contact’s name, affiliation and e-mail. Several contacts can be given by indicating the number in the square brackets after \"contact\". A contact has to be supplied in the format [first name] [initials] [last name].  # noqa: E501

        :return: The contact of this Metadata.  # noqa: E501
        :rtype: list[Contact]
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """Sets the contact of this Metadata.

        The contact’s name, affiliation and e-mail. Several contacts can be given by indicating the number in the square brackets after \"contact\". A contact has to be supplied in the format [first name] [initials] [last name].  # noqa: E501

        :param contact: The contact of this Metadata.  # noqa: E501
        :type: list[Contact]
        """

        self._contact = contact

    @property
    def publication(self):
        """Gets the publication of this Metadata.  # noqa: E501

        A publication associated with this file. Several publications can be given by indicating the number in the square brackets after “publication”. PubMed ids must be prefixed by “pubmed:”, DOIs by “doi:”. Multiple identifiers MUST be separated by “|”.  # noqa: E501

        :return: The publication of this Metadata.  # noqa: E501
        :rtype: list[Publication]
        """
        return self._publication

    @publication.setter
    def publication(self, publication):
        """Sets the publication of this Metadata.

        A publication associated with this file. Several publications can be given by indicating the number in the square brackets after “publication”. PubMed ids must be prefixed by “pubmed:”, DOIs by “doi:”. Multiple identifiers MUST be separated by “|”.  # noqa: E501

        :param publication: The publication of this Metadata.  # noqa: E501
        :type: list[Publication]
        """

        self._publication = publication

    @property
    def uri(self):
        """Gets the uri of this Metadata.  # noqa: E501

        A URI pointing to the file’s source data (e.g., a MetaboLights records).  # noqa: E501

        :return: The uri of this Metadata.  # noqa: E501
        :rtype: list[Uri]
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this Metadata.

        A URI pointing to the file’s source data (e.g., a MetaboLights records).  # noqa: E501

        :param uri: The uri of this Metadata.  # noqa: E501
        :type: list[Uri]
        """

        self._uri = uri

    @property
    def external_study_uri(self):
        """Gets the external_study_uri of this Metadata.  # noqa: E501

        A URI pointing to an external file with more details about the study design (e.g., an ISA-TAB file).  # noqa: E501

        :return: The external_study_uri of this Metadata.  # noqa: E501
        :rtype: list[Uri]
        """
        return self._external_study_uri

    @external_study_uri.setter
    def external_study_uri(self, external_study_uri):
        """Sets the external_study_uri of this Metadata.

        A URI pointing to an external file with more details about the study design (e.g., an ISA-TAB file).  # noqa: E501

        :param external_study_uri: The external_study_uri of this Metadata.  # noqa: E501
        :type: list[Uri]
        """

        self._external_study_uri = external_study_uri

    @property
    def instrument(self):
        """Gets the instrument of this Metadata.  # noqa: E501

        The name, source, analyzer and detector of the instruments used in the experiment. Multiple instruments are numbered [1-n].  # noqa: E501

        :return: The instrument of this Metadata.  # noqa: E501
        :rtype: list[Instrument]
        """
        return self._instrument

    @instrument.setter
    def instrument(self, instrument):
        """Sets the instrument of this Metadata.

        The name, source, analyzer and detector of the instruments used in the experiment. Multiple instruments are numbered [1-n].  # noqa: E501

        :param instrument: The instrument of this Metadata.  # noqa: E501
        :type: list[Instrument]
        """

        self._instrument = instrument

    @property
    def quantification_method(self):
        """Gets the quantification_method of this Metadata.  # noqa: E501


        :return: The quantification_method of this Metadata.  # noqa: E501
        :rtype: Parameter
        """
        return self._quantification_method

    @quantification_method.setter
    def quantification_method(self, quantification_method):
        """Sets the quantification_method of this Metadata.


        :param quantification_method: The quantification_method of this Metadata.  # noqa: E501
        :type: Parameter
        """
        if self.local_vars_configuration.client_side_validation and quantification_method is None:  # noqa: E501
            raise ValueError("Invalid value for `quantification_method`, must not be `None`")  # noqa: E501

        self._quantification_method = quantification_method

    @property
    def sample(self):
        """Gets the sample of this Metadata.  # noqa: E501

        Specification of sample. (empty) name: A name for each sample to serve as a list of the samples that MUST be reported in the following tables. Samples MUST be reported if a statistical design is being captured (i.e. bio or tech replicates). If the type of replicates are not known, samples SHOULD NOT be reported.  species: The respective species of the samples analysed. For more complex cases, such as metagenomics, optional columns and userParams should be used.  tissue: The respective tissue(s) of the sample.  cell_type: The respective cell type(s) of the sample.  disease: The respective disease(s) of the sample.  description: A human readable description of the sample.  custom: Custom parameters describing the sample’s additional properties. Dates MUST be provided in ISO-8601 format.   # noqa: E501

        :return: The sample of this Metadata.  # noqa: E501
        :rtype: list[Sample]
        """
        return self._sample

    @sample.setter
    def sample(self, sample):
        """Sets the sample of this Metadata.

        Specification of sample. (empty) name: A name for each sample to serve as a list of the samples that MUST be reported in the following tables. Samples MUST be reported if a statistical design is being captured (i.e. bio or tech replicates). If the type of replicates are not known, samples SHOULD NOT be reported.  species: The respective species of the samples analysed. For more complex cases, such as metagenomics, optional columns and userParams should be used.  tissue: The respective tissue(s) of the sample.  cell_type: The respective cell type(s) of the sample.  disease: The respective disease(s) of the sample.  description: A human readable description of the sample.  custom: Custom parameters describing the sample’s additional properties. Dates MUST be provided in ISO-8601 format.   # noqa: E501

        :param sample: The sample of this Metadata.  # noqa: E501
        :type: list[Sample]
        """

        self._sample = sample

    @property
    def sample_processing(self):
        """Gets the sample_processing of this Metadata.  # noqa: E501

        A list of parameters describing a sample processing, preparation or handling step similar to a biological or analytical methods report. The order of the sample_processing items should reflect the order these processing steps were performed in. If multiple parameters are given for a step these MUST be separated by a “|”. If derivatization was performed, it MUST be reported here as a general step, e.g. 'silylation' and the actual derivatization agens MUST be specified in the Section 6.2.54 part.   # noqa: E501

        :return: The sample_processing of this Metadata.  # noqa: E501
        :rtype: list[SampleProcessing]
        """
        return self._sample_processing

    @sample_processing.setter
    def sample_processing(self, sample_processing):
        """Sets the sample_processing of this Metadata.

        A list of parameters describing a sample processing, preparation or handling step similar to a biological or analytical methods report. The order of the sample_processing items should reflect the order these processing steps were performed in. If multiple parameters are given for a step these MUST be separated by a “|”. If derivatization was performed, it MUST be reported here as a general step, e.g. 'silylation' and the actual derivatization agens MUST be specified in the Section 6.2.54 part.   # noqa: E501

        :param sample_processing: The sample_processing of this Metadata.  # noqa: E501
        :type: list[SampleProcessing]
        """

        self._sample_processing = sample_processing

    @property
    def software(self):
        """Gets the software of this Metadata.  # noqa: E501

        Software used to analyze the data and obtain the reported results. The parameter’s value SHOULD contain the software’s version. The order (numbering) should reflect the order in which the tools were used. A software setting used. This field MAY occur multiple times for a single software. The value of this field is deliberately set as a String, since there currently do not exist CV terms for every possible setting.  # noqa: E501

        :return: The software of this Metadata.  # noqa: E501
        :rtype: list[Software]
        """
        return self._software

    @software.setter
    def software(self, software):
        """Sets the software of this Metadata.

        Software used to analyze the data and obtain the reported results. The parameter’s value SHOULD contain the software’s version. The order (numbering) should reflect the order in which the tools were used. A software setting used. This field MAY occur multiple times for a single software. The value of this field is deliberately set as a String, since there currently do not exist CV terms for every possible setting.  # noqa: E501

        :param software: The software of this Metadata.  # noqa: E501
        :type: list[Software]
        """
        if self.local_vars_configuration.client_side_validation and software is None:  # noqa: E501
            raise ValueError("Invalid value for `software`, must not be `None`")  # noqa: E501

        self._software = software

    @property
    def derivatization_agent(self):
        """Gets the derivatization_agent of this Metadata.  # noqa: E501

        A description of derivatization agents applied to small molecules, using userParams or CV terms where possible.  # noqa: E501

        :return: The derivatization_agent of this Metadata.  # noqa: E501
        :rtype: list[Parameter]
        """
        return self._derivatization_agent

    @derivatization_agent.setter
    def derivatization_agent(self, derivatization_agent):
        """Sets the derivatization_agent of this Metadata.

        A description of derivatization agents applied to small molecules, using userParams or CV terms where possible.  # noqa: E501

        :param derivatization_agent: The derivatization_agent of this Metadata.  # noqa: E501
        :type: list[Parameter]
        """

        self._derivatization_agent = derivatization_agent

    @property
    def ms_run(self):
        """Gets the ms_run of this Metadata.  # noqa: E501

        Specification of ms_run.  location: Location of the external data file e.g. raw files on which analysis has been performed. If the actual location of the MS run is unknown, a “null” MUST be used as a place holder value, since the [1-n] cardinality is referenced elsewhere. If pre-fractionation has been performed, then [1-n] ms_runs SHOULD be created per assay.  instrument_ref: If different instruments are used in different runs, instrument_ref can be used to link a specific instrument to a specific run.  format: Parameter specifying the data format of the external MS data file. If ms_run[1-n]-format is present, ms_run[1-n]-id_format SHOULD also be present, following the parameters specified in Table 1.  id_format: Parameter specifying the id format used in the external data file. If ms_run[1-n]-id_format is present, ms_run[1-n]-format SHOULD also be present. fragmentation_method: The type(s) of fragmentation used in a given ms run. scan_polarity: The polarity mode of a given run. Usually only one value SHOULD be given here except for the case of mixed polarity runs. hash: Hash value of the corresponding external MS data file defined in ms_run[1-n]-location. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present. hash_method: A parameter specifying the hash methods used to generate the String in ms_run[1-n]-hash. Specifics of the hash method used MAY follow the definitions of the mzML format. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present.   # noqa: E501

        :return: The ms_run of this Metadata.  # noqa: E501
        :rtype: list[MsRun]
        """
        return self._ms_run

    @ms_run.setter
    def ms_run(self, ms_run):
        """Sets the ms_run of this Metadata.

        Specification of ms_run.  location: Location of the external data file e.g. raw files on which analysis has been performed. If the actual location of the MS run is unknown, a “null” MUST be used as a place holder value, since the [1-n] cardinality is referenced elsewhere. If pre-fractionation has been performed, then [1-n] ms_runs SHOULD be created per assay.  instrument_ref: If different instruments are used in different runs, instrument_ref can be used to link a specific instrument to a specific run.  format: Parameter specifying the data format of the external MS data file. If ms_run[1-n]-format is present, ms_run[1-n]-id_format SHOULD also be present, following the parameters specified in Table 1.  id_format: Parameter specifying the id format used in the external data file. If ms_run[1-n]-id_format is present, ms_run[1-n]-format SHOULD also be present. fragmentation_method: The type(s) of fragmentation used in a given ms run. scan_polarity: The polarity mode of a given run. Usually only one value SHOULD be given here except for the case of mixed polarity runs. hash: Hash value of the corresponding external MS data file defined in ms_run[1-n]-location. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present. hash_method: A parameter specifying the hash methods used to generate the String in ms_run[1-n]-hash. Specifics of the hash method used MAY follow the definitions of the mzML format. If ms_run[1-n]-hash is present, ms_run[1-n]-hash_method SHOULD also be present.   # noqa: E501

        :param ms_run: The ms_run of this Metadata.  # noqa: E501
        :type: list[MsRun]
        """
        if self.local_vars_configuration.client_side_validation and ms_run is None:  # noqa: E501
            raise ValueError("Invalid value for `ms_run`, must not be `None`")  # noqa: E501

        self._ms_run = ms_run

    @property
    def assay(self):
        """Gets the assay of this Metadata.  # noqa: E501

        Specification of assay. (empty) name: A name for each assay, to serve as a list of the assays that MUST be reported in the following tables.  custom: Additional custom parameters or values for a given assay.  external_uri: An external reference uri to further information about the assay, for example via a reference to an object within an ISA-TAB file.  sample_ref: An association from a given assay to the sample analysed.  ms_run_ref: An association from a given assay to the source MS run. All assays MUST reference exactly one ms_run unless a workflow with pre-fractionation is being encoded, in which case each assay MUST reference n ms_runs where n fractions have been collected. Multiple assays SHOULD reference the same ms_run to capture multiplexed experimental designs.   # noqa: E501

        :return: The assay of this Metadata.  # noqa: E501
        :rtype: list[Assay]
        """
        return self._assay

    @assay.setter
    def assay(self, assay):
        """Sets the assay of this Metadata.

        Specification of assay. (empty) name: A name for each assay, to serve as a list of the assays that MUST be reported in the following tables.  custom: Additional custom parameters or values for a given assay.  external_uri: An external reference uri to further information about the assay, for example via a reference to an object within an ISA-TAB file.  sample_ref: An association from a given assay to the sample analysed.  ms_run_ref: An association from a given assay to the source MS run. All assays MUST reference exactly one ms_run unless a workflow with pre-fractionation is being encoded, in which case each assay MUST reference n ms_runs where n fractions have been collected. Multiple assays SHOULD reference the same ms_run to capture multiplexed experimental designs.   # noqa: E501

        :param assay: The assay of this Metadata.  # noqa: E501
        :type: list[Assay]
        """
        if self.local_vars_configuration.client_side_validation and assay is None:  # noqa: E501
            raise ValueError("Invalid value for `assay`, must not be `None`")  # noqa: E501

        self._assay = assay

    @property
    def study_variable(self):
        """Gets the study_variable of this Metadata.  # noqa: E501

        Specification of study_variable. (empty) name: A name for each study variable (experimental condition or factor), to serve as a list of the study variables that MUST be reported in the following tables. For software that does not capture study variables, a single study variable MUST be reported, linking to all assays. This single study variable MUST have the identifier “undefined“. assay_refs: Bar-separated references to the IDs of assays grouped in the study variable. average_function: The function used to calculate the study variable quantification value and the operation used is not arithmetic mean (default) e.g. “geometric mean”, “median”. The 1-n refers to different study variables. variation_function: The function used to calculate the study variable quantification variation value if it is reported and the operation used is not coefficient of variation (default) e.g. “standard error”. description: A textual description of the study variable. factors: Additional parameters or factors, separated by bars, that are known about study variables allowing the capture of more complex, such as nested designs.   # noqa: E501

        :return: The study_variable of this Metadata.  # noqa: E501
        :rtype: list[StudyVariable]
        """
        return self._study_variable

    @study_variable.setter
    def study_variable(self, study_variable):
        """Sets the study_variable of this Metadata.

        Specification of study_variable. (empty) name: A name for each study variable (experimental condition or factor), to serve as a list of the study variables that MUST be reported in the following tables. For software that does not capture study variables, a single study variable MUST be reported, linking to all assays. This single study variable MUST have the identifier “undefined“. assay_refs: Bar-separated references to the IDs of assays grouped in the study variable. average_function: The function used to calculate the study variable quantification value and the operation used is not arithmetic mean (default) e.g. “geometric mean”, “median”. The 1-n refers to different study variables. variation_function: The function used to calculate the study variable quantification variation value if it is reported and the operation used is not coefficient of variation (default) e.g. “standard error”. description: A textual description of the study variable. factors: Additional parameters or factors, separated by bars, that are known about study variables allowing the capture of more complex, such as nested designs.   # noqa: E501

        :param study_variable: The study_variable of this Metadata.  # noqa: E501
        :type: list[StudyVariable]
        """
        if self.local_vars_configuration.client_side_validation and study_variable is None:  # noqa: E501
            raise ValueError("Invalid value for `study_variable`, must not be `None`")  # noqa: E501

        self._study_variable = study_variable

    @property
    def custom(self):
        """Gets the custom of this Metadata.  # noqa: E501

        Any additional parameters describing the analysis reported.  # noqa: E501

        :return: The custom of this Metadata.  # noqa: E501
        :rtype: list[Parameter]
        """
        return self._custom

    @custom.setter
    def custom(self, custom):
        """Sets the custom of this Metadata.

        Any additional parameters describing the analysis reported.  # noqa: E501

        :param custom: The custom of this Metadata.  # noqa: E501
        :type: list[Parameter]
        """

        self._custom = custom

    @property
    def cv(self):
        """Gets the cv of this Metadata.  # noqa: E501

        Specification of controlled vocabularies. label: A string describing the labels of the controlled vocabularies/ontologies used in the mzTab file as a short-hand e.g. \"MS\" for PSI-MS. full_name: A string describing the full names of the controlled vocabularies/ontologies used in the mzTab file. version: A string describing the version of the controlled vocabularies/ontologies used in the mzTab file. uri: A string containing the URIs of the controlled vocabularies/ontologies used in the mzTab file.   # noqa: E501

        :return: The cv of this Metadata.  # noqa: E501
        :rtype: list[CV]
        """
        return self._cv

    @cv.setter
    def cv(self, cv):
        """Sets the cv of this Metadata.

        Specification of controlled vocabularies. label: A string describing the labels of the controlled vocabularies/ontologies used in the mzTab file as a short-hand e.g. \"MS\" for PSI-MS. full_name: A string describing the full names of the controlled vocabularies/ontologies used in the mzTab file. version: A string describing the version of the controlled vocabularies/ontologies used in the mzTab file. uri: A string containing the URIs of the controlled vocabularies/ontologies used in the mzTab file.   # noqa: E501

        :param cv: The cv of this Metadata.  # noqa: E501
        :type: list[CV]
        """
        if self.local_vars_configuration.client_side_validation and cv is None:  # noqa: E501
            raise ValueError("Invalid value for `cv`, must not be `None`")  # noqa: E501

        self._cv = cv

    @property
    def small_molecule_quantification_unit(self):
        """Gets the small_molecule_quantification_unit of this Metadata.  # noqa: E501


        :return: The small_molecule_quantification_unit of this Metadata.  # noqa: E501
        :rtype: Parameter
        """
        return self._small_molecule_quantification_unit

    @small_molecule_quantification_unit.setter
    def small_molecule_quantification_unit(self, small_molecule_quantification_unit):
        """Sets the small_molecule_quantification_unit of this Metadata.


        :param small_molecule_quantification_unit: The small_molecule_quantification_unit of this Metadata.  # noqa: E501
        :type: Parameter
        """
        if self.local_vars_configuration.client_side_validation and small_molecule_quantification_unit is None:  # noqa: E501
            raise ValueError("Invalid value for `small_molecule_quantification_unit`, must not be `None`")  # noqa: E501

        self._small_molecule_quantification_unit = small_molecule_quantification_unit

    @property
    def small_molecule_feature_quantification_unit(self):
        """Gets the small_molecule_feature_quantification_unit of this Metadata.  # noqa: E501


        :return: The small_molecule_feature_quantification_unit of this Metadata.  # noqa: E501
        :rtype: Parameter
        """
        return self._small_molecule_feature_quantification_unit

    @small_molecule_feature_quantification_unit.setter
    def small_molecule_feature_quantification_unit(self, small_molecule_feature_quantification_unit):
        """Sets the small_molecule_feature_quantification_unit of this Metadata.


        :param small_molecule_feature_quantification_unit: The small_molecule_feature_quantification_unit of this Metadata.  # noqa: E501
        :type: Parameter
        """
        if self.local_vars_configuration.client_side_validation and small_molecule_feature_quantification_unit is None:  # noqa: E501
            raise ValueError("Invalid value for `small_molecule_feature_quantification_unit`, must not be `None`")  # noqa: E501

        self._small_molecule_feature_quantification_unit = small_molecule_feature_quantification_unit

    @property
    def small_molecule_identification_reliability(self):
        """Gets the small_molecule_identification_reliability of this Metadata.  # noqa: E501


        :return: The small_molecule_identification_reliability of this Metadata.  # noqa: E501
        :rtype: Parameter
        """
        return self._small_molecule_identification_reliability

    @small_molecule_identification_reliability.setter
    def small_molecule_identification_reliability(self, small_molecule_identification_reliability):
        """Sets the small_molecule_identification_reliability of this Metadata.


        :param small_molecule_identification_reliability: The small_molecule_identification_reliability of this Metadata.  # noqa: E501
        :type: Parameter
        """

        self._small_molecule_identification_reliability = small_molecule_identification_reliability

    @property
    def database(self):
        """Gets the database of this Metadata.  # noqa: E501

        Specification of databases. (empty): The description of databases used. For cases, where a known database has not been used for identification, a userParam SHOULD be inserted to describe any identification performed e.g. de novo. If no identification has been performed at all then \"no database\" should be inserted followed by null. prefix: The prefix used in the “identifier” column of data tables. For the “no database” case \"null\" must be used. version: The database version is mandatory where identification has been performed. This may be a formal version number e.g. “1.4.1”, a date of access “2016-10-27” (ISO-8601 format) or “Unknown” if there is no suitable version that can be annotated. uri: The URI to the database. For the “no database” case, \"null\" must be reported.   # noqa: E501

        :return: The database of this Metadata.  # noqa: E501
        :rtype: list[Database]
        """
        return self._database

    @database.setter
    def database(self, database):
        """Sets the database of this Metadata.

        Specification of databases. (empty): The description of databases used. For cases, where a known database has not been used for identification, a userParam SHOULD be inserted to describe any identification performed e.g. de novo. If no identification has been performed at all then \"no database\" should be inserted followed by null. prefix: The prefix used in the “identifier” column of data tables. For the “no database” case \"null\" must be used. version: The database version is mandatory where identification has been performed. This may be a formal version number e.g. “1.4.1”, a date of access “2016-10-27” (ISO-8601 format) or “Unknown” if there is no suitable version that can be annotated. uri: The URI to the database. For the “no database” case, \"null\" must be reported.   # noqa: E501

        :param database: The database of this Metadata.  # noqa: E501
        :type: list[Database]
        """
        if self.local_vars_configuration.client_side_validation and database is None:  # noqa: E501
            raise ValueError("Invalid value for `database`, must not be `None`")  # noqa: E501

        self._database = database

    @property
    def id_confidence_measure(self):
        """Gets the id_confidence_measure of this Metadata.  # noqa: E501

        The type of small molecule confidence measures or scores MUST be reported as a CV parameter [1-n]. The CV parameter definition should formally state whether the ordering is high to low or vice versa. The order of the scores SHOULD reflect their importance for the identification and be used to determine the identification’s rank.  # noqa: E501

        :return: The id_confidence_measure of this Metadata.  # noqa: E501
        :rtype: list[Parameter]
        """
        return self._id_confidence_measure

    @id_confidence_measure.setter
    def id_confidence_measure(self, id_confidence_measure):
        """Sets the id_confidence_measure of this Metadata.

        The type of small molecule confidence measures or scores MUST be reported as a CV parameter [1-n]. The CV parameter definition should formally state whether the ordering is high to low or vice versa. The order of the scores SHOULD reflect their importance for the identification and be used to determine the identification’s rank.  # noqa: E501

        :param id_confidence_measure: The id_confidence_measure of this Metadata.  # noqa: E501
        :type: list[Parameter]
        """
        if self.local_vars_configuration.client_side_validation and id_confidence_measure is None:  # noqa: E501
            raise ValueError("Invalid value for `id_confidence_measure`, must not be `None`")  # noqa: E501

        self._id_confidence_measure = id_confidence_measure

    @property
    def colunit_small_molecule(self):
        """Gets the colunit_small_molecule of this Metadata.  # noqa: E501

        Defines the used unit for a column in the small molecule section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule-quantification_unit.  # noqa: E501

        :return: The colunit_small_molecule of this Metadata.  # noqa: E501
        :rtype: list[ColumnParameterMapping]
        """
        return self._colunit_small_molecule

    @colunit_small_molecule.setter
    def colunit_small_molecule(self, colunit_small_molecule):
        """Sets the colunit_small_molecule of this Metadata.

        Defines the used unit for a column in the small molecule section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule-quantification_unit.  # noqa: E501

        :param colunit_small_molecule: The colunit_small_molecule of this Metadata.  # noqa: E501
        :type: list[ColumnParameterMapping]
        """

        self._colunit_small_molecule = colunit_small_molecule

    @property
    def colunit_small_molecule_feature(self):
        """Gets the colunit_small_molecule_feature of this Metadata.  # noqa: E501

        Defines the used unit for a column in the small molecule feature section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule_feature-quantification_unit.  # noqa: E501

        :return: The colunit_small_molecule_feature of this Metadata.  # noqa: E501
        :rtype: list[ColumnParameterMapping]
        """
        return self._colunit_small_molecule_feature

    @colunit_small_molecule_feature.setter
    def colunit_small_molecule_feature(self, colunit_small_molecule_feature):
        """Sets the colunit_small_molecule_feature of this Metadata.

        Defines the used unit for a column in the small molecule feature section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule_feature-quantification_unit.  # noqa: E501

        :param colunit_small_molecule_feature: The colunit_small_molecule_feature of this Metadata.  # noqa: E501
        :type: list[ColumnParameterMapping]
        """

        self._colunit_small_molecule_feature = colunit_small_molecule_feature

    @property
    def colunit_small_molecule_evidence(self):
        """Gets the colunit_small_molecule_evidence of this Metadata.  # noqa: E501

        Defines the used unit for a column in the small molecule evidence section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}.  # noqa: E501

        :return: The colunit_small_molecule_evidence of this Metadata.  # noqa: E501
        :rtype: list[ColumnParameterMapping]
        """
        return self._colunit_small_molecule_evidence

    @colunit_small_molecule_evidence.setter
    def colunit_small_molecule_evidence(self, colunit_small_molecule_evidence):
        """Sets the colunit_small_molecule_evidence of this Metadata.

        Defines the used unit for a column in the small molecule evidence section. The format of the value has to be \\{column name}=\\{Parameter defining the unit}.  # noqa: E501

        :param colunit_small_molecule_evidence: The colunit_small_molecule_evidence of this Metadata.  # noqa: E501
        :type: list[ColumnParameterMapping]
        """

        self._colunit_small_molecule_evidence = colunit_small_molecule_evidence

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Metadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Metadata):
            return True

        return self.to_dict() != other.to_dict()
