# coding: utf-8

"""
    mzTab-M reference implementation and validation API.

    This is the mzTab-M reference implementation and validation API service.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: nils.hoffmann@isas.de
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openapi_client.configuration import Configuration


class MzTab(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'metadata': 'Metadata',
        'small_molecule_summary': 'list[SmallMoleculeSummary]',
        'small_molecule_feature': 'list[SmallMoleculeFeature]',
        'small_molecule_evidence': 'list[SmallMoleculeEvidence]',
        'comment': 'list[Comment]'
    }

    attribute_map = {
        'metadata': 'metadata',
        'small_molecule_summary': 'smallMoleculeSummary',
        'small_molecule_feature': 'smallMoleculeFeature',
        'small_molecule_evidence': 'smallMoleculeEvidence',
        'comment': 'comment'
    }

    def __init__(self, metadata=None, small_molecule_summary=None, small_molecule_feature=None, small_molecule_evidence=None, comment=None, local_vars_configuration=None):  # noqa: E501
        """MzTab - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._metadata = None
        self._small_molecule_summary = None
        self._small_molecule_feature = None
        self._small_molecule_evidence = None
        self._comment = None
        self.discriminator = None

        self.metadata = metadata
        self.small_molecule_summary = small_molecule_summary
        self.small_molecule_feature = small_molecule_feature
        self.small_molecule_evidence = small_molecule_evidence
        if comment is not None:
            self.comment = comment

    @property
    def metadata(self):
        """Gets the metadata of this MzTab.  # noqa: E501


        :return: The metadata of this MzTab.  # noqa: E501
        :rtype: Metadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this MzTab.


        :param metadata: The metadata of this MzTab.  # noqa: E501
        :type: Metadata
        """
        if self.local_vars_configuration.client_side_validation and metadata is None:  # noqa: E501
            raise ValueError("Invalid value for `metadata`, must not be `None`")  # noqa: E501

        self._metadata = metadata

    @property
    def small_molecule_summary(self):
        """Gets the small_molecule_summary of this MzTab.  # noqa: E501

        The small molecule section is table-based. The small molecule section MUST always come after the metadata section. All table columns MUST be Tab separated. There MUST NOT be any empty cells; missing values MUST be reported using “null” for columns where Is Nullable = “True”.  Each row of the small molecule section is intended to report one final result to be communicated in terms of a molecule that has been quantified. In many cases, this may be the molecule of biological interest, although in some cases, the final result could be a derivatized form as appropriate – although it is desirable for the database identifier(s) to reference to the biological (non-derivatized) form. In general, different adduct forms would generally be reported in the Small Molecule Feature section.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for “opt_” columns.   # noqa: E501

        :return: The small_molecule_summary of this MzTab.  # noqa: E501
        :rtype: list[SmallMoleculeSummary]
        """
        return self._small_molecule_summary

    @small_molecule_summary.setter
    def small_molecule_summary(self, small_molecule_summary):
        """Sets the small_molecule_summary of this MzTab.

        The small molecule section is table-based. The small molecule section MUST always come after the metadata section. All table columns MUST be Tab separated. There MUST NOT be any empty cells; missing values MUST be reported using “null” for columns where Is Nullable = “True”.  Each row of the small molecule section is intended to report one final result to be communicated in terms of a molecule that has been quantified. In many cases, this may be the molecule of biological interest, although in some cases, the final result could be a derivatized form as appropriate – although it is desirable for the database identifier(s) to reference to the biological (non-derivatized) form. In general, different adduct forms would generally be reported in the Small Molecule Feature section.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for “opt_” columns.   # noqa: E501

        :param small_molecule_summary: The small_molecule_summary of this MzTab.  # noqa: E501
        :type: list[SmallMoleculeSummary]
        """
        if self.local_vars_configuration.client_side_validation and small_molecule_summary is None:  # noqa: E501
            raise ValueError("Invalid value for `small_molecule_summary`, must not be `None`")  # noqa: E501

        self._small_molecule_summary = small_molecule_summary

    @property
    def small_molecule_feature(self):
        """Gets the small_molecule_feature of this MzTab.  # noqa: E501

        The small molecule feature section is table-based, representing individual MS regions (generally considered to be the elution profile for all isotopomers formed from a single charge state of a molecule), that have been measured/quantified. However, for approaches that quantify individual isotopomers e.g. stable isotope labelling/flux studies, then each SMF row SHOULD represent a single isotopomer.  Different adducts or derivatives and different charge states of individual molecules should be reported as separate SMF rows.  The small molecule feature section MUST always come after the Small Molecule Table. All table columns MUST be Tab separated. There MUST NOT be any empty cells. Missing values MUST be reported using “null”.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for “opt_” columns.   # noqa: E501

        :return: The small_molecule_feature of this MzTab.  # noqa: E501
        :rtype: list[SmallMoleculeFeature]
        """
        return self._small_molecule_feature

    @small_molecule_feature.setter
    def small_molecule_feature(self, small_molecule_feature):
        """Sets the small_molecule_feature of this MzTab.

        The small molecule feature section is table-based, representing individual MS regions (generally considered to be the elution profile for all isotopomers formed from a single charge state of a molecule), that have been measured/quantified. However, for approaches that quantify individual isotopomers e.g. stable isotope labelling/flux studies, then each SMF row SHOULD represent a single isotopomer.  Different adducts or derivatives and different charge states of individual molecules should be reported as separate SMF rows.  The small molecule feature section MUST always come after the Small Molecule Table. All table columns MUST be Tab separated. There MUST NOT be any empty cells. Missing values MUST be reported using “null”.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for “opt_” columns.   # noqa: E501

        :param small_molecule_feature: The small_molecule_feature of this MzTab.  # noqa: E501
        :type: list[SmallMoleculeFeature]
        """
        if self.local_vars_configuration.client_side_validation and small_molecule_feature is None:  # noqa: E501
            raise ValueError("Invalid value for `small_molecule_feature`, must not be `None`")  # noqa: E501

        self._small_molecule_feature = small_molecule_feature

    @property
    def small_molecule_evidence(self):
        """Gets the small_molecule_evidence of this MzTab.  # noqa: E501

        The small molecule evidence section is table-based, representing evidence for identifications of small molecules/features, from database search or any other process used to give putative identifications to molecules. In a typical case, each row represents one result from a single search or intepretation of a piece of evidence e.g. a database search with a fragmentation spectrum. Multiple results from a given input data item (e.g. one fragment spectrum) SHOULD share the same value under evidence_input_id.  The small molecule evidence section MUST always come after the Small Molecule Feature Table. All table columns MUST be Tab separated. There MUST NOT be any empty cells. Missing values MUST be reported using “null”.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for “opt_” columns.   # noqa: E501

        :return: The small_molecule_evidence of this MzTab.  # noqa: E501
        :rtype: list[SmallMoleculeEvidence]
        """
        return self._small_molecule_evidence

    @small_molecule_evidence.setter
    def small_molecule_evidence(self, small_molecule_evidence):
        """Sets the small_molecule_evidence of this MzTab.

        The small molecule evidence section is table-based, representing evidence for identifications of small molecules/features, from database search or any other process used to give putative identifications to molecules. In a typical case, each row represents one result from a single search or intepretation of a piece of evidence e.g. a database search with a fragmentation spectrum. Multiple results from a given input data item (e.g. one fragment spectrum) SHOULD share the same value under evidence_input_id.  The small molecule evidence section MUST always come after the Small Molecule Feature Table. All table columns MUST be Tab separated. There MUST NOT be any empty cells. Missing values MUST be reported using “null”.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for “opt_” columns.   # noqa: E501

        :param small_molecule_evidence: The small_molecule_evidence of this MzTab.  # noqa: E501
        :type: list[SmallMoleculeEvidence]
        """
        if self.local_vars_configuration.client_side_validation and small_molecule_evidence is None:  # noqa: E501
            raise ValueError("Invalid value for `small_molecule_evidence`, must not be `None`")  # noqa: E501

        self._small_molecule_evidence = small_molecule_evidence

    @property
    def comment(self):
        """Gets the comment of this MzTab.  # noqa: E501

        Comment lines can be placed anywhere in an mzTab file. These lines must start with the three-letter code COM and are ignored by most parsers. Empty lines can also occur anywhere in an mzTab file and are ignored.   # noqa: E501

        :return: The comment of this MzTab.  # noqa: E501
        :rtype: list[Comment]
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this MzTab.

        Comment lines can be placed anywhere in an mzTab file. These lines must start with the three-letter code COM and are ignored by most parsers. Empty lines can also occur anywhere in an mzTab file and are ignored.   # noqa: E501

        :param comment: The comment of this MzTab.  # noqa: E501
        :type: list[Comment]
        """

        self._comment = comment

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MzTab):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MzTab):
            return True

        return self.to_dict() != other.to_dict()
