/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.net.ExtendedSmtpManager;

@Plugin(name="SMTPx", category="Core", elementType="appender", printObject=true)
public final class ExtendedSmtpAppender
extends AbstractAppender {
    private final ExtendedSmtpManager manager;

    private ExtendedSmtpAppender(String name, Filter filter, Layout<? extends Serializable> layout, ExtendedSmtpManager manager, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.manager = manager;
    }

    @PluginFactory
    public static ExtendedSmtpAppender createAppender(@PluginAttribute(value="name") @Required(message="SMTP.name is missing") String name, @PluginAttribute(value="to") String to, @PluginAttribute(value="cc") String cc, @PluginAttribute(value="bcc") String bcc, @PluginAttribute(value="from") @Required(message="SMTP.from is missing") String from, @PluginAttribute(value="replyTo") String replyTo, @PluginAttribute(value="subject") @Required(message="SMTP.subject is missing") String subject, @PluginAttribute(value="subjectWithLayout") boolean subjectWithLayout, @PluginAttribute(value="smtpProtocol", defaultString="smtp") String smtpProtocol, @PluginAttribute(value="smtpHost") @Required(message="SMTP.smtpHost is missing") String smtpHost, @PluginAttribute(value="smtpPort", defaultInt=25) int smtpPort, @PluginAttribute(value="smtpUsername") String smtpUsername, @PluginAttribute(value="smtpPassword") String smtpPassword, @PluginAttribute(value="smtpDebug") boolean smtpDebug, @PluginAttribute(value="bufferSize", defaultInt=10) int bufferSize, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions, @PluginAttribute(value="burstSummarizingSeconds") int burstSummarizingSeconds, @PluginAttribute(value="bsCountInSubject") char bsCountInSubject, @PluginAttribute(value="bsLoggername") boolean bsLoggername, @PluginAttribute(value="bsMessagePrefixLength", defaultInt=30) int bsMessagePrefixLength, @PluginAttribute(value="bsMessageMaskDigits") boolean bsMessageMaskDigits, @PluginAttribute(value="bsExceptionClass", defaultBoolean=true) boolean bsExceptionClass, @PluginAttribute(value="bsExceptionOrigin") boolean bsExceptionOrigin, @PluginAttribute(value="bsRootExceptionClass") boolean bsRootExceptionClass) {
        ExtendedSmtpManager manager;
        if (layout == null) {
            layout = HtmlLayout.createDefaultLayout();
        }
        if (filter == null) {
            filter = ThresholdFilter.createFilter(null, null, null);
        }
        if ((manager = ExtendedSmtpManager.getSmtpManager(new ExtendedSmtpManager.FactoryData(to, cc, bcc, from, replyTo, subject, subjectWithLayout, smtpProtocol, smtpHost, smtpPort, smtpUsername, smtpPassword, smtpDebug, bufferSize, (long)burstSummarizingSeconds * 1000L, bsCountInSubject, bsLoggername, bsMessagePrefixLength, bsMessageMaskDigits, bsExceptionClass, bsExceptionOrigin, bsRootExceptionClass), filter.toString(), layout.getContentType())) == null) {
            return null;
        }
        return new ExtendedSmtpAppender(name, filter, (Layout<? extends Serializable>)layout, manager, ignoreExceptions);
    }

    public void stop() {
        super.stop();
        this.manager.close();
    }

    public boolean isFiltered(LogEvent event) {
        boolean filtered = super.isFiltered(event);
        if (filtered) {
            this.manager.add(event);
        }
        return filtered;
    }

    public void append(LogEvent event) {
        this.manager.sendEvents(this.getLayout(), event);
    }
}

