/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.MimeMessageBuilder;
import org.apache.logging.log4j.core.util.CyclicBuffer;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.util.PropertiesUtil;

public class ExtendedSmtpManager
extends AbstractManager {
    private static final SMTPManagerFactory FACTORY = new SMTPManagerFactory();
    private final FactoryData data;
    private final PatternLayout subjectLayout;
    private final Thread summarySender;
    private final CyclicBuffer<LogEvent> buffer;
    private final Session session;
    private volatile MimeMessage message;
    private Map<String, SummarizeData> summarizeDataCollector = new HashMap<String, SummarizeData>();
    private static final Pattern digitPattern = Pattern.compile("\\d+");
    private volatile long lastSummaryCheckMillis = System.currentTimeMillis();
    private String lastContentType = "text/plain";

    protected ExtendedSmtpManager(String name, Session session, MimeMessage message, FactoryData data) {
        super(null, name);
        this.session = session;
        this.message = message;
        this.data = data;
        this.subjectLayout = data.subjectWithLayout ? PatternLayout.newBuilder().withPattern(data.subject).withAlwaysWriteExceptions(false).build() : null;
        this.buffer = new CyclicBuffer(LogEvent.class, data.numElements);
        this.summarySender = this.startSummarySenderBackgroundThread();
    }

    public static ExtendedSmtpManager getSmtpManager(FactoryData data, String filterName, String contentType) {
        StringBuilder sb = new StringBuilder();
        if (data.to != null) {
            sb.append(data.to);
        }
        sb.append(':');
        if (data.cc != null) {
            sb.append(data.cc);
        }
        sb.append(':');
        if (data.bcc != null) {
            sb.append(data.bcc);
        }
        sb.append(':');
        if (data.from != null) {
            sb.append(data.from);
        }
        sb.append(':');
        if (data.replyto != null) {
            sb.append(data.replyto);
        }
        sb.append(':');
        if (data.subject != null) {
            sb.append(data.subject);
        }
        sb.append(':').append(data.burstSummarizingMillis);
        sb.append(':').append(data.bsCountInSubject);
        sb.append(':').append(data.bsMessagePrefixLength).append(data.bsMessageMaskDigits);
        sb.append(':').append(data.bsLoggername).append(data.bsExceptionClass).append(data.bsExceptionOrigin).append(data.bsRootExceptionClass);
        sb.append(':');
        sb.append(data.protocol).append(':').append(data.host).append(':').append(data.port);
        sb.append(':').append(data.username).append(':').append(data.password);
        sb.append(data.isDebug ? ":debug:" : "::");
        sb.append(filterName);
        String name = "SMTP:" + NameUtil.md5((String)sb.toString());
        ExtendedSmtpManager manager = (ExtendedSmtpManager)ExtendedSmtpManager.getManager((String)name, (ManagerFactory)FACTORY, (Object)data);
        if (contentType != null && contentType.length() > 0) {
            manager.lastContentType = contentType;
        }
        return manager;
    }

    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        this.summarySender.interrupt();
        try {
            this.summarySender.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkSendSummary(null);
        return true;
    }

    public void add(LogEvent event) {
        this.buffer.add((Object)event);
    }

    public void sendEvents(Layout<?> layout, LogEvent appendEvent) {
        this.checkSendSummary(layout);
        if (this.message == null) {
            this.connect();
        }
        try {
            SummarizeData sumData;
            LogEvent[] priorEvents = (LogEvent[])this.buffer.removeAll();
            byte[] rawBytes = this.formatContentToBytes(priorEvents, appendEvent, layout);
            String newSubject = null;
            if (this.subjectLayout != null) {
                newSubject = this.subjectLayout.toSerializable(appendEvent);
            }
            if ((sumData = this.summarizeEvent(appendEvent)) != null) {
                if (sumData.secondEventMsg == null) {
                    sumData.secondEventMsg = rawBytes;
                }
                sumData.lastEventMsg = rawBytes;
                sumData.lastSubject = newSubject;
            } else {
                String contentType = layout.getContentType();
                String encoding = this.getEncoding(rawBytes, contentType);
                byte[] encodedBytes = this.encodeContentToBytes(rawBytes, encoding);
                InternetHeaders headers = this.getHeaders(contentType, encoding);
                MimeMultipart mp = this.getMimeMultipart(encodedBytes, headers);
                this.sendMultipartMessage(this.message, newSubject, mp);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while sending e-mail notification.", (Throwable)e);
            throw new LoggingException("Error occurred while sending email", (Throwable)e);
        }
    }

    protected byte[] formatContentToBytes(LogEvent[] priorEvents, LogEvent appendEvent, Layout<?> layout) throws IOException {
        ByteArrayOutputStream raw = new ByteArrayOutputStream();
        this.writeContent(priorEvents, appendEvent, layout, raw);
        return raw.toByteArray();
    }

    private void writeContent(LogEvent[] priorEvents, LogEvent appendEvent, Layout<?> layout, ByteArrayOutputStream out) throws IOException {
        this.writeHeader(layout, out);
        this.writeBuffer(priorEvents, appendEvent, layout, out);
        this.writeFooter(layout, out);
    }

    protected void writeHeader(Layout<?> layout, OutputStream out) throws IOException {
        byte[] header = layout.getHeader();
        if (header != null) {
            out.write(header);
        }
    }

    protected void writeBuffer(LogEvent[] priorEvents, LogEvent appendEvent, Layout<?> layout, OutputStream out) throws IOException {
        for (LogEvent priorEvent : priorEvents) {
            byte[] bytes = layout.toByteArray(priorEvent);
            out.write(bytes);
        }
        byte[] bytes = layout.toByteArray(appendEvent);
        out.write(bytes);
    }

    protected void writeFooter(Layout<?> layout, OutputStream out) throws IOException {
        byte[] footer = layout.getFooter();
        if (footer != null) {
            out.write(footer);
        }
    }

    protected String getEncoding(byte[] rawBytes, String contentType) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(rawBytes, contentType);
        return MimeUtility.getEncoding((DataSource)dataSource);
    }

    protected byte[] encodeContentToBytes(byte[] rawBytes, String encoding) throws MessagingException, IOException {
        ByteArrayOutputStream encoded = new ByteArrayOutputStream();
        this.encodeContent(rawBytes, encoding, encoded);
        return encoded.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeContent(byte[] bytes, String encoding, ByteArrayOutputStream out) throws MessagingException, IOException {
        try (OutputStream encoder = MimeUtility.encode((OutputStream)out, (String)encoding);){
            encoder.write(bytes);
        }
    }

    protected InternetHeaders getHeaders(String contentType, String encoding) {
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", contentType + "; charset=UTF-8");
        headers.setHeader("Content-Transfer-Encoding", encoding);
        return headers;
    }

    protected MimeMultipart getMimeMultipart(byte[] encodedBytes, InternetHeaders headers) throws MessagingException {
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart(headers, encodedBytes);
        mp.addBodyPart((BodyPart)part);
        return mp;
    }

    protected void addMimeMultipart(MimeMultipart mp, byte[] rawBytes, String contentType) throws MessagingException, IOException {
        String encoding = this.getEncoding(rawBytes, contentType);
        byte[] encodedBytes = this.encodeContentToBytes(rawBytes, encoding);
        InternetHeaders headers = this.getHeaders(contentType, encoding);
        mp.addBodyPart((BodyPart)new MimeBodyPart(headers, encodedBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMultipartMessage(MimeMessage msg, String subject, MimeMultipart mp) throws MessagingException {
        MimeMessage mimeMessage = msg;
        synchronized (mimeMessage) {
            String prevSubjectHeader = null;
            if (subject != null) {
                prevSubjectHeader = msg.getHeader("Subject", null);
                subject = subject.replace('\n', ' ');
                msg.setSubject(subject);
            }
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            if (prevSubjectHeader != null && !this.data.subjectWithLayout) {
                msg.setHeader("Subject", prevSubjectHeader);
            }
        }
    }

    private synchronized void connect() {
        if (this.message != null) {
            return;
        }
        try {
            this.message = new MimeMessageBuilder(this.session).setFrom(this.data.from).setReplyTo(this.data.replyto).setRecipients(Message.RecipientType.TO, this.data.to).setRecipients(Message.RecipientType.CC, this.data.cc).setRecipients(Message.RecipientType.BCC, this.data.bcc).setSubject(this.data.subject).build();
        }
        catch (MessagingException e) {
            LOGGER.error("Could not set SmtpAppender message options.", (Throwable)e);
            this.message = null;
        }
    }

    private Thread startSummarySenderBackgroundThread() {
        if (this.data.burstSummarizingMillis <= 0L) {
            return null;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                long sleepTime = Math.max(ExtendedSmtpManager.this.data.burstSummarizingMillis / 10L, 500L);
                LOGGER.debug("SMTPx background thread {} started, sleep ms {}", (Object)this.getName(), (Object)sleepTime);
                try {
                    1.sleep(ExtendedSmtpManager.this.data.burstSummarizingMillis);
                    while (!1.interrupted()) {
                        1.sleep(sleepTime);
                        ExtendedSmtpManager.this.checkSendSummary(null);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOGGER.debug("SMTPx background thread {} ended.", (Object)this.getName());
            }
        };
        thread.setDaemon(true);
        thread.setName(((Object)((Object)this)).getClass().getSimpleName() + "-" + this.getName());
        thread.start();
        return thread;
    }

    private String getEventSummarizeKey(LogEvent event) {
        Throwable eventEx;
        StringBuilder sb = new StringBuilder(300);
        if (this.data.bsLoggername) {
            sb.append("~~LgNm:").append(event.getLoggerName());
        }
        if (this.data.bsMessagePrefixLength > 0) {
            String msgText = event.getMessage().getFormattedMessage();
            if (msgText != null) {
                if (this.data.bsMessageMaskDigits) {
                    msgText = digitPattern.matcher(msgText).replaceAll("#");
                }
                if (msgText.length() > this.data.bsMessagePrefixLength) {
                    msgText = msgText.substring(0, this.data.bsMessagePrefixLength);
                }
            }
            sb.append("~~Msg:").append(msgText);
        }
        if ((eventEx = event.getThrown()) != null) {
            StackTraceElement[] stackTrace;
            if (this.data.bsExceptionClass) {
                sb.append("~~ExCl:").append(eventEx.getClass().getName());
            }
            if (this.data.bsExceptionOrigin && (stackTrace = eventEx.getStackTrace()) != null && stackTrace.length > 0 && stackTrace[0] != null) {
                sb.append("~~ExO:").append(stackTrace[0].toString());
            }
            if (this.data.bsRootExceptionClass) {
                Throwable cause;
                Throwable rootEx = eventEx;
                while ((cause = rootEx.getCause()) != null && cause != rootEx) {
                    rootEx = cause;
                }
                sb.append("~~RExCl:").append(rootEx.getClass().getName());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SummarizeData summarizeEvent(LogEvent logEvent) {
        if (this.data.burstSummarizingMillis <= 0L) {
            return null;
        }
        String eventKey = this.getEventSummarizeKey(logEvent);
        Map<String, SummarizeData> map = this.summarizeDataCollector;
        synchronized (map) {
            SummarizeData sumData = this.summarizeDataCollector.get(eventKey);
            if (sumData == null) {
                sumData = new SummarizeData(eventKey, logEvent.getTimeMillis());
                this.summarizeDataCollector.put(eventKey, sumData);
                return null;
            }
            sumData.lastEventMillis = logEvent.getTimeMillis();
            ++sumData.numOfMsg;
            if (sumData.numOfMsg == 1) {
                sumData.secondEventMillis = sumData.lastEventMillis;
            }
            return sumData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSendSummary(Layout<?> layout) {
        if (this.data.burstSummarizingMillis <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSummaryCheckMillis < this.data.burstSummarizingMillis / 10L) {
            return;
        }
        this.lastSummaryCheckMillis = now;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("SMTPx.checkSendSummary() exec - {}={}", (Object)now, (Object)DateFormat.getTimeInstance(2).format(now));
        }
        if (layout != null) {
            this.lastContentType = layout.getContentType();
        }
        ArrayList<SummarizeData> toSend = new ArrayList<SummarizeData>();
        LOGGER.trace("  - collector before: {}", this.summarizeDataCollector);
        Map<String, SummarizeData> map = this.summarizeDataCollector;
        synchronized (map) {
            Iterator<Map.Entry<String, SummarizeData>> iter = this.summarizeDataCollector.entrySet().iterator();
            while (iter.hasNext()) {
                SummarizeData sumData = iter.next().getValue();
                if (sumData.numOfMsg == 0 && now - sumData.firstEventMillis > this.data.burstSummarizingMillis) {
                    iter.remove();
                    continue;
                }
                if (sumData.numOfMsg <= 0 || now - sumData.secondEventMillis <= this.data.burstSummarizingMillis) continue;
                toSend.add(sumData);
                iter.remove();
            }
            for (SummarizeData sumData : toSend) {
                this.summarizeDataCollector.put(sumData.sumKey, new SummarizeData(sumData.sumKey, sumData.lastEventMillis));
            }
        }
        LOGGER.trace("  - collector afterwards: {}, toSend=#{}", this.summarizeDataCollector, (Object)toSend.size());
        for (SummarizeData sumData : toSend) {
            this.sendSummary(sumData);
        }
    }

    public void sendSummary(SummarizeData sumData) {
        LOGGER.debug("SMTPx.sendSummary() - {}", (Object)sumData);
        if (this.message == null) {
            this.connect();
        }
        try {
            String eventContentType = this.lastContentType;
            MimeMultipart mp = new MimeMultipart();
            if (sumData.numOfMsg >= 2) {
                DateFormat dfTime = DateFormat.getTimeInstance(2);
                String str = "*** Summarized " + sumData.numOfMsg + " similar log events ***\nDuring " + (sumData.lastEventMillis - sumData.secondEventMillis + 500L) / 1000L + " seconds:  first at " + dfTime.format(sumData.secondEventMillis) + ",  last at " + dfTime.format(sumData.lastEventMillis) + ".\nFirst and last event message follow.\n(summary based on:  \"" + sumData.sumKey + "\")\n";
                this.addMimeMultipart(mp, str.getBytes("UTF-8"), "text/plain");
                this.addMimeMultipart(mp, sumData.secondEventMsg, eventContentType);
            } else {
                this.addMimeMultipart(mp, "*** Single collected summarized log event".getBytes("UTF-8"), "text/plain");
            }
            this.addMimeMultipart(mp, sumData.lastEventMsg, eventContentType);
            String newSubject = sumData.lastSubject;
            if (this.data.bsCountInSubject != '\u0000' && sumData.numOfMsg > 1) {
                if (newSubject == null) {
                    newSubject = this.data.subject;
                }
                newSubject = this.data.bsCountInSubject == 'F' || this.data.bsCountInSubject == 'S' ? sumData.numOfMsg + "x  " + newSubject : newSubject + "  [" + sumData.numOfMsg + "x]";
            }
            this.sendMultipartMessage(this.message, newSubject, mp);
        }
        catch (Throwable e) {
            LOGGER.error("Error occurred while sending summary e-mail notification.", e);
            throw new LoggingException("Error occurred while sending summary email", e);
        }
    }

    private static class SMTPManagerFactory
    implements ManagerFactory<ExtendedSmtpManager, FactoryData> {
        private SMTPManagerFactory() {
        }

        public ExtendedSmtpManager createManager(String name, FactoryData data) {
            MimeMessage message;
            Authenticator authenticator;
            String prefix = "mail." + data.protocol;
            Properties properties = PropertiesUtil.getSystemProperties();
            properties.put("mail.transport.protocol", data.protocol);
            if (properties.getProperty("mail.host") == null) {
                properties.put("mail.host", NetUtils.getLocalHostname());
            }
            if (data.host != null) {
                properties.put(prefix + ".host", data.host);
            }
            if (data.port > 0) {
                properties.put(prefix + ".port", String.valueOf(data.port));
            }
            if ((authenticator = this.buildAuthenticator(data.username, data.password)) != null) {
                properties.put(prefix + ".auth", "true");
            }
            Session session = Session.getInstance((Properties)properties, (Authenticator)authenticator);
            session.setProtocolForAddress("rfc822", data.protocol);
            session.setDebug(data.isDebug);
            try {
                message = new MimeMessageBuilder(session).setFrom(data.from).setReplyTo(data.replyto).setRecipients(Message.RecipientType.TO, data.to).setRecipients(Message.RecipientType.CC, data.cc).setRecipients(Message.RecipientType.BCC, data.bcc).setSubject(data.subject).build();
            }
            catch (MessagingException e) {
                LOGGER.error("Could not set SmtpAppender message options.", (Throwable)e);
                message = null;
            }
            return new ExtendedSmtpManager(name, session, message, data);
        }

        private Authenticator buildAuthenticator(final String username, final String password) {
            if (null != password && null != username) {
                return new Authenticator(){
                    private final PasswordAuthentication passwordAuthentication;
                    {
                        this.passwordAuthentication = new PasswordAuthentication(username, password);
                    }

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return this.passwordAuthentication;
                    }
                };
            }
            return null;
        }
    }

    public static class FactoryData {
        private final String to;
        private final String cc;
        private final String bcc;
        private final String from;
        private final String replyto;
        private final String subject;
        private final boolean subjectWithLayout;
        private final String protocol;
        private final String host;
        private final int port;
        private final String username;
        private final String password;
        private final boolean isDebug;
        private final int numElements;
        private final long burstSummarizingMillis;
        private final char bsCountInSubject;
        private final boolean bsLoggername;
        private final int bsMessagePrefixLength;
        private final boolean bsMessageMaskDigits;
        private final boolean bsExceptionClass;
        private final boolean bsExceptionOrigin;
        private final boolean bsRootExceptionClass;

        public FactoryData(String to, String cc, String bcc, String from, String replyto, String subject, boolean subjectWithLayout, String protocol, String host, int port, String username, String password, boolean isDebug, int numElements, long burstSummarizingMillis, char bsCountInSubject, boolean bsLoggername, int bsMessagePrefixLength, boolean bsMessageMaskDigits, boolean bsExceptionClass, boolean bsExceptionOrigin, boolean bsRootExceptionClass) {
            this.to = to;
            this.cc = cc;
            this.bcc = bcc;
            this.from = from;
            this.replyto = replyto;
            this.subject = subject;
            this.subjectWithLayout = subjectWithLayout;
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
            this.isDebug = isDebug;
            this.numElements = numElements;
            this.burstSummarizingMillis = burstSummarizingMillis;
            this.bsCountInSubject = Character.toUpperCase(bsCountInSubject);
            this.bsLoggername = bsLoggername;
            this.bsMessagePrefixLength = bsMessagePrefixLength;
            this.bsMessageMaskDigits = bsMessageMaskDigits;
            this.bsExceptionClass = bsExceptionClass;
            this.bsExceptionOrigin = bsExceptionOrigin;
            this.bsRootExceptionClass = bsRootExceptionClass;
        }
    }

    private static class SummarizeData {
        final String sumKey;
        final long firstEventMillis;
        int numOfMsg;
        long secondEventMillis;
        byte[] secondEventMsg;
        long lastEventMillis;
        byte[] lastEventMsg;
        String lastSubject;

        SummarizeData(String sumKey, long firstEventMillis) {
            this.sumKey = sumKey;
            this.firstEventMillis = firstEventMillis;
        }

        public String toString() {
            DateFormat dfTime = DateFormat.getTimeInstance(2);
            return "SumData[#" + this.numOfMsg + " / " + this.firstEventMillis + "=" + dfTime.format(this.firstEventMillis) + " / " + this.secondEventMillis + "=" + dfTime.format(this.secondEventMillis) + " / " + this.lastEventMillis + "=" + dfTime.format(this.lastEventMillis) + " / " + this.lastSubject + "]";
        }
    }
}

