/*
 * Decompiled with CFR 0.152.
 */
package de.ixilon.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DockerClientBuilder.class})
public class DockerClientAutoConfiguration {
    @Bean
    public DockerClient dockerClient(DockerClientConfig config) {
        return DockerClientBuilder.getInstance((DockerClientConfig)config).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public DockerClientConfig dockerClientConfig() {
        return DefaultDockerClientConfig.createDefaultConfigBuilder().build();
    }
}

