/*
 * Decompiled with CFR 0.152.
 */
package com.javacook.coordinate;

import com.javacook.coordinate.CoordinateInterface;

public class Coordinate
implements CoordinateInterface {
    final int x;
    final int y;

    public Coordinate(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Coordinate(CoordinateInterface coord) {
        this.x = coord.x();
        this.y = coord.y();
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    public Coordinate decX() {
        return this.addX(-1);
    }

    public Coordinate decY() {
        return this.addY(-1);
    }

    public Coordinate incX() {
        return this.addX(1);
    }

    public Coordinate incY() {
        return this.addY(1);
    }

    public Coordinate addX(int offset) {
        return new Coordinate(this.x + offset, this.y);
    }

    public Coordinate addY(int offset) {
        return new Coordinate(this.x, this.y + offset);
    }

    public Coordinate add(Coordinate coord) {
        return new Coordinate(this.x + coord.x, this.y + coord.y);
    }

    public Coordinate setX(int xNew) {
        return new Coordinate(xNew, this.y);
    }

    public Coordinate setY(int yNew) {
        return new Coordinate(this.x, yNew);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof CoordinateInterface)) {
            return false;
        }
        CoordinateInterface that = (CoordinateInterface)o;
        return this.x == that.x() && this.y == that.y();
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        return result;
    }
}

