/*
 * Decompiled with CFR 0.152.
 */
package com.javacook.coordinate.sequencer;

import com.javacook.coordinate.CoordinateFactory;
import com.javacook.coordinate.CoordinateInterface;
import java.util.Iterator;

public class CoordinateSequence<T extends CoordinateInterface>
implements Iterable<T> {
    protected int fromX;
    protected int fromY;
    protected int toX;
    protected int toY;
    protected int stepX = 1;
    protected int stepY = 1;
    protected CoordinateFactory<T> coordinateFactory;

    public CoordinateSequence(int fromX, int fromY, int toX, int toY, int stepX, int stepY, CoordinateFactory<T> coordinateFactory) {
        this.fromX = fromX;
        this.fromY = fromY;
        this.toX = toX;
        this.toY = toY;
        this.stepX = stepX;
        this.stepY = stepY;
        this.coordinateFactory = coordinateFactory;
    }

    CoordinateSequence(int fromX, int fromY, int toX, int toY, CoordinateFactory<T> coordinateFactory) {
        this(fromX, fromY, toX, toY, 1, 1, coordinateFactory);
    }

    @Override
    public Iterator<T> iterator() {
        return new CoordinateIterator();
    }

    public String toString() {
        return "CoordinateSequence{fromX=" + this.fromX + ", fromY=" + this.fromY + ", toX=" + this.toX + ", toY=" + this.toY + '}';
    }

    public class CoordinateIterator
    implements Iterator<T> {
        int x;
        int y;

        public CoordinateIterator() {
            this.x = CoordinateSequence.this.fromX;
            this.y = CoordinateSequence.this.fromY;
        }

        @Override
        public boolean hasNext() {
            return CoordinateSequence.this.stepY > 0 ? this.y < CoordinateSequence.this.toY : this.y > CoordinateSequence.this.toY;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                CoordinateInterface result = (CoordinateInterface)CoordinateSequence.this.coordinateFactory.create(this.x, this.y);
                this.x += CoordinateSequence.this.stepX;
                if (CoordinateSequence.this.stepX > 0 ? this.x >= CoordinateSequence.this.toX : this.x <= CoordinateSequence.this.toX) {
                    this.x = CoordinateSequence.this.fromX;
                    this.y += CoordinateSequence.this.stepY;
                }
                return result;
            }
            return null;
        }
    }
}

