/*
 * Decompiled with CFR 0.152.
 */
package com.javacook.coordinate.sequencer;

import com.javacook.coordinate.CoordinateFactory;
import com.javacook.coordinate.CoordinateInterface;
import com.javacook.coordinate.sequencer.ArrayConsumer;
import com.javacook.coordinate.sequencer.ArrayConsumerAndCounter;
import com.javacook.coordinate.sequencer.ArrayPredicate;
import com.javacook.coordinate.sequencer.ArrayPredicateAndCounter;
import com.javacook.coordinate.sequencer.Consumer;
import com.javacook.coordinate.sequencer.ConsumerAndCounter;
import com.javacook.coordinate.sequencer.CoordinateSequence;
import com.javacook.coordinate.sequencer.PairConsumer;
import com.javacook.coordinate.sequencer.PairConsumerAndCounter;
import com.javacook.coordinate.sequencer.PairPredicate;
import com.javacook.coordinate.sequencer.PairPredicateAndCounter;
import com.javacook.coordinate.sequencer.Predicate;
import com.javacook.coordinate.sequencer.PredicateAndCounter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CoordinateSequencer<T extends CoordinateInterface> {
    private List<CoordinateSequence<T>> coordinateSequences = new ArrayList<CoordinateSequence<T>>();
    private CoordinateFactory<T> coordinateFactory;
    private Integer xFrom;
    private Integer yFrom;
    private Integer xTo;
    private Integer yTo;
    private Integer xLen;
    private Integer yLen;
    private int xStep;
    private int yStep;
    private boolean virgin;
    protected Predicate<T> predicate;
    protected PredicateAndCounter<T> predicateAndCounter;
    protected PairPredicate<T> pairPredicate;
    protected PairPredicateAndCounter<T> pairPredicateAndCounter;
    protected ArrayPredicate<T> arrayPredicate;
    protected ArrayPredicateAndCounter<T> arrayPredicateAndCounter;

    public CoordinateSequencer(CoordinateFactory<T> coordinateFactory) {
        this.coordinateFactory = coordinateFactory;
        this.initCache();
    }

    protected void initCache() {
        this.yFrom = null;
        this.xFrom = null;
        this.yTo = null;
        this.xTo = null;
        this.yStep = 1;
        this.xStep = 1;
        this.virgin = true;
    }

    public CoordinateSequencer<T> fromX(int x) {
        this.xFrom = x;
        this.virgin = false;
        return this;
    }

    public CoordinateSequencer<T> fromY(int y) {
        this.yFrom = y;
        this.virgin = false;
        return this;
    }

    public CoordinateSequencer<T> from(int x, int y) {
        return this.fromX(x).fromY(y);
    }

    public CoordinateSequencer<T> from(CoordinateInterface c) {
        Objects.requireNonNull(c, "Argument 'c' is null.");
        return this.from(c.x(), c.y());
    }

    public CoordinateSequencer<T> toX(int xTo) {
        this.xTo = xTo;
        this.virgin = false;
        return this;
    }

    public CoordinateSequencer<T> toY(int yTo) {
        this.yTo = yTo;
        this.virgin = false;
        return this;
    }

    public CoordinateSequencer<T> ontoX(int x) {
        return this.toX(x + 1);
    }

    public CoordinateSequencer<T> ontoY(int y) {
        return this.toY(y + 1);
    }

    public CoordinateSequencer<T> to(int x, int y) {
        return this.toX(x).toY(y);
    }

    public CoordinateSequencer<T> to(CoordinateInterface c) {
        return this.to(c.x(), c.y());
    }

    public CoordinateSequencer<T> forX(int x) {
        return this.fromX(x).toX(x + 1);
    }

    public CoordinateSequencer<T> forY(int y) {
        return this.fromY(y).toY(y + 1);
    }

    public CoordinateSequencer<T> lenX(int len) {
        this.xLen = len;
        this.virgin = false;
        return this;
    }

    public CoordinateSequencer<T> lenY(int len) {
        this.yLen = len;
        this.virgin = false;
        return this;
    }

    public CoordinateSequencer<T> stepX(int step) {
        this.xStep = step;
        this.virgin = false;
        return this;
    }

    public CoordinateSequencer<T> stepY(int step) {
        this.yStep = step;
        this.virgin = false;
        return this;
    }

    public CoordinateSequencer<T> enter() {
        this.coordinateSequences.add(this.sequence());
        this.initCache();
        return this;
    }

    public CoordinateSequence<T> sequence() {
        try {
            if (this.xFrom == null) {
                this.xFrom = this.xTo - this.xLen;
            } else if (this.xTo == null) {
                this.xTo = this.xFrom + this.xLen;
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("x-coordinates are not well defined.from=(" + this.xFrom + "," + this.yFrom + "), to=(" + this.xTo + "," + this.yTo + "), len=(" + this.xLen + "," + this.yLen + ")");
        }
        try {
            if (this.yFrom == null) {
                this.yFrom = this.yTo - this.yLen;
            } else if (this.yTo == null) {
                this.yTo = this.yFrom + this.yLen;
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("y-coordinates are not well defined.from=(" + this.xFrom + "," + this.yFrom + "), to=(" + this.xTo + "," + this.yTo + "), len=(" + this.xLen + "," + this.yLen + ")");
        }
        return new CoordinateSequence<T>(this.xFrom, this.yFrom, this.xTo, this.yTo, this.xStep, this.yStep, this.coordinateFactory);
    }

    public CoordinateSequencer<T> stopWhen(Predicate<T> condition) {
        if (!this.virgin) {
            this.enter();
        }
        if (this.coordinateSequences.size() != 1) {
            throw new IllegalArgumentException("This method allows exactly one coordinate sequence. The enviroment requires " + this.coordinateSequences.size());
        }
        this.predicate = condition;
        return this;
    }

    public CoordinateSequencer<T> stopWhen(PredicateAndCounter<T> condition) {
        if (!this.virgin) {
            this.enter();
        }
        if (this.coordinateSequences.size() != 1) {
            throw new IllegalArgumentException("This method allows exactly one coordinate sequence.The enviroment requires " + this.coordinateSequences.size());
        }
        this.predicateAndCounter = condition;
        return this;
    }

    public CoordinateSequencer<T> stopWhenPair(PairPredicate<T> condition) {
        if (!this.virgin) {
            this.enter();
        }
        if (this.coordinateSequences.size() != 2) {
            throw new IllegalArgumentException("This method allows exactly two coordinate sequences.The enviroment requires " + this.coordinateSequences.size());
        }
        this.pairPredicate = condition;
        return this;
    }

    public CoordinateSequencer<T> stopWhenPair(PairPredicateAndCounter<T> condition) {
        if (!this.virgin) {
            this.enter();
        }
        if (this.coordinateSequences.size() != 2) {
            throw new IllegalArgumentException("This method allows exactly two coordinate sequences.The enviroment requires " + this.coordinateSequences.size());
        }
        this.pairPredicateAndCounter = condition;
        return this;
    }

    public CoordinateSequencer<T> stopWhenArray(ArrayPredicate<T> condition) {
        if (!this.virgin) {
            this.enter();
        }
        this.arrayPredicate = condition;
        return this;
    }

    public CoordinateSequencer<T> stopWhenArray(ArrayPredicateAndCounter<T> condition) {
        if (!this.virgin) {
            this.enter();
        }
        this.arrayPredicateAndCounter = condition;
        return this;
    }

    protected boolean terminate(T coord1, int counter) {
        return this.predicate != null && this.predicate.test(coord1) || this.predicateAndCounter != null && this.predicateAndCounter.test(coord1, counter);
    }

    protected boolean terminate(T coord1, T coord2, int counter) {
        return this.pairPredicate != null && this.pairPredicate.test(coord1, coord2) || this.pairPredicateAndCounter != null && this.pairPredicateAndCounter.test(coord1, coord2, counter);
    }

    protected boolean terminate(T[] coords, int counter) {
        return this.arrayPredicate != null && this.arrayPredicate.test(coords) || this.arrayPredicateAndCounter != null && this.arrayPredicateAndCounter.test(coords, counter);
    }

    public void forEach(Consumer<? super T> action) {
        CoordinateInterface coord;
        if (!this.virgin) {
            this.enter();
        }
        if (this.coordinateSequences.size() != 1) {
            throw new IllegalArgumentException("This method allows exactly one coordinate sequence.The enviroment requires " + this.coordinateSequences.size());
        }
        int counter = 0;
        Iterator<T> iterator = this.coordinateSequences.get(0).iterator();
        while (iterator.hasNext() && !this.terminate(coord = (CoordinateInterface)iterator.next(), counter++)) {
            action.apply(coord);
        }
    }

    public void forEach(ConsumerAndCounter<? super T> action) {
        CoordinateInterface coord;
        if (!this.virgin) {
            this.enter();
        }
        if (this.coordinateSequences.size() != 1) {
            throw new IllegalArgumentException("This method allows exactly one coordinate sequence.The enviroment requires " + this.coordinateSequences.size());
        }
        int counter = 0;
        Iterator<T> iterator = this.coordinateSequences.get(0).iterator();
        while (iterator.hasNext() && !this.terminate(coord = (CoordinateInterface)iterator.next(), counter)) {
            action.apply(coord, counter++);
        }
    }

    public void forEachPair(PairConsumer<T> action) {
        if (!this.virgin) {
            this.enter();
        }
        if (this.coordinateSequences.size() != 2) {
            throw new IllegalArgumentException("This method allows exactly two CoordinateSequences.The enviroment requires " + this.coordinateSequences.size());
        }
        Iterator<T> iter = this.coordinateSequences.get(1).iterator();
        int counter = 0;
        for (CoordinateInterface coord1 : this.coordinateSequences.get(0)) {
            if (!iter.hasNext()) break;
            CoordinateInterface coord2 = (CoordinateInterface)iter.next();
            if (this.terminate(coord1, coord2, counter++)) break;
            action.apply(coord1, coord2);
        }
    }

    public void forEachPair(PairConsumerAndCounter<T> action) {
        if (!this.virgin) {
            this.enter();
        }
        if (this.coordinateSequences.size() != 2) {
            throw new IllegalArgumentException("This method allows exactly two CoordinateSequences.The enviroment requires " + this.coordinateSequences.size());
        }
        Iterator<T> iter = this.coordinateSequences.get(1).iterator();
        int counter = 0;
        for (CoordinateInterface coord1 : this.coordinateSequences.get(0)) {
            CoordinateInterface coord2;
            if (!iter.hasNext() || this.terminate(coord1, coord2 = (CoordinateInterface)iter.next(), counter)) break;
            action.apply(coord1, coord2, counter++);
        }
    }

    public void forEachArray(ArrayConsumer<T> action) {
        if (!this.virgin) {
            this.enter();
        }
        ArrayList<Iterator<T>> coordinateSequencesIterators = new ArrayList<Iterator<T>>();
        for (CoordinateSequence<T> coordinateSequence : this.coordinateSequences) {
            coordinateSequencesIterators.add(coordinateSequence.iterator());
        }
        CoordinateInterface[] coordinates = null;
        int loopCnt = 0;
        block1: while (true) {
            int coordArrIndex = 0;
            for (Iterator iterator : coordinateSequencesIterators) {
                if (!iterator.hasNext()) break block1;
                CoordinateInterface next = (CoordinateInterface)iterator.next();
                if (coordinates == null) {
                    coordinates = (CoordinateInterface[])Array.newInstance(next.getClass(), this.coordinateSequences.size());
                }
                coordinates[coordArrIndex++] = next;
            }
            if (this.terminate((T)coordinates, loopCnt)) break;
            action.apply(coordinates);
            ++loopCnt;
        }
    }

    public void forEachArray(ArrayConsumerAndCounter<T> action) {
        if (!this.virgin) {
            this.enter();
        }
        ArrayList<Iterator<T>> coordinateSequencesIterators = new ArrayList<Iterator<T>>();
        for (CoordinateSequence<T> coordinateSequence : this.coordinateSequences) {
            coordinateSequencesIterators.add(coordinateSequence.iterator());
        }
        CoordinateInterface[] coordinates = null;
        int loopCnt = 0;
        block1: while (true) {
            int coordArrIndex = 0;
            for (Iterator iterator : coordinateSequencesIterators) {
                if (!iterator.hasNext()) break block1;
                CoordinateInterface next = (CoordinateInterface)iterator.next();
                if (coordinates == null) {
                    coordinates = (CoordinateInterface[])Array.newInstance(next.getClass(), this.coordinateSequences.size());
                }
                coordinates[coordArrIndex++] = next;
            }
            if (this.terminate((T)coordinates, loopCnt)) break;
            action.apply(coordinates, loopCnt);
            ++loopCnt;
        }
    }
}

