/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui;

import java.awt.event.ActionEvent;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class Actions {
    public static ActionBuilder create(String name) {
        Objects.requireNonNull(name, "The name may not be null");
        return new ActionBuilder(name);
    }

    private Actions() {
    }

    public static class ActionBuilder {
        private ActionBuilderAction action;

        ActionBuilder(String name) {
            this.action = new ActionBuilderAction(name);
        }

        public ActionBuilder setName(String name) {
            this.action.putValue("Name", name);
            return this;
        }

        public ActionBuilder setShortDescription(String shortDescription) {
            this.action.putValue("ShortDescription", shortDescription);
            return this;
        }

        public ActionBuilder setMnemonicKey(int key) {
            this.action.putValue("MnemonicKey", key);
            return this;
        }

        public ActionBuilder setActionMethod(Consumer<? super ActionEvent> actionMethod) {
            this.action.setActionMethod(actionMethod);
            return this;
        }

        public ActionBuilder setActionCall(Runnable call) {
            this.action.setActionMethod(e -> call.run());
            return this;
        }

        public Action build() {
            return this.action;
        }
    }

    private static class ActionBuilderAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private Consumer<? super ActionEvent> actionMethod;

        ActionBuilderAction(String name) {
            super(name);
        }

        void setActionMethod(Consumer<? super ActionEvent> actionMethod) {
            this.actionMethod = actionMethod;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.actionMethod != null) {
                this.actionMethod.accept(e);
            }
        }
    }
}

