/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui;

import java.awt.Window;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class JOptionPanes {
    public static int showValidatedTextInputDialog(Window parent, String title, JComponent mainComponent, final JTextComponent textComponent, final Predicate<String> validInputPredicate) {
        final JButton okButton = new JButton("Ok");
        String text = textComponent.getText();
        boolean valid = validInputPredicate.test(text);
        okButton.setEnabled(valid);
        JButton cancelButton = new JButton("Cancel");
        Object[] options = new Object[]{okButton, cancelButton};
        JOptionPane optionPane = new JOptionPane(mainComponent, -1, 2, null, options, okButton);
        okButton.addActionListener(e -> optionPane.setValue(okButton));
        cancelButton.addActionListener(e -> optionPane.setValue(cancelButton));
        AncestorListener focussingAncestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                textComponent.requestFocus();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        };
        textComponent.addAncestorListener(focussingAncestorListener);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            protected void updateButtonState() {
                String text = textComponent.getText();
                boolean valid = validInputPredicate.test(text);
                okButton.setEnabled(valid);
            }
        };
        Document document = textComponent.getDocument();
        document.addDocumentListener(documentListener);
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.pack();
        dialog.setResizable(true);
        dialog.setVisible(true);
        document.removeDocumentListener(documentListener);
        textComponent.removeAncestorListener(focussingAncestorListener);
        Object selectedValue = optionPane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        return Arrays.asList(options).indexOf(selectedValue);
    }

    private JOptionPanes() {
    }
}

