/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui;

import de.javagl.common.ui.SpinnerDraggingHandler;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class JSpinners {
    public static JSpinner createSpinner(SpinnerModel model, final int fractionDigits) {
        return new JSpinner(model){
            private static final long serialVersionUID = -9185142711286020504L;

            @Override
            protected JComponent createEditor(SpinnerModel model) {
                if (model instanceof SpinnerNumberModel) {
                    JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this);
                    DecimalFormat format = editor.getFormat();
                    format.setMaximumFractionDigits(fractionDigits);
                    return editor;
                }
                return super.createEditor(model);
            }
        };
    }

    public static void setSpinnerDraggingEnabled(JSpinner spinner, boolean enabled) {
        SpinnerModel spinnerModel = spinner.getModel();
        if (!(spinnerModel instanceof SpinnerNumberModel)) {
            throw new IllegalArgumentException("Dragging is only possible for spinners with a SpinnerNumberModel, found " + spinnerModel.getClass());
        }
        if (enabled) {
            JSpinners.disableSpinnerDragging(spinner);
            JSpinners.enableSpinnerDragging(spinner);
        } else {
            JSpinners.disableSpinnerDragging(spinner);
        }
    }

    private static void disableSpinnerDragging(JSpinner spinner) {
        int n = spinner.getComponentCount();
        for (int i = 0; i < n; ++i) {
            MouseListener[] mouseListeners;
            MouseMotionListener[] mouseMotionListeners;
            Component c = spinner.getComponent(i);
            String name = c.getName();
            if (!"Spinner.nextButton".equals(name) && !"Spinner.previousButton".equals(name)) continue;
            for (MouseMotionListener m : mouseMotionListeners = c.getMouseMotionListeners()) {
                if (!(m instanceof SpinnerDraggingHandler)) continue;
                c.removeMouseMotionListener(m);
            }
            for (MouseListener m : mouseListeners = c.getMouseListeners()) {
                if (!(m instanceof SpinnerDraggingHandler)) continue;
                c.removeMouseListener(m);
            }
        }
    }

    private static void enableSpinnerDragging(JSpinner spinner) {
        SpinnerDraggingHandler spinnerDraggingHandler = new SpinnerDraggingHandler(spinner);
        int n = spinner.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = spinner.getComponent(i);
            String name = c.getName();
            if (!"Spinner.nextButton".equals(name) && !"Spinner.previousButton".equals(name)) continue;
            c.addMouseListener(spinnerDraggingHandler);
            c.addMouseMotionListener(spinnerDraggingHandler);
        }
    }

    private JSpinners() {
    }
}

