/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class JTables {
    public static void adjustColumnWidths(JTable table, int maxWidth) {
        int safety = 20;
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableColumn column = table.getColumnModel().getColumn(c);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = table.getTableHeader().getDefaultRenderer();
            }
            Component headerComponent = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
            int width = headerComponent.getPreferredSize().width;
            for (int r = 0; r < table.getRowCount(); ++r) {
                TableCellRenderer cellRenderer = table.getCellRenderer(r, c);
                Component cellComponent = cellRenderer.getTableCellRendererComponent(table, table.getValueAt(r, c), false, false, r, c);
                Dimension d = cellComponent.getPreferredSize();
                width = Math.max(width, d.width);
            }
            column.setPreferredWidth(Math.min(maxWidth, width + 20));
        }
    }

    public static void scrollToRow(JTable table, int row) {
        Rectangle visibleRect = table.getVisibleRect();
        Rectangle cellRect = table.getCellRect(row, 0, true);
        Rectangle r = new Rectangle(visibleRect.x, cellRect.y, visibleRect.width, cellRect.height);
        table.scrollRectToVisible(r);
    }

    public static Set<Integer> convertRowIndicesToView(JTable table, Iterable<? extends Integer> modelRows) {
        LinkedHashSet<Integer> viewRows = new LinkedHashSet<Integer>();
        for (Integer n : modelRows) {
            int viewRow = table.convertRowIndexToView(n);
            viewRows.add(viewRow);
        }
        return viewRows;
    }

    public static Set<Integer> convertRowIndicesToModel(JTable table, Iterable<? extends Integer> viewRows) {
        LinkedHashSet<Integer> modelRows = new LinkedHashSet<Integer>();
        for (Integer n : viewRows) {
            int modelRow = table.convertRowIndexToModel(n);
            modelRows.add(modelRow);
        }
        return modelRows;
    }

    public static List<Integer> computeRowsWithEqualValue(JTable table, int row, int col) {
        Object referenceValue = table.getValueAt(row, col);
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        for (int r = 0; r < table.getRowCount(); ++r) {
            Object value = table.getValueAt(r, col);
            if (!Objects.equals(value, referenceValue)) continue;
            selectedRows.add(r);
        }
        return selectedRows;
    }

    public static void setSmallFont(JTable t) {
        JTables.setFont(t, 9.0);
    }

    public static void setFont(JTable t, double size) {
        JTables.setDerivedFont(t, (float)size);
    }

    private static void setDerivedFont(JTable t, float size) {
        t.setFont(t.getFont().deriveFont(size));
        t.getTableHeader().setFont(t.getTableHeader().getFont().deriveFont(size));
    }

    private JTables() {
    }
}

