/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui;

import de.javagl.common.ui.tree.renderer.GenericTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTrees {
    public static void expandAll(JTree tree) {
        for (int r = 0; r < tree.getRowCount(); ++r) {
            tree.expandRow(r);
        }
    }

    public static void expandAllFixedHeight(JTree tree) {
        TreeCellRenderer cellRenderer = tree.getCellRenderer();
        Component treeCellRendererComponent = cellRenderer.getTreeCellRendererComponent(tree, tree.getModel().getRoot(), false, false, false, 1, false);
        int rowHeight = treeCellRendererComponent.getPreferredSize().height + 2;
        tree.setRowHeight(rowHeight);
        List<TreeExpansionListener> expansionListeners = Arrays.asList(tree.getTreeExpansionListeners());
        for (TreeExpansionListener expansionListener : expansionListeners) {
            tree.removeTreeExpansionListener(expansionListener);
        }
        TreePath rootPath = new TreePath(tree.getModel().getRoot());
        JTrees.expandAllRecursively(tree, rootPath);
        for (TreeExpansionListener expansionListener : expansionListeners) {
            tree.addTreeExpansionListener(expansionListener);
        }
        tree.collapsePath(rootPath);
        tree.expandPath(rootPath);
    }

    private static void expandAllRecursively(JTree tree, TreePath treePath) {
        Object lastPathComponent;
        TreeModel model = tree.getModel();
        int childCount = model.getChildCount(lastPathComponent = treePath.getLastPathComponent());
        if (childCount == 0) {
            return;
        }
        tree.expandPath(treePath);
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChild(lastPathComponent, i);
            int grandChildCount = model.getChildCount(child);
            if (grandChildCount <= 0) continue;
            class LocalTreePath
            extends TreePath {
                private static final long serialVersionUID = 0L;

                public LocalTreePath(TreePath parent, Object lastPathComponent) {
                    super(parent, lastPathComponent);
                }
            }
            LocalTreePath nextTreePath = new LocalTreePath(treePath, child);
            JTrees.expandAllRecursively(tree, nextTreePath);
        }
    }

    public static void collapseAll(JTree tree, boolean omitRoot) {
        int rows = tree.getRowCount();
        int limit = omitRoot ? 1 : 0;
        for (int i = rows - 1; i >= limit; --i) {
            tree.collapseRow(i);
        }
    }

    public static int countNodes(TreeModel treeModel) {
        return JTrees.countNodes(treeModel, treeModel.getRoot());
    }

    private static int countNodes(TreeModel treeModel, Object node) {
        int sum = 1;
        int n = treeModel.getChildCount(node);
        for (int i = 0; i < n; ++i) {
            sum += JTrees.countNodes(treeModel, treeModel.getChild(node, i));
        }
        return sum;
    }

    public static DefaultMutableTreeNode findNode(TreeModel treeModel, Object userObject) {
        return JTrees.findNode(treeModel, treeModel.getRoot(), userObject);
    }

    private static DefaultMutableTreeNode findNode(TreeModel treeModel, Object node, Object userObject) {
        DefaultMutableTreeNode treeNode;
        Object object;
        if (node instanceof DefaultMutableTreeNode && ((object = (treeNode = (DefaultMutableTreeNode)node).getUserObject()) == null && userObject == null || object != null && object.equals(userObject))) {
            return treeNode;
        }
        int n = treeModel.getChildCount(node);
        for (int i = 0; i < n; ++i) {
            Object child = treeModel.getChild(node, i);
            DefaultMutableTreeNode result = JTrees.findNode(treeModel, child, userObject);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<Object> getChildren(TreeModel treeModel, Object node) {
        ArrayList<Object> children = new ArrayList<Object>();
        int n = treeModel.getChildCount(node);
        for (int i = 0; i < n; ++i) {
            Object child = treeModel.getChild(node, i);
            children.add(child);
        }
        return children;
    }

    public static Object getParent(TreeModel treeModel, Object node) {
        return JTrees.getParent(treeModel, node, treeModel.getRoot());
    }

    private static Object getParent(TreeModel treeModel, Object node, Object potentialParent) {
        List<Object> children = JTrees.getChildren(treeModel, potentialParent);
        for (Object child : children) {
            if (child == node) {
                return potentialParent;
            }
            Object parent = JTrees.getParent(treeModel, node, child);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public static List<Object> getAllNodes(TreeModel treeModel) {
        ArrayList<Object> result = new ArrayList<Object>();
        JTrees.getAllDescendants(treeModel, treeModel.getRoot(), result);
        result.add(0, treeModel.getRoot());
        return result;
    }

    public static List<Object> getAllDescendants(TreeModel treeModel, Object node) {
        ArrayList<Object> result = new ArrayList<Object>();
        JTrees.getAllDescendants(treeModel, node, result);
        result.remove(node);
        return result;
    }

    private static void getAllDescendants(TreeModel treeModel, Object node, List<Object> result) {
        if (node == null) {
            return;
        }
        result.add(node);
        List<Object> children = JTrees.getChildren(treeModel, node);
        for (Object child : children) {
            JTrees.getAllDescendants(treeModel, child, result);
        }
    }

    public static List<Object> getLeafNodes(TreeModel treeModel) {
        return JTrees.getLeafNodes(treeModel, treeModel.getRoot());
    }

    public static List<Object> getLeafNodes(TreeModel treeModel, Object node) {
        ArrayList<Object> leafNodes = new ArrayList<Object>();
        JTrees.getLeafNodes(treeModel, node, leafNodes);
        return leafNodes;
    }

    private static void getLeafNodes(TreeModel treeModel, Object node, Collection<Object> leafNodes) {
        if (node == null) {
            return;
        }
        int childCount = treeModel.getChildCount(node);
        if (childCount == 0) {
            leafNodes.add(node);
        } else {
            for (int i = 0; i < childCount; ++i) {
                Object child = treeModel.getChild(node, i);
                JTrees.getLeafNodes(treeModel, child, leafNodes);
            }
        }
    }

    public static TreePath createTreePathToRoot(TreeModel treeModel, Object node) {
        Object parent;
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.add(node);
        Object current = node;
        while ((parent = JTrees.getParent(treeModel, current)) != null) {
            nodes.add(0, parent);
            current = parent;
        }
        TreePath treePath = new TreePath(nodes.toArray());
        return treePath;
    }

    public static List<TreePath> computeExpandedPaths(JTree tree) {
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        int rows = tree.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TreePath treePath = tree.getPathForRow(i);
            treePaths.add(treePath);
        }
        return treePaths;
    }

    public static TreePath translatePath(TreeModel newTreeModel, TreePath oldPath) {
        return JTrees.translatePath(newTreeModel, oldPath, Objects::equals);
    }

    public static TreePath translatePath(TreeModel newTreeModel, TreePath oldPath, BiPredicate<Object, Object> equality) {
        Object newRoot = newTreeModel.getRoot();
        ArrayList<Object> newPath = new ArrayList<Object>();
        newPath.add(newRoot);
        Object newPreviousElement = newRoot;
        for (int i = 1; i < oldPath.getPathCount(); ++i) {
            Object oldElement = oldPath.getPathComponent(i);
            Object oldUserObject = JTrees.getUserObjectFromTreeNode(oldElement);
            Object newElement = JTrees.getChildWith(newPreviousElement, oldUserObject, equality);
            if (newElement == null) {
                return null;
            }
            newPath.add(newElement);
            newPreviousElement = newElement;
        }
        return new TreePath(newPath.toArray());
    }

    private static Object getChildWith(Object node, Object userObject, BiPredicate<Object, Object> equality) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        for (int j = 0; j < treeNode.getChildCount(); ++j) {
            TreeNode child = treeNode.getChildAt(j);
            Object childUserObject = JTrees.getUserObjectFromTreeNode(child);
            if (!equality.test(userObject, childUserObject)) continue;
            return child;
        }
        return null;
    }

    public static Object getUserObjectFromTreePath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Object lastPathComponent = treePath.getLastPathComponent();
        return JTrees.getUserObjectFromTreeNode(lastPathComponent);
    }

    public static Object getUserObjectFromTreeNode(Object nodeObject) {
        if (nodeObject == null) {
            return null;
        }
        if (nodeObject instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
            Object userObject = node.getUserObject();
            return userObject;
        }
        return null;
    }

    public static int computeIndexInParent(Object nodeObject) {
        if (nodeObject instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
            TreeNode parent = node.getParent();
            if (parent == null) {
                return -1;
            }
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                TreeNode child = parent.getChildAt(i);
                if (child != nodeObject) continue;
                return i;
            }
        }
        return -1;
    }

    public static void applyButtonTreeCellRenderer(JTree tree, final Function<Object, JButton> buttonFactory, final Function<Object, String> textFactory) {
        final GenericTreeCellRenderer treeCellrenderer = new GenericTreeCellRenderer(){

            @Override
            protected void prepare(Object nodeObject, JPanel container) {
                container.setLayout(new BorderLayout(3, 0));
                JLabel textLabel = new JLabel();
                String text = (String)textFactory.apply(nodeObject);
                textLabel.setText(text);
                container.add((Component)textLabel, "Center");
                JButton button = (JButton)buttonFactory.apply(nodeObject);
                if (button != null) {
                    container.add((Component)button, "West");
                }
            }
        };
        tree.setCellRenderer(treeCellrenderer);
        tree.setEditable(true);
        DefaultCellEditor editor = new DefaultCellEditor(new JTextField()){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
                return treeCellrenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, true);
            }

            @Override
            public boolean isCellEditable(EventObject event) {
                return true;
            }
        };
        tree.setCellEditor(editor);
    }

    private JTrees() {
    }
}

