/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui;

import de.javagl.common.ui.LocationBasedAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public final class LocationBasedPopupHandler
extends MouseAdapter {
    private final JPopupMenu popupMenu;

    public LocationBasedPopupHandler(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.prepareAndShowPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.prepareAndShowPopup(e);
        }
    }

    private void prepareAndShowPopup(MouseEvent e) {
        this.prepareMenu(this.popupMenu, e.getComponent(), e.getX(), e.getY());
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void prepareMenu(Container menu, Component component, int x, int y) {
        int n = menu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            AbstractButton abstractButton;
            Action action;
            Component menuComponent = this.popupMenu.getComponent(i);
            if (menuComponent instanceof JMenu) {
                JMenu subMenu = (JMenu)menuComponent;
                this.prepareMenu(subMenu, component, x, y);
            }
            if (!(menuComponent instanceof AbstractButton) || (action = (abstractButton = (AbstractButton)menuComponent).getAction()) == null || !(action instanceof LocationBasedAction)) continue;
            LocationBasedAction locationBasedAction = (LocationBasedAction)action;
            locationBasedAction.prepareShow(component, x, y);
        }
    }
}

