/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui;

import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

class SpinnerDraggingHandler
extends MouseAdapter {
    private final JSpinner spinner;
    private final SpinnerNumberModel model;
    private Point previousPoint = new Point();
    private int currentFactor = 1;
    private final Robot robot;

    SpinnerDraggingHandler(JSpinner spinner) {
        SpinnerModel spinnerModel = spinner.getModel();
        if (!(spinnerModel instanceof SpinnerNumberModel)) {
            throw new IllegalArgumentException("Dragging is only possible for spinners with a SpinnerNumberModel, found " + spinnerModel.getClass());
        }
        this.spinner = spinner;
        this.model = (SpinnerNumberModel)spinnerModel;
        Robot theRobot = null;
        try {
            theRobot = new Robot();
        }
        catch (AWTException aWTException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.robot = theRobot;
    }

    private Number addTimes(Object n, Number toAdd, int times) {
        Number m = (Number)n;
        if (m instanceof Double) {
            return m.doubleValue() + (double)times * toAdd.doubleValue();
        }
        return m.intValue() + times * toAdd.intValue();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Number stepSize = this.model.getStepSize();
        Number value = (Number)this.model.getValue();
        double d = Math.abs(value.doubleValue()) / stepSize.doubleValue();
        int i = (int)Math.ceil(d / 250.0);
        this.currentFactor = Math.max(1, i);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.previousPoint = e.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.spinner.isEnabled()) {
            return;
        }
        boolean wrapped = this.handleWrapping(e);
        if (wrapped) {
            return;
        }
        int dy = this.previousPoint.y - e.getY();
        Object value = this.model.getValue();
        Number stepSize = this.model.getStepSize();
        Number newValue = this.addTimes(value, stepSize, dy * this.currentFactor);
        Number min = (Number)((Object)this.model.getMinimum());
        Number max = (Number)((Object)this.model.getMaximum());
        if (newValue.doubleValue() < min.doubleValue()) {
            newValue = min;
        }
        if (newValue.doubleValue() > max.doubleValue()) {
            newValue = max;
        }
        this.spinner.setValue(newValue);
        this.tryCommit();
        this.previousPoint = e.getPoint();
    }

    private boolean handleWrapping(MouseEvent e) {
        if (this.robot == null) {
            return false;
        }
        PointerInfo pointerInfo = null;
        try {
            pointerInfo = MouseInfo.getPointerInfo();
        }
        catch (SecurityException ex) {
            return false;
        }
        Rectangle r = pointerInfo.getDevice().getDefaultConfiguration().getBounds();
        Point onScreen = pointerInfo.getLocation();
        if (onScreen.y == 0) {
            this.robot.mouseMove(onScreen.x, r.height - 2);
            this.previousPoint = new Point(onScreen.x, r.height - 2);
            SwingUtilities.convertPointFromScreen(this.previousPoint, this.spinner);
            return true;
        }
        if (onScreen.y == r.height - 1) {
            this.robot.mouseMove(onScreen.x, 1);
            this.previousPoint = new Point(onScreen.x, 1);
            SwingUtilities.convertPointFromScreen(this.previousPoint, this.spinner);
            return true;
        }
        return false;
    }

    private void tryCommit() {
        try {
            JComponent editor = this.spinner.getEditor();
            if (editor instanceof JSpinner.DefaultEditor) {
                JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
                defaultEditor.commitEdit();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

