/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.closeable;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;

class CloseableContainerButton
extends JButton {
    private static final long serialVersionUID = 5601512731544692098L;
    private final MouseListener rolloverMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    CloseableContainerButton(ActionListener closeActionListener) {
        int size = 17;
        this.setPreferredSize(new Dimension(size, size));
        this.setToolTipText("Close");
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBorderPainted(false);
        this.addMouseListener(this.rolloverMouseListener);
        this.setRolloverEnabled(true);
        this.addActionListener(closeActionListener);
    }

    @Override
    protected void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Graphics2D g = (Graphics2D)gr.create();
        if (this.getModel().isPressed()) {
            g.translate(1, 1);
        }
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.GRAY);
        if (this.getModel().isRollover()) {
            g.setColor(Color.BLACK);
        }
        int delta = 6;
        int w = this.getWidth();
        int h = this.getHeight();
        g.drawLine(delta, delta, w - delta - 1, h - delta - 1);
        g.drawLine(w - delta - 1, delta, delta, h - delta - 1);
        g.dispose();
    }
}

