/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.closeable;

import de.javagl.common.ui.closeable.CloseCallback;
import de.javagl.common.ui.closeable.CloseCallbacks;
import de.javagl.common.ui.closeable.CloseableContainerButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class CloseablePanel
extends JPanel {
    private static final long serialVersionUID = 581192014966771340L;
    private final CloseableContainerButton closeableContainerButton;
    private final JPanel buttonContainer;
    private final String title;
    private final JComponent content;

    public CloseablePanel(JComponent content) {
        this(null, content, CloseCallbacks.alwaysTrue());
    }

    public CloseablePanel(String title, JComponent content) {
        this(title, content, CloseCallbacks.alwaysTrue());
    }

    public CloseablePanel(String title, final JComponent content, final CloseCallback closeCallback) {
        if (closeCallback == null) {
            throw new NullPointerException("closeCallback is null");
        }
        this.title = title;
        this.content = content;
        ActionListener closeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloseablePanel closeablePanel;
                Container parent;
                boolean mayClose = closeCallback.mayClose(content);
                if (mayClose && (parent = (closeablePanel = CloseablePanel.this).getParent()) != null) {
                    parent.remove(closeablePanel);
                    parent.revalidate();
                    parent.repaint();
                }
            }
        };
        this.closeableContainerButton = new CloseableContainerButton(closeActionListener);
        this.buttonContainer = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        p.add((Component)this.closeableContainerButton, "East");
        this.buttonContainer.add((Component)p, "North");
        this.buttonContainer.setOpaque(false);
        if (title == null) {
            this.setLayout(new OverlayLayout(this));
            this.add(content);
            this.add(this.buttonContainer);
            this.setComponentZOrder(content, 1);
            this.setComponentZOrder(this.buttonContainer, 0);
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)content, "Center");
            JPanel titlePanel = new JPanel(new BorderLayout());
            titlePanel.add((Component)new JLabel(title), "Center");
            titlePanel.add((Component)this.closeableContainerButton, "East");
            this.add((Component)titlePanel, "North");
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        if (super.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.title == null) {
            return this.content.getPreferredSize();
        }
        return super.getPreferredSize();
    }
}

