/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.closeable;

import de.javagl.common.ui.closeable.CloseCallback;
import de.javagl.common.ui.closeable.CloseCallbacks;
import de.javagl.common.ui.closeable.CloseableContainerButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CloseableTab
extends JPanel {
    private static final long serialVersionUID = -7605099240060933602L;

    public static void addTo(JTabbedPane tabbedPane, String title, JComponent component) {
        CloseableTab.addTo(tabbedPane, title, component, false);
    }

    public static void addTo(JTabbedPane tabbedPane, String title, JComponent component, boolean confirmClose) {
        if (confirmClose) {
            CloseableTab.addTo(tabbedPane, title, component, CloseCallbacks.confirming());
        } else {
            CloseableTab.addTo(tabbedPane, title, component, CloseCallbacks.alwaysTrue());
        }
    }

    public static void addTo(JTabbedPane tabbedPane, String title, JComponent component, CloseCallback closeCallback) {
        int index = tabbedPane.getTabCount();
        tabbedPane.addTab(title, component);
        tabbedPane.setTabComponentAt(index, new CloseableTab(tabbedPane, closeCallback));
        tabbedPane.setSelectedIndex(index);
    }

    CloseableTab(final JTabbedPane tabbedPane, final CloseCallback closeCallback) {
        super(new BorderLayout());
        if (tabbedPane == null) {
            throw new NullPointerException("tabbedPane is null");
        }
        if (closeCallback == null) {
            throw new NullPointerException("closeCallback is null");
        }
        JLabel label = new JLabel(){
            private static final long serialVersionUID = 5632763968012666836L;

            @Override
            public String getText() {
                int i = tabbedPane.indexOfTabComponent(CloseableTab.this);
                if (i != -1) {
                    return tabbedPane.getTitleAt(i);
                }
                return null;
            }
        };
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.add((Component)label, "Center");
        ActionListener closeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component tabComponent;
                boolean mayClose;
                int i = tabbedPane.indexOfTabComponent(CloseableTab.this);
                if (i != -1 && (mayClose = closeCallback.mayClose(tabComponent = tabbedPane.getSelectedComponent()))) {
                    tabbedPane.remove(i);
                }
            }
        };
        CloseableContainerButton closeableTabButton = new CloseableContainerButton(closeActionListener);
        this.add((Component)closeableTabButton, "East");
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.setOpaque(false);
    }
}

