/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;

public final class AspectLayout
implements LayoutManager {
    private final double aspect;
    private final double alignment;

    public AspectLayout(double aspect) {
        this(aspect, 0.5);
    }

    public AspectLayout(double aspect, double alignment) {
        this.aspect = aspect;
        this.alignment = alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int componentCount = parent.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            Insets insets = parent.getInsets();
            int insetsX = insets.left;
            int insetsY = insets.top;
            int totalSizeX = parent.getWidth() - (insetsX + insets.right);
            int totalSizeY = parent.getHeight() - (insetsY + insets.bottom);
            Point gridSize = AspectLayout.computeGridSize(parent, componentCount, this.aspect);
            int cellSizeX = totalSizeX / gridSize.x;
            int cellSizeY = totalSizeY / gridSize.y;
            for (int cx = 0; cx < gridSize.x; ++cx) {
                for (int cy = 0; cy < gridSize.y; ++cy) {
                    int componentIndex = cx + cy * gridSize.x;
                    if (componentIndex >= componentCount) continue;
                    Component component = parent.getComponent(componentIndex);
                    int cellX = insetsX + cx * cellSizeX;
                    int cellY = insetsY + cy * cellSizeY;
                    this.layoutChild(component, cellX, cellY, cellSizeX, cellSizeY);
                }
            }
        }
    }

    private void layoutChild(Component component, int cellX, int cellY, int cellSizeX, int cellSizeY) {
        int maxAspectW = (int)((double)cellSizeY * this.aspect);
        int maxAspectH = (int)((double)cellSizeX / this.aspect);
        if (maxAspectW > cellSizeX) {
            int w = cellSizeX;
            int h = maxAspectH;
            int space = cellSizeY - h;
            int offset = (int)(this.alignment * (double)space);
            component.setBounds(cellX, cellY + offset, w, h);
        } else {
            int w = maxAspectW;
            int h = cellSizeY;
            int space = cellSizeX - w;
            int offset = (int)(this.alignment * (double)space);
            component.setBounds(cellX + offset, cellY, w, h);
        }
    }

    private static Point computeGridSize(Container container, int numComponents, double aspect) {
        int gridSizeY;
        int gridSizeX;
        double containerSizeX = container.getWidth();
        double containerSizeY = container.getHeight();
        double minTotalWastedSpace = Double.MAX_VALUE;
        int minWasteGridSizeX = -1;
        for (gridSizeX = 1; gridSizeX <= numComponents; ++gridSizeX) {
            double cellSizeY;
            double cellSizeX;
            double wastedSpace;
            double totalWastedSpace;
            gridSizeY = numComponents / gridSizeX;
            if (gridSizeX * gridSizeY < numComponents) {
                ++gridSizeY;
            }
            if (!((totalWastedSpace = (double)(gridSizeX * gridSizeY) * (wastedSpace = AspectLayout.computeWastedSpace(cellSizeX = containerSizeX / (double)gridSizeX, cellSizeY = containerSizeY / (double)gridSizeY, aspect))) < minTotalWastedSpace)) continue;
            minTotalWastedSpace = totalWastedSpace;
            minWasteGridSizeX = gridSizeX;
        }
        gridSizeX = minWasteGridSizeX;
        gridSizeY = numComponents / gridSizeX;
        if (gridSizeX * gridSizeY < numComponents) {
            ++gridSizeY;
        }
        return new Point(gridSizeX, gridSizeY);
    }

    private static double computeWastedSpace(double maxSizeX, double maxSizeY, double aspect) {
        int maxAspectX = (int)(maxSizeY * aspect);
        int maxAspectY = (int)(maxSizeX / aspect);
        if ((double)maxAspectX > maxSizeX) {
            double sizeX = maxSizeX;
            double sizeY = maxAspectY;
            double waste = maxSizeY - sizeY;
            return waste * sizeX;
        }
        double sizeX = maxAspectX;
        double sizeY = maxSizeY;
        double waste = maxSizeX - sizeX;
        return waste * sizeY;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (parent.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        Component component = parent.getComponent(0);
        return component.getMinimumSize();
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (parent.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        Component component = parent.getComponent(0);
        return component.getPreferredSize();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public String toString() {
        return this.getClass().getName() + "[aspect=" + this.aspect + "]";
    }
}

