/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListSelectionModel;

public class ListSelectionModels {
    public static void setAsSelection(ListSelectionModel selectionModel, Collection<? extends Integer> selectedIndices) {
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        for (Integer n : selectedIndices) {
            selectionModel.addSelectionInterval(n, n);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public static void addToSelection(ListSelectionModel selectionModel, Collection<? extends Integer> selectedIndices) {
        selectionModel.setValueIsAdjusting(true);
        for (Integer n : selectedIndices) {
            selectionModel.addSelectionInterval(n, n);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public static void removeFromSelection(ListSelectionModel selectionModel, Collection<? extends Integer> unselectedIndices) {
        selectionModel.setValueIsAdjusting(true);
        for (Integer n : unselectedIndices) {
            selectionModel.removeSelectionInterval(n, n);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public static List<Integer> computeUnselectedIndices(ListSelectionModel selectionModel, int size) {
        ArrayList<Integer> unselectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            if (selectionModel.isSelectedIndex(i)) continue;
            unselectedIndices.add(i);
        }
        return unselectedIndices;
    }

    public static List<Integer> computeSelectedIndices(ListSelectionModel selectionModel) {
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        int min = selectionModel.getMinSelectionIndex();
        if (min == -1) {
            return selectedIndices;
        }
        int max = selectionModel.getMaxSelectionIndex();
        for (int i = min; i <= max; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            selectedIndices.add(i);
        }
        return selectedIndices;
    }

    private ListSelectionModels() {
    }
}

