/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.panel.collapsible;

import de.javagl.common.ui.GuiUtils;
import de.javagl.common.ui.JScrollPanes;
import de.javagl.common.ui.panel.collapsible.CollapsiblePanel;
import de.javagl.common.ui.panel.collapsible.ScrollablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AccordionPanel
extends JPanel {
    private static final long serialVersionUID = 7425427793372692306L;
    private final JPanel contentPanel = new ScrollablePanel();
    private final Map<JComponent, CollapsiblePanel> collapsiblePanels;

    public AccordionPanel() {
        super(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.collapsiblePanels = new LinkedHashMap<JComponent, CollapsiblePanel>();
        JScrollPane controlPanelScrollPane = JScrollPanes.createVerticalScrollPane(this.contentPanel);
        controlPanelScrollPane.setVerticalScrollBarPolicy(22);
        controlPanelScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)controlPanelScrollPane, "Center");
    }

    public CollapsiblePanel addToAccordion(String title, JComponent component) {
        return this.addToAccordion(title, component, false);
    }

    public CollapsiblePanel addToAccordion(String title, JComponent component, boolean minimized) {
        CollapsiblePanel collapsiblePanel = GuiUtils.wrapCollapsible(title, component);
        collapsiblePanel.setMinimized(minimized);
        this.contentPanel.add(collapsiblePanel);
        this.collapsiblePanels.put(component, collapsiblePanel);
        this.revalidate();
        return collapsiblePanel;
    }

    public void removeFromAccordion(JComponent component) {
        CollapsiblePanel collapsiblePanel = this.collapsiblePanels.get(component);
        if (collapsiblePanel != null) {
            this.contentPanel.remove(collapsiblePanel);
            this.collapsiblePanels.remove(component);
            this.revalidate();
        }
    }

    public void clearAccordion() {
        ArrayList<JComponent> components = new ArrayList<JComponent>(this.collapsiblePanels.keySet());
        for (JComponent component : components) {
            this.removeFromAccordion(component);
        }
    }
}

