/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.panel.collapsible;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

public class CollapsiblePanel
extends JPanel {
    private static final long serialVersionUID = 665411946824373388L;
    private boolean minimized;
    private int currentHeight = -1;
    private int minimizedHeight;
    private Timer timer;
    private final int durationMS = 250;
    private final int delayMS = 25;

    public CollapsiblePanel(String title) {
        this(new FlowLayout(), title, false);
    }

    public CollapsiblePanel(String title, boolean minimized) {
        this(new FlowLayout(), title, minimized);
    }

    public CollapsiblePanel(LayoutManager layoutManager, String title) {
        this(layoutManager, title, false);
    }

    public CollapsiblePanel(LayoutManager layoutManager, String title, boolean minimized) {
        super(layoutManager);
        this.minimized = minimized;
        CollapsibleTitledBorder border = new CollapsibleTitledBorder(title);
        this.setBorder(border);
        Insets insets = border.getBorderInsets(this);
        this.minimizedHeight = insets.top + 1;
        this.currentHeight = minimized ? this.minimizedHeight : Integer.MAX_VALUE;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getY() < CollapsiblePanel.this.minimizedHeight) {
                    CollapsiblePanel.this.setMinimized(!CollapsiblePanel.this.isMinimized());
                }
            }
        });
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    private int getSuperPreferredHeight() {
        Dimension d = super.getPreferredSize();
        return d.height;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        if (this.minimized && !minimized) {
            this.maximize();
        } else if (!this.minimized && minimized) {
            this.minimize();
        }
    }

    private void minimize() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.currentHeight = this.getHeight();
        double steps = 10.0;
        double delta = this.currentHeight - this.minimizedHeight;
        final int stepSize = (int)Math.ceil(delta / steps);
        this.timer = new Timer(25, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollapsiblePanel.this.currentHeight = CollapsiblePanel.this.currentHeight - stepSize;
                CollapsiblePanel.this.currentHeight = Math.max(CollapsiblePanel.this.currentHeight, CollapsiblePanel.this.minimizedHeight);
                if (CollapsiblePanel.this.currentHeight <= CollapsiblePanel.this.minimizedHeight) {
                    CollapsiblePanel.this.minimized = true;
                    CollapsiblePanel.this.timer.stop();
                    CollapsiblePanel.this.timer = null;
                }
                CollapsiblePanel.this.revalidate();
            }
        });
        this.timer.setInitialDelay(0);
        this.timer.start();
    }

    private void maximize() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        final int targetHeight = this.getSuperPreferredHeight();
        double steps = 10.0;
        double delta = targetHeight - this.currentHeight;
        final int stepSize = (int)Math.ceil(delta / steps);
        this.currentHeight = this.getHeight();
        this.timer = new Timer(25, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollapsiblePanel.this.minimized = false;
                CollapsiblePanel.this.currentHeight = CollapsiblePanel.this.currentHeight + stepSize;
                CollapsiblePanel.this.currentHeight = Math.min(CollapsiblePanel.this.currentHeight, targetHeight);
                if (CollapsiblePanel.this.currentHeight >= targetHeight) {
                    CollapsiblePanel.this.currentHeight = Integer.MAX_VALUE;
                    CollapsiblePanel.this.timer.stop();
                    CollapsiblePanel.this.timer = null;
                }
                CollapsiblePanel.this.revalidate();
            }
        });
        this.timer.setInitialDelay(0);
        this.timer.start();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (super.isPreferredSizeSet()) {
            return d;
        }
        if (this.currentHeight != Integer.MAX_VALUE) {
            d.height = this.currentHeight;
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (super.isMinimumSizeSet()) {
            return d;
        }
        if (this.minimized) {
            d.height = this.minimizedHeight;
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (super.isMaximumSizeSet()) {
            return d;
        }
        if (this.minimized) {
            d.height = this.minimizedHeight;
        }
        return d;
    }

    private class CollapsibleTitledBorder
    extends TitledBorder {
        private static final long serialVersionUID = 8843873866801716306L;

        private CollapsibleTitledBorder(String title) {
            super(title);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x, y, width, height);
            Insets insets = CollapsiblePanel.this.getInsets();
            int space = 4;
            int rectSize = insets.top - space - space;
            int rectMinY = space;
            int rectMinX = width - rectSize - space - space;
            g.setColor(CollapsiblePanel.this.getBackground());
            g.fillRect(rectMinX, rectMinY, rectSize, rectSize);
            g.setColor(CollapsiblePanel.this.getForeground());
            g.drawRect(rectMinX, rectMinY, rectSize, rectSize);
            int x0 = 2;
            int x1 = rectSize - 2;
            int y0 = rectSize / 2;
            int y1 = rectSize / 2;
            g.drawLine(rectMinX + x0, rectMinY + y0, rectMinX + x1, rectMinY + y1);
            if (CollapsiblePanel.this.isMinimized()) {
                g.drawLine(rectMinX + y0, rectMinY + x0, rectMinX + y1, rectMinY + x1);
            }
        }
    }
}

