/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.properties;

import de.javagl.common.ui.properties.PropertiesHandle;
import de.javagl.common.ui.properties.PropertiesHandles;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.logging.Logger;

class DefaultPropertiesHandle
implements PropertiesHandle {
    private static final Logger logger = Logger.getLogger(DefaultPropertiesHandle.class.getName());
    private static final String POINT_X = "x";
    private static final String POINT_Y = "y";
    private static final String RECTANGLE_X = "x";
    private static final String RECTANGLE_Y = "y";
    private static final String RECTANGLE_W = "width";
    private static final String RECTANGLE_H = "height";
    private static final String COLOR_R = "r";
    private static final String COLOR_G = "g";
    private static final String COLOR_B = "b";
    private static final String COLOR_A = "a";
    private final String propertiesFileName;
    private final Properties properties;

    DefaultPropertiesHandle(String propertiesFileName) {
        this.propertiesFileName = Objects.requireNonNull(propertiesFileName, "The propertiesFileName may not be null");
        this.properties = PropertiesHandles.readPropertiesUnchecked(propertiesFileName);
    }

    private void writePropertiesUnchecked() {
        PropertiesHandles.writePropertiesUnchecked(this.properties, this.propertiesFileName);
    }

    @Override
    public void writeString(String name, String value) {
        if (value == null) {
            return;
        }
        this.properties.put(name, value);
        this.writePropertiesUnchecked();
    }

    @Override
    public void saveString(String name, Supplier<? extends String> supplier) {
        this.writeString(name, supplier.get());
    }

    @Override
    public String readString(String name) {
        String s = this.properties.getProperty(name);
        return s;
    }

    @Override
    public void restoreString(String name, Consumer<? super String> consumer) {
        String value = this.readString(name);
        if (value != null) {
            consumer.accept(value);
        }
    }

    @Override
    public void writeInteger(String name, Integer value) {
        if (value == null) {
            return;
        }
        this.properties.put(name, String.valueOf(value));
        this.writePropertiesUnchecked();
    }

    @Override
    public void saveInteger(String name, IntSupplier supplier) {
        this.writeInteger(name, supplier.getAsInt());
    }

    @Override
    public Integer readInteger(String name) {
        String s = this.properties.getProperty(name);
        if (s == null) {
            return null;
        }
        try {
            int value = Integer.parseInt(s);
            return value;
        }
        catch (NumberFormatException e) {
            logger.warning(e.toString());
            return null;
        }
    }

    @Override
    public void restoreInteger(String name, IntConsumer consumer) {
        Integer value = this.readInteger(name);
        if (value != null) {
            consumer.accept(value);
        }
    }

    @Override
    public void writeDouble(String name, Double value) {
        if (value == null) {
            return;
        }
        this.properties.put(name, String.valueOf(value));
        this.writePropertiesUnchecked();
    }

    @Override
    public void saveDouble(String name, DoubleSupplier supplier) {
        this.writeDouble(name, supplier.getAsDouble());
    }

    @Override
    public Double readDouble(String name) {
        String s = this.properties.getProperty(name);
        if (s == null) {
            return null;
        }
        try {
            double value = Double.parseDouble(s);
            return value;
        }
        catch (NumberFormatException e) {
            logger.warning(e.toString());
            return null;
        }
    }

    @Override
    public void restoreDouble(String name, DoubleConsumer consumer) {
        Double d = this.readDouble(name);
        if (d != null) {
            consumer.accept(d);
        }
    }

    @Override
    public void writePath(String name, Path value) {
        if (value == null) {
            return;
        }
        String s = value.normalize().toString();
        this.properties.put(name, s);
        this.writePropertiesUnchecked();
    }

    @Override
    public void savePath(String name, Supplier<? extends Path> supplier) {
        this.writePath(name, supplier.get());
    }

    @Override
    public Path readPath(String name) {
        String s = this.properties.getProperty(name);
        if (s == null) {
            return null;
        }
        try {
            Path value = Paths.get(s, new String[0]);
            return value;
        }
        catch (InvalidPathException e) {
            logger.warning(e.toString());
            return null;
        }
    }

    @Override
    public void restorePath(String name, Consumer<? super Path> consumer) {
        Path value = this.readPath(name);
        if (value != null) {
            consumer.accept(value);
        }
    }

    @Override
    public void writePoint(String prefix, Point value) {
        if (value == null) {
            return;
        }
        this.properties.put(prefix + "." + "x", String.valueOf(value.x));
        this.properties.put(prefix + "." + "y", String.valueOf(value.y));
        this.writePropertiesUnchecked();
    }

    @Override
    public void savePoint(String prefix, Supplier<? extends Point> supplier) {
        this.writePoint(prefix, supplier.get());
    }

    @Override
    public Point readPoint(String prefix) {
        String sx = this.properties.getProperty(prefix + "." + "x");
        String sy = this.properties.getProperty(prefix + "." + "y");
        if (Arrays.asList(sx, sy).contains(null)) {
            return null;
        }
        try {
            int x = Integer.parseInt(sx);
            int y = Integer.parseInt(sy);
            Point value = new Point(x, y);
            return value;
        }
        catch (NumberFormatException e) {
            logger.warning(e.toString());
            return null;
        }
    }

    @Override
    public void restorePoint(String prefix, Consumer<? super Point> consumer) {
        Point value = this.readPoint(prefix);
        if (value != null) {
            consumer.accept(value);
        }
    }

    @Override
    public void writeRectangle(String prefix, Rectangle value) {
        if (value == null) {
            return;
        }
        this.properties.put(prefix + "." + "x", String.valueOf(value.x));
        this.properties.put(prefix + "." + "y", String.valueOf(value.y));
        this.properties.put(prefix + "." + RECTANGLE_W, String.valueOf(value.width));
        this.properties.put(prefix + "." + RECTANGLE_H, String.valueOf(value.height));
        this.writePropertiesUnchecked();
    }

    @Override
    public void saveRectangle(String prefix, Supplier<? extends Rectangle> supplier) {
        this.writeRectangle(prefix, supplier.get());
    }

    @Override
    public Rectangle readRectangle(String prefix) {
        String sx = this.properties.getProperty(prefix + "." + "x");
        String sy = this.properties.getProperty(prefix + "." + "y");
        String sw = this.properties.getProperty(prefix + "." + RECTANGLE_W);
        String sh = this.properties.getProperty(prefix + "." + RECTANGLE_H);
        if (Arrays.asList(sx, sy, sw, sh).contains(null)) {
            return null;
        }
        try {
            int x = Integer.parseInt(sx);
            int y = Integer.parseInt(sy);
            int w = Integer.parseInt(sw);
            int h = Integer.parseInt(sh);
            Rectangle value = new Rectangle(x, y, w, h);
            return value;
        }
        catch (NumberFormatException e) {
            logger.warning(e.toString());
            return null;
        }
    }

    @Override
    public void restoreRectangle(String prefix, Consumer<? super Rectangle> consumer) {
        Rectangle value = this.readRectangle(prefix);
        if (value != null) {
            consumer.accept(value);
        }
    }

    @Override
    public void writeColor(String prefix, Color value) {
        if (value == null) {
            return;
        }
        this.properties.put(prefix + "." + COLOR_R, String.valueOf(value.getRed()));
        this.properties.put(prefix + "." + COLOR_G, String.valueOf(value.getGreen()));
        this.properties.put(prefix + "." + COLOR_B, String.valueOf(value.getBlue()));
        this.properties.put(prefix + "." + COLOR_A, String.valueOf(value.getAlpha()));
        this.writePropertiesUnchecked();
    }

    @Override
    public void saveColor(String prefix, Supplier<? extends Color> supplier) {
        this.writeColor(prefix, supplier.get());
    }

    @Override
    public Color readColor(String prefix) {
        String sr = this.properties.getProperty(prefix + "." + COLOR_R);
        String sg = this.properties.getProperty(prefix + "." + COLOR_G);
        String sb = this.properties.getProperty(prefix + "." + COLOR_B);
        String sa = this.properties.getProperty(prefix + "." + COLOR_A);
        if (Arrays.asList(sr, sg, sb, sa).contains(null)) {
            return null;
        }
        try {
            int r = Integer.parseInt(sr);
            int g = Integer.parseInt(sg);
            int b = Integer.parseInt(sb);
            int a = Integer.parseInt(sa);
            Color value = new Color(r, g, b, a);
            return value;
        }
        catch (NumberFormatException e) {
            logger.warning(e.toString());
            return null;
        }
    }

    @Override
    public void restoreColor(String prefix, Consumer<? super Color> consumer) {
        Color value = this.readColor(prefix);
        if (value != null) {
            consumer.accept(value);
        }
    }
}

