/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PropertiesDialog
extends JDialog {
    private static final long serialVersionUID = -8805281807988147166L;
    private Popup popup;
    private boolean cancelled = false;
    private final List<String> propertyNames;
    private final List<Predicate<? super String>> propertyValidators;
    private final List<Function<? super String, String>> propertyMessages;
    private final List<JTextField> textFields;
    private final JButton okButton;

    public static PropertiesDialogBuilder create(Component parentComponent, String title) {
        return new PropertiesDialogBuilder(parentComponent, title);
    }

    PropertiesDialog(Component parentComponent, String title, List<String> propertyNames, List<String> propertyDescriptions, List<String> propertyDefaultValues, List<Predicate<? super String>> propertyValidators, List<Function<? super String, String>> propertyMessages) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(0);
        this.propertyNames = propertyNames;
        this.propertyValidators = propertyValidators;
        this.propertyMessages = propertyMessages;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(0, 2, 5, 5));
        this.textFields = new ArrayList<JTextField>();
        for (int i = 0; i < propertyNames.size(); ++i) {
            String propertyDescription = propertyDescriptions.get(i);
            String propertyValue = propertyDefaultValues.get(i);
            JLabel label = new JLabel(propertyDescription);
            panel.add(label);
            JTextField textField = new JTextField(propertyValue);
            this.textFields.add(textField);
            JPanel textFieldContainer = new JPanel(new BorderLayout());
            textFieldContainer.add((Component)textField, "North");
            panel.add(textFieldContainer);
        }
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)panel, "North");
        this.getContentPane().add((Component)p, "Center");
        JButton cancelButton = new JButton("Cancel");
        this.okButton = new JButton("OK");
        this.okButton.setEnabled(false);
        cancelButton.addActionListener(e -> {
            this.cancelled = true;
            this.setVisible(false);
            this.dispose();
        });
        this.okButton.addActionListener(e -> {
            this.cancelled = false;
            this.setVisible(false);
            this.dispose();
        });
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(this.okButton);
        this.getContentPane().add((Component)buttonsPanel, "South");
        for (JTextField textField : this.textFields) {
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    PropertiesDialog.this.updateButtonState();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    PropertiesDialog.this.updateButtonState();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    PropertiesDialog.this.updateButtonState();
                }
            });
        }
        this.updateButtonState();
    }

    private void updateButtonState() {
        this.hideValidationMessagePopup();
        boolean allValid = true;
        boolean firstInvalid = true;
        for (int i = 0; i < this.propertyNames.size(); ++i) {
            String messageResult;
            Function<? super String, String> message;
            Predicate<? super String> propertyValidator = this.propertyValidators.get(i);
            if (propertyValidator == null) continue;
            JTextField textField = this.textFields.get(i);
            String value = textField.getText();
            boolean isValid = propertyValidator.test(value);
            allValid &= isValid;
            if (isValid || (message = this.propertyMessages.get(i)) == null || (messageResult = message.apply(value)) == null || !firstInvalid) continue;
            this.showValidationMessagePopup(textField, messageResult);
            firstInvalid = false;
        }
        this.okButton.setEnabled(allValid);
    }

    private void showValidationMessagePopup(JComponent component, String textOrHtml) {
        this.hideValidationMessagePopup();
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        JLabel label = new JLabel(textOrHtml);
        label.setOpaque(true);
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Point p = new Point(component.getWidth(), 0);
        SwingUtilities.convertPointToScreen(p, component);
        this.popup = popupFactory.getPopup(component, label, p.x, p.y);
        this.popup.show();
    }

    private void hideValidationMessagePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public Map<String, String> showDialog() {
        this.cancelled = false;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        if (this.cancelled) {
            return null;
        }
        LinkedHashMap<String, String> propertyValues = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.propertyNames.size(); ++i) {
            String propertyName = this.propertyNames.get(i);
            JTextField textField = this.textFields.get(i);
            String propertyValue = textField.getText();
            propertyValues.put(propertyName, propertyValue);
        }
        return propertyValues;
    }

    public static class PropertiesDialogBuilder {
        private final Component parentComponent;
        private final String title;
        private final List<String> propertyNames;
        private final List<String> propertyDescriptions;
        private final List<String> propertyDefaultValues;
        private final List<Predicate<? super String>> propertyValidators;
        private final List<Function<? super String, String>> propertyMessages;

        PropertiesDialogBuilder(Component parentComponent, String title) {
            this.parentComponent = parentComponent;
            this.title = title;
            this.propertyNames = new ArrayList<String>();
            this.propertyDescriptions = new ArrayList<String>();
            this.propertyDefaultValues = new ArrayList<String>();
            this.propertyValidators = new ArrayList<Predicate<? super String>>();
            this.propertyMessages = new ArrayList<Function<? super String, String>>();
        }

        public PropertiesDialogBuilder addProperty(String name, String description, String defaultValue) {
            return this.addProperty(name, description, defaultValue, null, null);
        }

        public PropertiesDialogBuilder addProperty(String name, String description) {
            return this.addProperty(name, description, null, null, null);
        }

        public PropertiesDialogBuilder addProperty(String name, String description, String defaultValue, Predicate<? super String> validator) {
            return this.addProperty(name, description, defaultValue, validator, null);
        }

        public PropertiesDialogBuilder addProperty(String name, String description, String defaultValue, Predicate<? super String> validator, Function<? super String, String> message) {
            this.propertyNames.add(name);
            this.propertyDescriptions.add(description);
            this.propertyDefaultValues.add(defaultValue);
            this.propertyValidators.add(validator);
            this.propertyMessages.add(message);
            return this;
        }

        public PropertiesDialog build() {
            return new PropertiesDialog(this.parentComponent, this.title, this.propertyNames, this.propertyDescriptions, this.propertyDefaultValues, this.propertyValidators, this.propertyMessages);
        }
    }
}

