/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.properties;

import de.javagl.common.ui.properties.DefaultPropertiesHandle;
import de.javagl.common.ui.properties.PropertiesHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class PropertiesHandles {
    private static final Logger logger = Logger.getLogger(PropertiesHandles.class.getName());
    private static final Map<String, PropertiesHandle> INSTANCES = new LinkedHashMap<String, PropertiesHandle>();

    public static synchronized PropertiesHandle get(String propertiesFileName) {
        return INSTANCES.computeIfAbsent(propertiesFileName, n -> new DefaultPropertiesHandle(propertiesFileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Properties readPropertiesUnchecked(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return new Properties();
        }
        try (FileInputStream in = new FileInputStream(file);){
            Properties properties2 = new Properties();
            properties2.load(in);
            Properties properties = properties2;
            return properties;
        }
        catch (IOException e) {
            logger.warning("Could not read properties: " + e);
            return new Properties();
        }
    }

    static void writePropertiesUnchecked(Properties properties, String fileName) {
        if (properties == null) {
            logger.warning("The given properties object is null");
            return;
        }
        try (FileOutputStream out = new FileOutputStream(fileName);){
            properties.store(out, "Properties");
        }
        catch (IOException e) {
            logger.warning("Could not write properties: " + e);
        }
    }

    private PropertiesHandles() {
    }
}

