/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.properties;

import de.javagl.common.ui.properties.PropertiesHandle;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class PropertiesManager {
    private final PropertiesHandle propertiesHandle;
    private final Map<String, Class<?>> types;
    private final Map<String, Object> suppliers;
    private final Map<String, Object> consumers;
    private final WindowAdapter windowAdapter = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            PropertiesManager.this.save();
        }
    };

    public PropertiesManager(PropertiesHandle propertiesHandle) {
        this.propertiesHandle = Objects.requireNonNull(propertiesHandle, "The propertiesHandle may not be null");
        this.types = new LinkedHashMap();
        this.suppliers = new LinkedHashMap<String, Object>();
        this.consumers = new LinkedHashMap<String, Object>();
    }

    public void registerString(String name, Supplier<? extends String> supplier, Consumer<? super String> consumer) {
        this.register(name, String.class, supplier, consumer);
    }

    public void registerInteger(String name, IntSupplier supplier, IntConsumer consumer) {
        this.register(name, Integer.class, supplier, consumer);
    }

    public void registerDouble(String name, DoubleSupplier supplier, DoubleConsumer consumer) {
        this.register(name, Double.class, supplier, consumer);
    }

    public void registerPath(String name, Supplier<? extends Path> supplier, Consumer<? super Path> consumer) {
        this.register(name, Path.class, supplier, consumer);
    }

    public void registerPoint(String name, Supplier<? extends Point> supplier, Consumer<? super Point> consumer) {
        this.register(name, Point.class, supplier, consumer);
    }

    public void registerRectangle(String name, Supplier<? extends Rectangle> supplier, Consumer<? super Rectangle> consumer) {
        this.register(name, Rectangle.class, supplier, consumer);
    }

    public void registerColor(String name, Supplier<? extends Color> supplier, Consumer<? super Color> consumer) {
        this.register(name, Color.class, supplier, consumer);
    }

    private void register(String name, Class<?> type, Object supplier, Object consumer) {
        if (this.types.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate name: " + name);
        }
        this.types.put(name, type);
        this.suppliers.put(name, supplier);
        this.consumers.put(name, consumer);
    }

    public void save() {
        for (String name : this.types.keySet()) {
            Object typedSupplier;
            Class<?> type = this.types.get(name);
            Object supplier = this.suppliers.get(name);
            if (supplier == null) continue;
            if (type.equals(String.class)) {
                typedSupplier = (Supplier)supplier;
                this.propertiesHandle.saveString(name, (Supplier<? extends String>)typedSupplier);
            }
            if (type.equals(Integer.class)) {
                typedSupplier = (IntSupplier)supplier;
                this.propertiesHandle.saveInteger(name, (IntSupplier)typedSupplier);
            }
            if (type.equals(Double.class)) {
                typedSupplier = (DoubleSupplier)supplier;
                this.propertiesHandle.saveDouble(name, (DoubleSupplier)typedSupplier);
            }
            if (type.equals(Path.class)) {
                typedSupplier = (Supplier)supplier;
                this.propertiesHandle.savePath(name, (Supplier<? extends Path>)typedSupplier);
            }
            if (type.equals(Point.class)) {
                typedSupplier = (Supplier)supplier;
                this.propertiesHandle.savePoint(name, (Supplier<? extends Point>)typedSupplier);
            }
            if (type.equals(Rectangle.class)) {
                typedSupplier = (Supplier)supplier;
                this.propertiesHandle.saveRectangle(name, (Supplier<? extends Rectangle>)typedSupplier);
            }
            if (!type.equals(Color.class)) continue;
            typedSupplier = (Supplier)supplier;
            this.propertiesHandle.saveColor(name, (Supplier<? extends Color>)typedSupplier);
        }
    }

    public void restore() {
        for (String name : this.types.keySet()) {
            Object typedConsumer;
            Class<?> type = this.types.get(name);
            Object consumer = this.consumers.get(name);
            if (consumer == null) continue;
            if (type.equals(String.class)) {
                typedConsumer = (Consumer)consumer;
                this.propertiesHandle.restoreString(name, (Consumer<? super String>)typedConsumer);
            }
            if (type.equals(Integer.class)) {
                typedConsumer = (IntConsumer)consumer;
                this.propertiesHandle.restoreInteger(name, (IntConsumer)typedConsumer);
            }
            if (type.equals(Double.class)) {
                typedConsumer = (DoubleConsumer)consumer;
                this.propertiesHandle.restoreDouble(name, (DoubleConsumer)typedConsumer);
            }
            if (type.equals(Path.class)) {
                typedConsumer = (Consumer)consumer;
                this.propertiesHandle.restorePath(name, (Consumer<? super Path>)typedConsumer);
            }
            if (type.equals(Point.class)) {
                typedConsumer = (Consumer)consumer;
                this.propertiesHandle.restorePoint(name, (Consumer<? super Point>)typedConsumer);
            }
            if (type.equals(Rectangle.class)) {
                typedConsumer = (Consumer)consumer;
                this.propertiesHandle.restoreRectangle(name, (Consumer<? super Rectangle>)typedConsumer);
            }
            if (!type.equals(Color.class)) continue;
            typedConsumer = (Consumer)consumer;
            this.propertiesHandle.restoreColor(name, (Consumer<? super Color>)typedConsumer);
        }
    }

    public void saveOnClose(Window window) {
        window.addWindowListener(this.windowAdapter);
    }

    public void detachSaveOnClose(Window window) {
        window.removeWindowListener(this.windowAdapter);
    }
}

