/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.table;

import de.javagl.common.ui.table.renderer.CompoundTableCellRenderer;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CustomizedTableHeader
extends JTableHeader {
    private static final long serialVersionUID = 1980995454624976265L;
    private final int customComponentHeight;
    private final TableCellRenderer spaceRenderer;
    private final PropertyChangeListener widthListener;
    private final TableColumnModelListener columnModelListener;
    private final IntFunction<JComponent> componentFactory;
    private final IntConsumer componentRemover;
    private final List<JComponent> customComponents;
    private final List<TableColumn> tableColumns;

    public CustomizedTableHeader(TableColumnModel tableColumnModel, final int customComponentHeight, IntFunction<JComponent> componentFactory, IntConsumer componentRemover) {
        this.customComponentHeight = customComponentHeight;
        this.componentFactory = Objects.requireNonNull(componentFactory, "The componentFactory may not be null");
        this.componentRemover = componentRemover;
        this.tableColumns = new ArrayList<TableColumn>();
        this.customComponents = new ArrayList<JComponent>();
        this.columnModelListener = new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                CustomizedTableHeader.this.removeColumn(e.getFromIndex());
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                int toIndex;
                int fromIndex = e.getFromIndex();
                if (fromIndex != (toIndex = e.getToIndex())) {
                    Collections.swap(CustomizedTableHeader.this.tableColumns, fromIndex, toIndex);
                    Collections.swap(CustomizedTableHeader.this.customComponents, fromIndex, toIndex);
                }
                CustomizedTableHeader.this.updateCustomComponentBounds();
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                CustomizedTableHeader.this.addColumn(e.getToIndex());
            }
        };
        this.widthListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("width".equals(evt.getPropertyName())) {
                    CustomizedTableHeader.this.updateCustomComponentBounds();
                }
            }
        };
        this.spaceRenderer = new TableCellRenderer(){
            private final Component component;
            {
                this.component = Box.createVerticalStrut(customComponentHeight);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return this.component;
            }
        };
        this.setColumnModel(tableColumnModel);
        this.setDefaultRenderer(this.createDefaultRenderer());
    }

    @Override
    public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
        if (this.spaceRenderer != null) {
            CompoundTableCellRenderer renderer = new CompoundTableCellRenderer(this.spaceRenderer, defaultRenderer);
            super.setDefaultRenderer(renderer);
        } else {
            super.setDefaultRenderer(defaultRenderer);
        }
    }

    private void removeColumn(int index) {
        TableColumn column = this.tableColumns.get(index);
        column.removePropertyChangeListener(this.widthListener);
        this.tableColumns.remove(index);
        JComponent component = this.customComponents.remove(index);
        this.remove(component);
        if (this.componentRemover != null) {
            this.componentRemover.accept(index);
        }
    }

    private void addColumn(int index) {
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn column = columnModel.getColumn(index);
        while (this.tableColumns.size() - 1 < index) {
            this.tableColumns.add(null);
        }
        this.tableColumns.set(index, column);
        column.addPropertyChangeListener(this.widthListener);
        JComponent component = this.componentFactory.apply(index);
        while (this.customComponents.size() - 1 < index) {
            this.customComponents.add(null);
        }
        this.customComponents.set(index, component);
        this.add(component);
    }

    private void updateCustomComponentBounds() {
        if (this.customComponents == null) {
            return;
        }
        if (this.table == null) {
            return;
        }
        for (int i = 0; i < this.customComponents.size(); ++i) {
            JComponent component = this.customComponents.get(i);
            Rectangle rect = this.getHeaderRect(i);
            rect.height = this.customComponentHeight;
            component.setBounds(rect);
        }
        this.revalidate();
    }

    @Override
    public void setColumnModel(TableColumnModel newColumnModel) {
        int i;
        int n;
        TableColumnModel oldColumnModel = this.getColumnModel();
        if (oldColumnModel != null) {
            oldColumnModel.removeColumnModelListener(this.columnModelListener);
            n = oldColumnModel.getColumnCount();
            for (i = 0; i < n; ++i) {
                this.removeColumn(0);
            }
        }
        super.setColumnModel(newColumnModel);
        if (newColumnModel != null) {
            newColumnModel.addColumnModelListener(this.columnModelListener);
            n = newColumnModel.getColumnCount();
            for (i = 0; i < n; ++i) {
                this.addColumn(i);
            }
        }
        this.updateCustomComponentBounds();
    }
}

