/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class GenericTableModel
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(GenericTableModel.class.getName());
    private static final long serialVersionUID = -597222256747479585L;
    private final List<Column> columns = new ArrayList<Column>();
    private final List<Object> elements = new ArrayList<Object>();

    public <T, V> void addColumn(String name, Class<? extends V> type, Function<T, V> getter) {
        this.addColumn(name, type, getter, null);
    }

    public <T, V> void addColumn(String name, Class<? extends V> type, Function<T, V> getter, BiConsumer<T, V> setter) {
        Column column = new Column();
        column.name = Objects.requireNonNull(name, "The name may not be null");
        column.type = Objects.requireNonNull(type, "The type may not be null");
        column.getter = Objects.requireNonNull(getter, "The getter may not be null");
        column.setter = setter;
        this.columns.add(column);
        this.fireTableStructureChanged();
    }

    public void removeColumn(int index) {
        this.columns.remove(index);
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.elements.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int c) {
        return this.columns.get((int)c).name;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columns.get((int)c).type;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        Column column = this.columns.get(c);
        return column.setter != null;
    }

    public void addRow(Object element) {
        this.insertRow(this.getRowCount(), element);
    }

    public void insertRow(int index, Object element) {
        this.elements.add(index, element);
        this.fireTableRowsInserted(index, index);
    }

    public void removeRow(int index) {
        this.elements.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        Column column = this.columns.get(c);
        Object element = this.elements.get(r);
        BiConsumer<?, ?> setter = column.setter;
        try {
            BiConsumer<?, ?> typedSetter = setter;
            typedSetter.accept(element, value);
        }
        catch (ClassCastException e) {
            logger.warning(e.getMessage());
        }
    }

    @Override
    public Object getValueAt(int r, int c) {
        Column column = this.columns.get(c);
        Object element = this.elements.get(r);
        Function<?, ?> getter = column.getter;
        try {
            Function<?, ?> typedGetter = getter;
            Object result = typedGetter.apply(element);
            return result;
        }
        catch (ClassCastException e) {
            logger.warning(e.getMessage());
            return null;
        }
    }

    private static class Column {
        String name;
        Class<?> type;
        Function<?, ?> getter;
        BiConsumer<?, ?> setter;

        private Column() {
        }
    }
}

